/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.domain;

import com.google.common.base.Preconditions;
import com.google.gson.annotations.SerializedName;

public class IngressRule
implements Comparable<IngressRule> {
    private String account;
    @SerializedName(value="cidr")
    private String CIDR;
    @SerializedName(value="endport")
    private int endPort = -1;
    @SerializedName(value="icmpcode")
    private int ICMPCode = -1;
    @SerializedName(value="icmptype")
    private int ICMPType = -1;
    private String protocol;
    @SerializedName(value="ruleid")
    private long id = -1L;
    @SerializedName(value="securitygroupname")
    private String securityGroupName;
    @SerializedName(value="startport")
    private int startPort = -1;

    public static Builder builder() {
        return new Builder();
    }

    IngressRule() {
    }

    public IngressRule(String account, String CIDR, int endPort, int iCMPCode, int iCMPType, String protocol, long id, String securityGroupName, int startPort) {
        if (account == null) {
            Preconditions.checkArgument((securityGroupName == null && CIDR != null ? 1 : 0) != 0, (Object)"if you do not specify an account and security group, you must specify a CIDR range");
        }
        if (CIDR == null) {
            Preconditions.checkArgument((account != null && securityGroupName != null ? 1 : 0) != 0, (Object)"if you do not specify an account and security group, you must specify a CIDR range");
        }
        this.account = account;
        this.CIDR = CIDR;
        this.endPort = endPort;
        this.ICMPCode = iCMPCode;
        this.ICMPType = iCMPType;
        this.protocol = protocol;
        this.id = id;
        this.securityGroupName = securityGroupName;
        this.startPort = startPort;
    }

    public String getAccount() {
        return this.account;
    }

    public String getCIDR() {
        return this.CIDR;
    }

    public int getEndPort() {
        return this.endPort;
    }

    public int getICMPCode() {
        return this.ICMPCode;
    }

    public int getICMPType() {
        return this.ICMPType;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public long getId() {
        return this.id;
    }

    public String getSecurityGroupName() {
        return this.securityGroupName;
    }

    public int getStartPort() {
        return this.startPort;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.CIDR == null ? 0 : this.CIDR.hashCode());
        result = 31 * result + this.ICMPCode;
        result = 31 * result + this.ICMPType;
        result = 31 * result + (this.account == null ? 0 : this.account.hashCode());
        result = 31 * result + this.endPort;
        result = 31 * result + (int)(this.id ^ this.id >>> 32);
        result = 31 * result + (this.protocol == null ? 0 : this.protocol.hashCode());
        result = 31 * result + (this.securityGroupName == null ? 0 : this.securityGroupName.hashCode());
        result = 31 * result + this.startPort;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        IngressRule other = (IngressRule)obj;
        if (this.CIDR == null ? other.CIDR != null : !this.CIDR.equals(other.CIDR)) {
            return false;
        }
        if (this.ICMPCode != other.ICMPCode) {
            return false;
        }
        if (this.ICMPType != other.ICMPType) {
            return false;
        }
        if (this.account == null ? other.account != null : !this.account.equals(other.account)) {
            return false;
        }
        if (this.endPort != other.endPort) {
            return false;
        }
        if (this.id != other.id) {
            return false;
        }
        if (this.protocol == null ? other.protocol != null : !this.protocol.equals(other.protocol)) {
            return false;
        }
        if (this.securityGroupName == null ? other.securityGroupName != null : !this.securityGroupName.equals(other.securityGroupName)) {
            return false;
        }
        return this.startPort == other.startPort;
    }

    public String toString() {
        return "IngressRule{account='" + this.account + '\'' + ", CIDR='" + this.CIDR + '\'' + ", endPort=" + this.endPort + ", ICMPCode=" + this.ICMPCode + ", ICMPType=" + this.ICMPType + ", protocol='" + this.protocol + '\'' + ", id=" + this.id + ", securityGroupName='" + this.securityGroupName + '\'' + ", startPort=" + this.startPort + '}';
    }

    @Override
    public int compareTo(IngressRule arg0) {
        return new Long(this.id).compareTo(arg0.getId());
    }

    public static class Builder {
        private String account;
        private String CIDR;
        private int endPort = -1;
        private int ICMPCode = -1;
        private int ICMPType = -1;
        private String protocol;
        private long id = -1L;
        private String securityGroupName;
        private int startPort = -1;

        public Builder account(String account) {
            this.account = account;
            return this;
        }

        public Builder CIDR(String CIDR) {
            this.CIDR = CIDR;
            return this;
        }

        public Builder endPort(int endPort) {
            this.endPort = endPort;
            return this;
        }

        public Builder ICMPCode(int ICMPCode) {
            this.ICMPCode = ICMPCode;
            return this;
        }

        public Builder ICMPType(int ICMPType) {
            this.ICMPType = ICMPType;
            return this;
        }

        public Builder protocol(String protocol) {
            this.protocol = protocol;
            return this;
        }

        public Builder id(long id) {
            this.id = id;
            return this;
        }

        public Builder securityGroupName(String securityGroupName) {
            this.securityGroupName = securityGroupName;
            return this;
        }

        public Builder startPort(int startPort) {
            this.startPort = startPort;
            return this;
        }

        public IngressRule build() {
            return new IngressRule(this.account, this.CIDR, this.endPort, this.ICMPCode, this.ICMPType, this.protocol, this.id, this.securityGroupName, this.startPort);
        }
    }
}

