/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.domain;

import com.google.common.base.CaseFormat;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.gson.annotations.SerializedName;
import java.util.Date;
import java.util.Map;
import org.jclouds.cloudstack.domain.VirtualMachine;

public class Volume
implements Comparable<Volume> {
    private long id;
    private String account;
    private Date attached;
    private Date created;
    private boolean destroyed;
    @SerializedName(value="deviceid")
    private long deviceId;
    @SerializedName(value="diskofferingdisplaytext")
    private String diskOfferingDisplayText;
    @SerializedName(value="diskofferingid")
    private long diskOfferingId;
    @SerializedName(value="diskofferingname")
    private String diskOfferingName;
    private String domain;
    @SerializedName(value="domainid")
    private long domainId;
    private String hypervisor;
    @SerializedName(value="isextractable")
    private boolean isExtractable;
    @SerializedName(value="jobid")
    private long jobId;
    @SerializedName(value="jobstatus")
    private String jobStatus;
    private String name;
    @SerializedName(value="serviceofferingdisplaytext")
    private String serviceOfferingDisplayText;
    @SerializedName(value="serviceofferingid")
    private long serviceOfferingId;
    @SerializedName(value="serviceofferingname")
    private String serviceOfferingName;
    private long size;
    @SerializedName(value="snapshotid")
    private long snapshotId;
    private State state;
    private String storage;
    @SerializedName(value="storagetype")
    private String storageType;
    private Type type;
    @SerializedName(value="virtualmachineid")
    private long virtualMachineId;
    @SerializedName(value="vmdisplayname")
    private String vmDisplayName;
    @SerializedName(value="vmname")
    private String vmName;
    @SerializedName(value="vmstate")
    private VirtualMachine.State vmState;
    @SerializedName(value="zoneid")
    private long zoneId;
    @SerializedName(value="zonename")
    private String zoneName;

    public static Builder builder() {
        return new Builder();
    }

    public Volume(long id, String account, Date attached, Date created, boolean destroyed, long deviceId, String diskOfferingDisplayText, long diskOfferingId, String diskOfferingName, String domain, long domainId, String hypervisor, boolean extractable, long jobId, String jobStatus, String name, String serviceOfferingDisplayText, long serviceOfferingId, String serviceOfferingName, long size, long snapshotId, State state, String storage, String storageType, Type type, long virtualMachineId, String vmDisplayName, String vmName, VirtualMachine.State vmState, long zoneId, String zoneName) {
        this.id = id;
        this.account = account;
        this.attached = attached;
        this.created = created;
        this.destroyed = destroyed;
        this.deviceId = deviceId;
        this.diskOfferingDisplayText = diskOfferingDisplayText;
        this.diskOfferingId = diskOfferingId;
        this.diskOfferingName = diskOfferingName;
        this.domain = domain;
        this.domainId = domainId;
        this.hypervisor = hypervisor;
        this.isExtractable = extractable;
        this.jobId = jobId;
        this.jobStatus = jobStatus;
        this.name = name;
        this.serviceOfferingDisplayText = serviceOfferingDisplayText;
        this.serviceOfferingId = serviceOfferingId;
        this.serviceOfferingName = serviceOfferingName;
        this.size = size;
        this.snapshotId = snapshotId;
        this.state = state;
        this.storage = storage;
        this.storageType = storageType;
        this.type = type;
        this.virtualMachineId = virtualMachineId;
        this.vmDisplayName = vmDisplayName;
        this.vmName = vmName;
        this.vmState = vmState;
        this.zoneId = zoneId;
        this.zoneName = zoneName;
    }

    Volume() {
    }

    public long getId() {
        return this.id;
    }

    public Date getAttached() {
        return this.attached;
    }

    public Date getCreated() {
        return this.created;
    }

    public boolean isDestroyed() {
        return this.destroyed;
    }

    public long getDeviceId() {
        return this.deviceId;
    }

    public String getDiskOfferingDisplayText() {
        return this.diskOfferingDisplayText;
    }

    public long getDiskOfferingId() {
        return this.diskOfferingId;
    }

    public String getDiskOfferingName() {
        return this.diskOfferingName;
    }

    public String getDomain() {
        return this.domain;
    }

    public long getDomainId() {
        return this.domainId;
    }

    public String getHypervisor() {
        return this.hypervisor;
    }

    public boolean isExtractable() {
        return this.isExtractable;
    }

    public long getJobId() {
        return this.jobId;
    }

    public String getJobStatus() {
        return this.jobStatus;
    }

    public String getName() {
        return this.name;
    }

    public String getServiceOfferingDisplayText() {
        return this.serviceOfferingDisplayText;
    }

    public long getServiceOfferingId() {
        return this.serviceOfferingId;
    }

    public String getServiceOfferingName() {
        return this.serviceOfferingName;
    }

    public long getSize() {
        return this.size;
    }

    public long getSnapshotId() {
        return this.snapshotId;
    }

    public State getState() {
        return this.state;
    }

    public String getStorage() {
        return this.storage;
    }

    public String getStorageType() {
        return this.storageType;
    }

    public Type getType() {
        return this.type;
    }

    public long getVirtualMachineId() {
        return this.virtualMachineId;
    }

    public String getVmDisplayName() {
        return this.vmDisplayName;
    }

    public String getVmName() {
        return this.vmName;
    }

    public VirtualMachine.State getVmState() {
        return this.vmState;
    }

    public long getZoneId() {
        return this.zoneId;
    }

    public String getZoneName() {
        return this.zoneName;
    }

    public String getAccount() {
        return this.account;
    }

    @Override
    public int compareTo(Volume volume) {
        return Long.valueOf(this.id).compareTo(volume.id);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Volume volume = (Volume)o;
        if (this.deviceId != volume.deviceId) {
            return false;
        }
        if (this.diskOfferingId != volume.diskOfferingId) {
            return false;
        }
        if (this.domainId != volume.domainId) {
            return false;
        }
        if (this.id != volume.id) {
            return false;
        }
        if (this.isExtractable != volume.isExtractable) {
            return false;
        }
        if (this.jobId != volume.jobId) {
            return false;
        }
        if (this.serviceOfferingId != volume.serviceOfferingId) {
            return false;
        }
        if (this.size != volume.size) {
            return false;
        }
        if (this.snapshotId != volume.snapshotId) {
            return false;
        }
        if (this.virtualMachineId != volume.virtualMachineId) {
            return false;
        }
        if (this.zoneId != volume.zoneId) {
            return false;
        }
        if (this.attached != null ? !this.attached.equals(volume.attached) : volume.attached != null) {
            return false;
        }
        if (!this.created.equals(volume.created)) {
            return false;
        }
        if (this.diskOfferingDisplayText != null ? !this.diskOfferingDisplayText.equals(volume.diskOfferingDisplayText) : volume.diskOfferingDisplayText != null) {
            return false;
        }
        if (this.diskOfferingName != null ? !this.diskOfferingName.equals(volume.diskOfferingName) : volume.diskOfferingName != null) {
            return false;
        }
        if (!this.domain.equals(volume.domain)) {
            return false;
        }
        if (this.hypervisor != null ? !this.hypervisor.equals(volume.hypervisor) : volume.hypervisor != null) {
            return false;
        }
        if (this.jobStatus != null ? !this.jobStatus.equals(volume.jobStatus) : volume.jobStatus != null) {
            return false;
        }
        if (this.name != null ? !this.name.equals(volume.name) : volume.name != null) {
            return false;
        }
        if (this.serviceOfferingDisplayText != null ? !this.serviceOfferingDisplayText.equals(volume.serviceOfferingDisplayText) : volume.serviceOfferingDisplayText != null) {
            return false;
        }
        if (this.serviceOfferingName != null ? !this.serviceOfferingName.equals(volume.serviceOfferingName) : volume.serviceOfferingName != null) {
            return false;
        }
        if (this.state != null ? !this.state.equals((Object)volume.state) : volume.state != null) {
            return false;
        }
        if (this.storage != null ? !this.storage.equals(volume.storage) : volume.storage != null) {
            return false;
        }
        if (this.storageType != null ? !this.storageType.equals(volume.storageType) : volume.storageType != null) {
            return false;
        }
        if (this.type != null ? !this.type.equals((Object)volume.type) : volume.type != null) {
            return false;
        }
        if (this.vmDisplayName != null ? !this.vmDisplayName.equals(volume.vmDisplayName) : volume.vmDisplayName != null) {
            return false;
        }
        if (this.vmName != null ? !this.vmName.equals(volume.vmName) : volume.vmName != null) {
            return false;
        }
        if (this.vmState != volume.vmState) {
            return false;
        }
        if (this.zoneName != null ? !this.zoneName.equals(volume.zoneName) : volume.zoneName != null) {
            return false;
        }
        return !(this.account == null ? volume.account != null : !this.account.equals(volume.account));
    }

    public int hashCode() {
        int result = (int)(this.id ^ this.id >>> 32);
        result = 31 * result + (this.attached != null ? this.attached.hashCode() : 0);
        result = 31 * result + this.created.hashCode();
        result = 31 * result + (int)(this.deviceId ^ this.deviceId >>> 32);
        result = 31 * result + (this.diskOfferingDisplayText != null ? this.diskOfferingDisplayText.hashCode() : 0);
        result = 31 * result + (int)(this.diskOfferingId ^ this.diskOfferingId >>> 32);
        result = 31 * result + (this.diskOfferingName != null ? this.diskOfferingName.hashCode() : 0);
        result = 31 * result + this.domain.hashCode();
        result = 31 * result + (int)(this.domainId ^ this.domainId >>> 32);
        result = 31 * result + (this.hypervisor != null ? this.hypervisor.hashCode() : 0);
        result = 31 * result + (this.isExtractable ? 1 : 0);
        result = 31 * result + (int)(this.jobId ^ this.jobId >>> 32);
        result = 31 * result + (this.jobStatus != null ? this.jobStatus.hashCode() : 0);
        result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
        result = 31 * result + (this.serviceOfferingDisplayText != null ? this.serviceOfferingDisplayText.hashCode() : 0);
        result = 31 * result + (int)(this.serviceOfferingId ^ this.serviceOfferingId >>> 32);
        result = 31 * result + (this.serviceOfferingName != null ? this.serviceOfferingName.hashCode() : 0);
        result = 31 * result + (int)(this.size ^ this.size >>> 32);
        result = 31 * result + (int)(this.snapshotId ^ this.snapshotId >>> 32);
        result = 31 * result + (this.state != null ? this.state.hashCode() : 0);
        result = 31 * result + (this.storage != null ? this.storage.hashCode() : 0);
        result = 31 * result + (this.storageType != null ? this.storageType.hashCode() : 0);
        result = 31 * result + (this.type != null ? this.type.hashCode() : 0);
        result = 31 * result + (int)(this.virtualMachineId ^ this.virtualMachineId >>> 32);
        result = 31 * result + (this.vmDisplayName != null ? this.vmDisplayName.hashCode() : 0);
        result = 31 * result + (this.vmName != null ? this.vmName.hashCode() : 0);
        result = 31 * result + (this.vmState != null ? this.vmState.hashCode() : 0);
        result = 31 * result + (int)(this.zoneId ^ this.zoneId >>> 32);
        result = 31 * result + (this.zoneName != null ? this.zoneName.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "Volume{id=" + this.id + ", account='" + this.account + '\'' + ", attached=" + this.attached + ", created=" + this.created + ", destroyed=" + this.destroyed + ", deviceId=" + this.deviceId + ", diskOfferingDisplayText='" + this.diskOfferingDisplayText + '\'' + ", diskOfferingId=" + this.diskOfferingId + ", diskOfferingName='" + this.diskOfferingName + '\'' + ", domain='" + this.domain + '\'' + ", domainId=" + this.domainId + ", hypervisor='" + this.hypervisor + '\'' + ", isExtractable=" + this.isExtractable + ", jobId=" + this.jobId + ", jobStatus='" + this.jobStatus + '\'' + ", name='" + this.name + '\'' + ", serviceOfferingDisplayText='" + this.serviceOfferingDisplayText + '\'' + ", serviceOfferingId=" + this.serviceOfferingId + ", serviceOfferingName='" + this.serviceOfferingName + '\'' + ", size=" + this.size + ", snapshotId=" + this.snapshotId + ", state=" + (Object)((Object)this.state) + ", storage='" + this.storage + '\'' + ", storageType='" + this.storageType + '\'' + ", type=" + (Object)((Object)this.type) + ", virtualMachineId=" + this.virtualMachineId + ", vmDisplayName='" + this.vmDisplayName + '\'' + ", vmName='" + this.vmName + '\'' + ", vmState=" + (Object)((Object)this.vmState) + ", zoneId=" + this.zoneId + ", zoneName='" + this.zoneName + '\'' + '}';
    }

    public static enum Type {
        ROOT(0),
        DATADISK(1),
        UNRECOGNIZED(Integer.MAX_VALUE);

        private int code;
        private static final Map<Integer, Type> INDEX;

        private Type(int code) {
            this.code = code;
        }

        public String toString() {
            return this.name().toLowerCase();
        }

        public static Type fromValue(String resourceType) {
            Integer code = new Integer((String)Preconditions.checkNotNull((Object)resourceType, (Object)"resourcetype"));
            return INDEX.containsKey(code) ? INDEX.get(code) : UNRECOGNIZED;
        }

        static {
            INDEX = Maps.uniqueIndex((Iterable)ImmutableSet.copyOf((Object[])Type.values()), (Function)new Function<Type, Integer>(){

                public Integer apply(Type input) {
                    return input.code;
                }
            });
        }
    }

    public static enum State {
        ALLOCATED,
        CREATING,
        READY,
        DESTROYED,
        FAILED,
        UNRECOGNIZED;


        public String toString() {
            return CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.UPPER_CAMEL, this.name());
        }

        public static State fromValue(String state) {
            try {
                return State.valueOf(CaseFormat.UPPER_CAMEL.to(CaseFormat.UPPER_UNDERSCORE, (String)Preconditions.checkNotNull((Object)state, (Object)"state")));
            }
            catch (IllegalArgumentException e) {
                return UNRECOGNIZED;
            }
        }
    }

    public static class Builder {
        private long id;
        private String account;
        private Date attached;
        private Date created;
        private boolean destroyed;
        private long deviceId;
        private String diskOfferingDisplayText;
        private long diskOfferingId;
        private String diskOfferingName;
        private String domain;
        private long domainId;
        private String hypervisor;
        private boolean isExtractable;
        private long jobId;
        private String jobStatus;
        private String name;
        private String serviceOfferingDisplayText;
        private long serviceOfferingId;
        private String serviceOfferingName;
        private long size;
        private long snapshotId;
        private State state;
        private String storage;
        private String storageType;
        private Type type;
        private long virtualMachineId;
        private String vmDisplayName;
        private String vmName;
        private VirtualMachine.State vmState;
        private long zoneId;
        private String zoneName;

        public Builder id(long id) {
            this.id = id;
            return this;
        }

        public Builder account(String account) {
            this.account = account;
            return this;
        }

        public Builder attached(Date attached) {
            this.attached = attached;
            return this;
        }

        public Builder created(Date created) {
            this.created = created;
            return this;
        }

        public Builder destroyed(boolean destroyed) {
            this.destroyed = destroyed;
            return this;
        }

        public Builder deviceId(long deviceId) {
            this.deviceId = deviceId;
            return this;
        }

        public Builder diskOfferingDisplayText(String diskOfferingDisplayText) {
            this.diskOfferingDisplayText = diskOfferingDisplayText;
            return this;
        }

        public Builder diskOfferingId(long diskOfferingId) {
            this.diskOfferingId = diskOfferingId;
            return this;
        }

        public Builder diskOfferingName(String diskOfferingName) {
            this.diskOfferingName = diskOfferingName;
            return this;
        }

        public Builder domain(String domain) {
            this.domain = domain;
            return this;
        }

        public Builder domainId(long domainId) {
            this.domainId = domainId;
            return this;
        }

        public Builder hypervisor(String hypervisor) {
            this.hypervisor = hypervisor;
            return this;
        }

        public Builder isExtractable(boolean isExtractable) {
            this.isExtractable = isExtractable;
            return this;
        }

        public Builder jobId(long jobId) {
            this.jobId = jobId;
            return this;
        }

        public Builder jobStatus(String jobStatus) {
            this.jobStatus = jobStatus;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder serviceOfferingDisplayText(String serviceOfferingDisplayText) {
            this.serviceOfferingDisplayText = serviceOfferingDisplayText;
            return this;
        }

        public Builder serviceOfferingId(long serviceOfferingId) {
            this.serviceOfferingId = serviceOfferingId;
            return this;
        }

        public Builder serviceOfferingName(String serviceOfferingName) {
            this.serviceOfferingName = serviceOfferingName;
            return this;
        }

        public Builder size(long size) {
            this.size = size;
            return this;
        }

        public Builder snapshotId(long snapshotId) {
            this.snapshotId = snapshotId;
            return this;
        }

        public Builder state(State state) {
            this.state = state;
            return this;
        }

        public Builder storage(String storage) {
            this.storage = storage;
            return this;
        }

        public Builder storageType(String storageType) {
            this.storageType = storageType;
            return this;
        }

        public Builder type(Type type) {
            this.type = type;
            return this;
        }

        public Builder virtualMachineId(long virtualMachineId) {
            this.virtualMachineId = virtualMachineId;
            return this;
        }

        public Builder vmDisplayName(String vmDisplayName) {
            this.vmDisplayName = vmDisplayName;
            return this;
        }

        public Builder vmName(String vmName) {
            this.vmName = vmName;
            return this;
        }

        public Builder vmState(VirtualMachine.State vmState) {
            this.vmState = vmState;
            return this;
        }

        public Builder zoneId(long zoneId) {
            this.zoneId = zoneId;
            return this;
        }

        public Builder zoneName(String zoneName) {
            this.zoneName = zoneName;
            return this;
        }

        public Volume build() {
            return new Volume(this.id, this.account, this.attached, this.created, this.destroyed, this.deviceId, this.diskOfferingDisplayText, this.diskOfferingId, this.diskOfferingName, this.domain, this.domainId, this.hypervisor, this.isExtractable, this.jobId, this.jobStatus, this.name, this.serviceOfferingDisplayText, this.serviceOfferingId, this.serviceOfferingName, this.size, this.snapshotId, this.state, this.storage, this.storageType, this.type, this.virtualMachineId, this.vmDisplayName, this.vmName, this.vmState, this.zoneId, this.zoneName);
        }
    }
}

