/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.domain;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.gson.annotations.SerializedName;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;
import org.jclouds.cloudstack.domain.NetworkType;

public class Zone
implements Comparable<Zone> {
    private long id;
    private String description;
    @SerializedName(value="displaytext")
    private String displayText;
    @SerializedName(value="dns1")
    private String DNS1;
    @SerializedName(value="dns2")
    private String DNS2;
    private String domain;
    @Nullable
    @SerializedName(value="domainid")
    private long domainId;
    @SerializedName(value="guestcidraddress")
    private String guestCIDRAddress;
    @SerializedName(value="internaldns1")
    private String internalDNS1;
    @SerializedName(value="internaldns2")
    private String internalDNS2;
    private String name;
    @SerializedName(value="networktype")
    private NetworkType networkType;
    @SerializedName(value="vlan")
    private String VLAN;
    @SerializedName(value="securitygroupsenabled")
    private boolean securityGroupsEnabled;
    @SerializedName(value="allocationstate")
    private String allocationState;
    @SerializedName(value="dhcpprovider")
    private String dhcpProvider;
    @SerializedName(value="zonetoken")
    private String zoneToken;

    public static Builder builder() {
        return new Builder();
    }

    Zone() {
    }

    public Zone(long id, String description, String displayText, List<String> DNS, String domain, long domainId, String guestCIDRAddress, List<String> internalDNS, String name, NetworkType networkType, String vLAN, boolean securityGroupsEnabled, String allocationState, String dhcpProvider, String zoneToken) {
        this.id = id;
        this.description = description;
        this.displayText = displayText;
        this.DNS1 = ((List)Preconditions.checkNotNull(DNS, (Object)"DNS")).size() > 0 ? DNS.get(0) : null;
        this.DNS2 = DNS.size() > 1 ? DNS.get(1) : null;
        this.domain = domain;
        this.domainId = domainId;
        this.guestCIDRAddress = guestCIDRAddress;
        this.internalDNS1 = ((List)Preconditions.checkNotNull(internalDNS, (Object)"internalDNS")).size() > 0 ? internalDNS.get(0) : null;
        this.internalDNS2 = internalDNS.size() > 1 ? internalDNS.get(1) : null;
        this.name = name;
        this.networkType = networkType;
        this.VLAN = vLAN;
        this.securityGroupsEnabled = securityGroupsEnabled;
        this.allocationState = allocationState;
        this.dhcpProvider = dhcpProvider;
        this.zoneToken = zoneToken;
    }

    public long getId() {
        return this.id;
    }

    public String getDescription() {
        return this.description;
    }

    public String getDisplayText() {
        return this.displayText;
    }

    public List<String> getDNS() {
        ImmutableList.Builder builder = ImmutableList.builder();
        if (this.DNS1 != null && !"".equals(this.DNS1)) {
            builder.add((Object)this.DNS1);
        }
        if (this.DNS2 != null && !"".equals(this.DNS2)) {
            builder.add((Object)this.DNS2);
        }
        return builder.build();
    }

    public String getDomain() {
        return this.domain;
    }

    @Nullable
    public long getDomainId() {
        return this.domainId;
    }

    public String getGuestCIDRAddress() {
        return this.guestCIDRAddress;
    }

    public List<String> getInternalDNS() {
        ImmutableList.Builder builder = ImmutableList.builder();
        if (this.internalDNS1 != null && !"".equals(this.internalDNS1)) {
            builder.add((Object)this.internalDNS1);
        }
        if (this.internalDNS2 != null && !"".equals(this.internalDNS2)) {
            builder.add((Object)this.internalDNS2);
        }
        return builder.build();
    }

    public String getName() {
        return this.name;
    }

    public NetworkType getNetworkType() {
        return this.networkType;
    }

    public String getVLAN() {
        return this.VLAN;
    }

    public boolean isSecurityGroupsEnabled() {
        return this.securityGroupsEnabled;
    }

    public String getAllocationState() {
        return this.allocationState;
    }

    public String getDhcpProvider() {
        return this.dhcpProvider;
    }

    public String getZoneToken() {
        return this.zoneToken;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.DNS1 == null ? 0 : this.DNS1.hashCode());
        result = 31 * result + (this.DNS2 == null ? 0 : this.DNS2.hashCode());
        result = 31 * result + (this.VLAN == null ? 0 : this.VLAN.hashCode());
        result = 31 * result + (this.description == null ? 0 : this.description.hashCode());
        result = 31 * result + (this.displayText == null ? 0 : this.displayText.hashCode());
        result = 31 * result + (this.domain == null ? 0 : this.domain.hashCode());
        result = 31 * result + (int)(this.domainId ^ this.domainId >>> 32);
        result = 31 * result + (this.guestCIDRAddress == null ? 0 : this.guestCIDRAddress.hashCode());
        result = 31 * result + (int)(this.id ^ this.id >>> 32);
        result = 31 * result + (this.internalDNS1 == null ? 0 : this.internalDNS1.hashCode());
        result = 31 * result + (this.internalDNS2 == null ? 0 : this.internalDNS2.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.allocationState == null ? 0 : this.allocationState.hashCode());
        result = 31 * result + (this.networkType == null ? 0 : this.networkType.hashCode());
        result = 31 * result + (this.securityGroupsEnabled ? 1231 : 1237);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Zone other = (Zone)obj;
        if (this.DNS1 == null ? other.DNS1 != null : !this.DNS1.equals(other.DNS1)) {
            return false;
        }
        if (this.DNS2 == null ? other.DNS2 != null : !this.DNS2.equals(other.DNS2)) {
            return false;
        }
        if (this.VLAN == null ? other.VLAN != null : !this.VLAN.equals(other.VLAN)) {
            return false;
        }
        if (this.description == null ? other.description != null : !this.description.equals(other.description)) {
            return false;
        }
        if (this.allocationState == null ? other.allocationState != null : !this.allocationState.equals(other.allocationState)) {
            return false;
        }
        if (this.displayText == null ? other.displayText != null : !this.displayText.equals(other.displayText)) {
            return false;
        }
        if (this.domain == null ? other.domain != null : !this.domain.equals(other.domain)) {
            return false;
        }
        if (this.domainId != other.domainId) {
            return false;
        }
        if (this.guestCIDRAddress == null ? other.guestCIDRAddress != null : !this.guestCIDRAddress.equals(other.guestCIDRAddress)) {
            return false;
        }
        if (this.id != other.id) {
            return false;
        }
        if (this.internalDNS1 == null ? other.internalDNS1 != null : !this.internalDNS1.equals(other.internalDNS1)) {
            return false;
        }
        if (this.internalDNS2 == null ? other.internalDNS2 != null : !this.internalDNS2.equals(other.internalDNS2)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.networkType == null ? other.networkType != null : !this.networkType.equals((Object)other.networkType)) {
            return false;
        }
        return this.securityGroupsEnabled == other.securityGroupsEnabled;
    }

    public String toString() {
        return "Zone{id=" + this.id + ", description='" + this.description + '\'' + ", displayText='" + this.displayText + '\'' + ", DNS1='" + this.DNS1 + '\'' + ", DNS2='" + this.DNS2 + '\'' + ", domain='" + this.domain + '\'' + ", domainId=" + this.domainId + ", guestCIDRAddress='" + this.guestCIDRAddress + '\'' + ", internalDNS1='" + this.internalDNS1 + '\'' + ", internalDNS2='" + this.internalDNS2 + '\'' + ", name='" + this.name + '\'' + ", networkType=" + (Object)((Object)this.networkType) + ", VLAN='" + this.VLAN + '\'' + ", securityGroupsEnabled=" + this.securityGroupsEnabled + ", allocationState='" + this.allocationState + '\'' + ", dhcpProvider='" + this.dhcpProvider + '\'' + ", zoneToken='" + this.zoneToken + '\'' + '}';
    }

    @Override
    public int compareTo(Zone arg0) {
        return new Long(this.id).compareTo(arg0.getId());
    }

    public static class Builder {
        private long id;
        private String description;
        private String displayText;
        private List<String> DNS = ImmutableList.of();
        private String domain;
        private long domainId;
        private String guestCIDRAddress;
        private List<String> internalDNS = ImmutableList.of();
        private String name;
        private NetworkType networkType;
        private String VLAN;
        private boolean securityGroupsEnabled;
        private String allocationState;
        private String dhcpProvider;
        private String zoneToken;

        public Builder id(long id) {
            this.id = id;
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Builder displayText(String displayText) {
            this.displayText = displayText;
            return this;
        }

        public Builder DNS(List<String> DNS) {
            this.DNS = ImmutableList.copyOf((Collection)((Collection)Preconditions.checkNotNull(DNS, (Object)"DNS")));
            return this;
        }

        public Builder domain(String domain) {
            this.domain = domain;
            return this;
        }

        public Builder domainId(long domainId) {
            this.domainId = domainId;
            return this;
        }

        public Builder guestCIDRAddress(String guestCIDRAddress) {
            this.guestCIDRAddress = guestCIDRAddress;
            return this;
        }

        public Builder internalDNS(List<String> internalDNS) {
            this.internalDNS = ImmutableList.copyOf((Collection)((Collection)Preconditions.checkNotNull(internalDNS, (Object)"internalDNS")));
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder networkType(NetworkType networkType) {
            this.networkType = networkType;
            return this;
        }

        public Builder VLAN(String VLAN) {
            this.VLAN = VLAN;
            return this;
        }

        public Builder securityGroupsEnabled(boolean securityGroupsEnabled) {
            this.securityGroupsEnabled = securityGroupsEnabled;
            return this;
        }

        public Builder allocationState(String allocationState) {
            this.allocationState = allocationState;
            return this;
        }

        public Builder dhcpProvider(String dhcpProvider) {
            this.dhcpProvider = dhcpProvider;
            return this;
        }

        public Builder zoneToken(String zoneToken) {
            this.zoneToken = zoneToken;
            return this;
        }

        public Zone build() {
            return new Zone(this.id, this.description, this.displayText, this.DNS, this.domain, this.domainId, this.guestCIDRAddress, this.internalDNS, this.name, this.networkType, this.VLAN, this.securityGroupsEnabled, this.allocationState, this.dhcpProvider, this.zoneToken);
        }
    }
}

