/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.features;

import com.google.common.util.concurrent.ListenableFuture;
import java.util.Set;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.QueryParam;
import org.jclouds.cloudstack.domain.Cluster;
import org.jclouds.cloudstack.domain.Host;
import org.jclouds.cloudstack.filters.QuerySigner;
import org.jclouds.cloudstack.options.AddClusterOptions;
import org.jclouds.cloudstack.options.AddHostOptions;
import org.jclouds.cloudstack.options.AddSecondaryStorageOptions;
import org.jclouds.cloudstack.options.DeleteHostOptions;
import org.jclouds.cloudstack.options.ListClustersOptions;
import org.jclouds.cloudstack.options.ListHostsOptions;
import org.jclouds.cloudstack.options.UpdateClusterOptions;
import org.jclouds.cloudstack.options.UpdateHostOptions;
import org.jclouds.rest.annotations.ExceptionParser;
import org.jclouds.rest.annotations.QueryParams;
import org.jclouds.rest.annotations.RequestFilters;
import org.jclouds.rest.annotations.SelectJson;
import org.jclouds.rest.functions.ReturnEmptySetOnNotFoundOr404;

@RequestFilters(value={QuerySigner.class})
@QueryParams(keys={"response"}, values={"json"})
public interface GlobalHostAsyncClient {
    @GET
    @QueryParams(keys={"command"}, values={"listHosts"})
    @SelectJson(value="host")
    @Consumes(value={"application/json"})
    @ExceptionParser(value=ReturnEmptySetOnNotFoundOr404.class)
    public ListenableFuture<Set<Host>> listHosts(ListHostsOptions ... var1);

    @GET
    @QueryParams(keys={"command"}, values={"addHost"})
    @SelectJson(value="host")
    @Consumes(value={"application/json"})
    public ListenableFuture<Host> addHost(@QueryParam(value="zoneid") long var1, @QueryParam(value="url") String var3, @QueryParam(value="hypervisor") String var4, @QueryParam(value="username") String var5, @QueryParam(value="password") String var6, AddHostOptions ... var7);

    @GET
    @QueryParams(keys={"command"}, values={"updateHost"})
    @SelectJson(value="host")
    @Consumes(value={"application/json"})
    public ListenableFuture<Host> updateHost(@QueryParam(value="id") long var1, UpdateHostOptions ... var3);

    @GET
    @QueryParams(keys={"command"}, values={"updateHostPassword"})
    @Consumes(value={"application/json"})
    public ListenableFuture<Void> updateHostPassword(@QueryParam(value="hostid") long var1, @QueryParam(value="username") String var3, @QueryParam(value="password") String var4);

    @GET
    @QueryParams(keys={"command"}, values={"deleteHost"})
    @Consumes(value={"application/json"})
    public ListenableFuture<Void> deleteHost(@QueryParam(value="id") long var1, DeleteHostOptions ... var3);

    @GET
    @QueryParams(keys={"command"}, values={"prepareHostForMaintenance"})
    @SelectJson(value="jobid")
    @Consumes(value={"application/json"})
    public ListenableFuture<Long> prepareHostForMaintenance(@QueryParam(value="id") long var1);

    @GET
    @QueryParams(keys={"command"}, values={"cancelHostMaintenance"})
    @SelectJson(value="jobid")
    @Consumes(value={"application/json"})
    public ListenableFuture<Long> cancelHostMaintenance(@QueryParam(value="id") long var1);

    @GET
    @QueryParams(keys={"command"}, values={"reconnectHost"})
    @SelectJson(value="jobid")
    @Consumes(value={"application/json"})
    public ListenableFuture<Long> reconnectHost(@QueryParam(value="id") long var1);

    @GET
    @QueryParams(keys={"command"}, values={"addSecondaryStorage"})
    @SelectJson(value="host")
    @Consumes(value={"application/json"})
    public ListenableFuture<Host> addSecondaryStorage(@QueryParam(value="url") String var1, AddSecondaryStorageOptions ... var2);

    @GET
    @QueryParams(keys={"command"}, values={"listClusters"})
    @SelectJson(value="cluster")
    @Consumes(value={"application/json"})
    @ExceptionParser(value=ReturnEmptySetOnNotFoundOr404.class)
    public ListenableFuture<Set<Cluster>> listClusters(ListClustersOptions ... var1);

    @GET
    @QueryParams(keys={"command"}, values={"addCluster"})
    @SelectJson(value="cluster")
    @Consumes(value={"application/json"})
    public ListenableFuture<Cluster> addCluster(@QueryParam(value="zoneid") long var1, @QueryParam(value="clustername") String var3, @QueryParam(value="clustertype") Host.ClusterType var4, @QueryParam(value="hypervisor") String var5, AddClusterOptions ... var6);

    @GET
    @QueryParams(keys={"command"}, values={"updateCluster"})
    @SelectJson(value="cluster")
    @Consumes(value={"application/json"})
    public ListenableFuture<Cluster> updateCluster(@QueryParam(value="id") long var1, UpdateClusterOptions ... var3);

    @GET
    @QueryParams(keys={"command"}, values={"updateHostPassword"})
    @SelectJson(value="cluster")
    @Consumes(value={"application/json"})
    public ListenableFuture<Void> updateClusterPassword(@QueryParam(value="clusterid") long var1, @QueryParam(value="username") String var3, @QueryParam(value="password") String var4);

    @GET
    @QueryParams(keys={"command"}, values={"deleteCluster"})
    @Consumes(value={"application/json"})
    public ListenableFuture<Void> deleteCluster(@QueryParam(value="id") long var1);
}

