/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.features;

import com.google.common.util.concurrent.ListenableFuture;
import java.util.Set;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.QueryParam;
import org.jclouds.cloudstack.binders.BindTemplateMetadataToQueryParams;
import org.jclouds.cloudstack.domain.AsyncCreateResponse;
import org.jclouds.cloudstack.domain.ExtractMode;
import org.jclouds.cloudstack.domain.Template;
import org.jclouds.cloudstack.domain.TemplateMetadata;
import org.jclouds.cloudstack.domain.TemplatePermission;
import org.jclouds.cloudstack.filters.QuerySigner;
import org.jclouds.cloudstack.options.AccountInDomainOptions;
import org.jclouds.cloudstack.options.CreateTemplateOptions;
import org.jclouds.cloudstack.options.DeleteTemplateOptions;
import org.jclouds.cloudstack.options.ExtractTemplateOptions;
import org.jclouds.cloudstack.options.ListTemplatesOptions;
import org.jclouds.cloudstack.options.RegisterTemplateOptions;
import org.jclouds.cloudstack.options.UpdateTemplateOptions;
import org.jclouds.cloudstack.options.UpdateTemplatePermissionsOptions;
import org.jclouds.rest.annotations.BinderParam;
import org.jclouds.rest.annotations.ExceptionParser;
import org.jclouds.rest.annotations.OnlyElement;
import org.jclouds.rest.annotations.QueryParams;
import org.jclouds.rest.annotations.RequestFilters;
import org.jclouds.rest.annotations.SelectJson;
import org.jclouds.rest.annotations.SkipEncoding;
import org.jclouds.rest.annotations.Unwrap;
import org.jclouds.rest.functions.ReturnEmptySetOnNotFoundOr404;
import org.jclouds.rest.functions.ReturnNullOnNotFoundOr404;

@RequestFilters(value={QuerySigner.class})
@QueryParams(keys={"response"}, values={"json"})
@SkipEncoding(value={44})
public interface TemplateAsyncClient {
    @GET
    @QueryParams(keys={"command"}, values={"createTemplate"})
    @Unwrap
    @Consumes(value={"application/json"})
    public ListenableFuture<AsyncCreateResponse> createTemplate(@BinderParam(value=BindTemplateMetadataToQueryParams.class) TemplateMetadata var1, CreateTemplateOptions ... var2);

    @GET
    @QueryParams(keys={"command"}, values={"registerTemplate"})
    @SelectJson(value="template")
    @Consumes(value={"application/json"})
    public ListenableFuture<Set<Template>> registerTemplate(@BinderParam(value=BindTemplateMetadataToQueryParams.class) TemplateMetadata var1, @QueryParam(value="format") String var2, @QueryParam(value="hypervisor") String var3, @QueryParam(value="url") String var4, @QueryParam(value="zoneid") long var5, RegisterTemplateOptions ... var7);

    @GET
    @QueryParams(keys={"command"}, values={"updateTemplate"})
    @SelectJson(value="template")
    @Consumes(value={"application/json"})
    public ListenableFuture<Template> updateTemplate(@QueryParam(value="id") long var1, UpdateTemplateOptions ... var3);

    @GET
    @QueryParams(keys={"command"}, values={"copyTemplate"})
    @Unwrap
    @Consumes(value={"application/json"})
    public ListenableFuture<AsyncCreateResponse> copyTemplateToZone(@QueryParam(value="id") long var1, @QueryParam(value="sourcezoneid") long var3, @QueryParam(value="destzoneid") long var5);

    @GET
    @QueryParams(keys={"command"}, values={"deleteTemplate"})
    @Unwrap
    @Consumes(value={"application/json"})
    public ListenableFuture<AsyncCreateResponse> deleteTemplate(@QueryParam(value="id") long var1, DeleteTemplateOptions ... var3);

    @GET
    @QueryParams(keys={"command", "templatefilter"}, values={"listTemplates", "executable"})
    @SelectJson(value="template")
    @Consumes(value={"application/json"})
    @ExceptionParser(value=ReturnEmptySetOnNotFoundOr404.class)
    public ListenableFuture<Set<Template>> listTemplates();

    @GET
    @QueryParams(keys={"command"}, values={"listTemplates"})
    @SelectJson(value="template")
    @Consumes(value={"application/json"})
    @ExceptionParser(value=ReturnEmptySetOnNotFoundOr404.class)
    public ListenableFuture<Set<Template>> listTemplates(ListTemplatesOptions var1);

    @GET
    @QueryParams(keys={"command", "templatefilter"}, values={"listTemplates", "executable"})
    @SelectJson(value="template")
    @OnlyElement
    @Consumes(value={"application/json"})
    @ExceptionParser(value=ReturnNullOnNotFoundOr404.class)
    public ListenableFuture<Template> getTemplateInZone(@QueryParam(value="id") long var1, @QueryParam(value="zoneid") long var3);

    @GET
    @QueryParams(keys={"command"}, values={"updateTemplatePermissions"})
    public ListenableFuture<Void> updateTemplatePermissions(@QueryParam(value="id") long var1, UpdateTemplatePermissionsOptions ... var3);

    @GET
    @QueryParams(keys={"command"}, values={"listTemplatePermissions"})
    @Unwrap
    @Consumes(value={"application/json"})
    public ListenableFuture<Set<TemplatePermission>> listTemplatePermissions(@QueryParam(value="id") long var1, AccountInDomainOptions ... var3);

    @GET
    @QueryParams(keys={"command"}, values={"extractTemplate"})
    @Unwrap
    @Consumes(value={"application/json"})
    public ListenableFuture<AsyncCreateResponse> extractTemplate(@QueryParam(value="id") long var1, @QueryParam(value="mode") ExtractMode var3, @QueryParam(value="zoneid") long var4, ExtractTemplateOptions ... var6);
}

