/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.functions;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.inject.Inject;
import com.google.inject.TypeLiteral;
import java.util.Set;
import javax.inject.Singleton;
import org.jclouds.http.HttpResponse;
import org.jclouds.http.functions.ParseFirstJsonValueNamed;
import org.jclouds.json.internal.GsonWrapper;

@Singleton
public class ParseNamesFromHttpResponse
implements Function<HttpResponse, Set<String>> {
    private final ParseFirstJsonValueNamed<Set<Name>> parser;

    @Inject
    public ParseNamesFromHttpResponse(GsonWrapper gsonWrapper) {
        this.parser = new ParseFirstJsonValueNamed((GsonWrapper)Preconditions.checkNotNull((Object)gsonWrapper, (Object)"gsonWrapper"), (TypeLiteral)new TypeLiteral<Set<Name>>(){}, "hypervisor");
    }

    public Set<String> apply(HttpResponse response) {
        Preconditions.checkNotNull((Object)response, (Object)"response");
        Set toParse = (Set)this.parser.apply(response);
        Preconditions.checkNotNull((Object)toParse, (String)"parsed result from %s", (Object[])new Object[]{response});
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (Name entry : toParse) {
            builder.add((Object)entry.name);
        }
        return builder.build();
    }

    private static class Name {
        private String name;

        private Name() {
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Name other = (Name)obj;
            return !(this.name == null ? other.name != null : !this.name.equals(other.name));
        }
    }
}

