/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.predicates;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.cloudstack.CloudStackClient;
import org.jclouds.cloudstack.domain.OSType;
import org.jclouds.cloudstack.domain.Template;
import org.jclouds.cloudstack.options.ListOSTypesOptions;

@Singleton
public class OSCategoryIn
implements Function<Set<String>, Predicate<Template>> {
    private final Supplier<Map<Long, String>> categoriesSupplier;
    private final Supplier<Set<OSType>> osTypesSupplier;

    @Inject
    public OSCategoryIn(CloudStackClient client) {
        this((Supplier<Map<Long, String>>)Suppliers.ofInstance(((CloudStackClient)Preconditions.checkNotNull((Object)client, (Object)"client")).getGuestOSClient().listOSCategories()), (Supplier<Set<OSType>>)Suppliers.ofInstance(client.getGuestOSClient().listOSTypes(new ListOSTypesOptions[0])));
    }

    public OSCategoryIn(Supplier<Map<Long, String>> categoriesSupplier, Supplier<Set<OSType>> osTypesSupplier) {
        this.categoriesSupplier = (Supplier)Preconditions.checkNotNull(categoriesSupplier, (Object)"categoriesSupplier");
        this.osTypesSupplier = (Supplier)Preconditions.checkNotNull(osTypesSupplier, (Object)"osTypesSupplier");
    }

    public Predicate<Template> apply(final Set<String> acceptableCategories) {
        final Map categories = (Map)this.categoriesSupplier.get();
        final Set acceptableOSTypeIds = Maps.filterValues((Map)Maps.transformValues((Map)Maps.uniqueIndex((Iterable)((Iterable)this.osTypesSupplier.get()), (Function)new Function<OSType, Long>(){

            public Long apply(OSType input) {
                return input.getId();
            }
        }), (Function)new Function<OSType, String>(){

            public String apply(OSType input) {
                return (String)categories.get(input.getOSCategoryId());
            }
        }), (Predicate)Predicates.in(acceptableCategories)).keySet();
        return new Predicate<Template>(){

            public boolean apply(Template input) {
                return Predicates.in((Collection)acceptableOSTypeIds).apply((Object)input.getOSTypeId());
            }

            public String toString() {
                return "OSCategoryIn(" + acceptableCategories + ")";
            }
        };
    }
}

