/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.spring.integration.adapter;

import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.camel.Consumer;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.component.spring.integration.SpringIntegrationBinding;
import org.apache.camel.component.spring.integration.adapter.AbstractCamelAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.integration.Message;
import org.springframework.integration.MessageChannel;
import org.springframework.integration.channel.DirectChannel;
import org.springframework.integration.core.MessageHandler;

public class CamelSourceAdapter
extends AbstractCamelAdapter
implements InitializingBean,
DisposableBean {
    private static final Logger LOG = LoggerFactory.getLogger(CamelSourceAdapter.class);
    private Consumer consumer;
    private Endpoint camelEndpoint;
    private MessageChannel requestChannel;
    private DirectChannel replyChannel;
    private final AtomicBoolean initialized = new AtomicBoolean();

    public void setRequestChannel(MessageChannel channel) {
        this.requestChannel = channel;
    }

    public MessageChannel getChannel() {
        return this.requestChannel;
    }

    public void setReplyChannel(DirectChannel channel) {
        this.replyChannel = channel;
    }

    public final void afterPropertiesSet() throws Exception {
        if (this.initialized.compareAndSet(false, true)) {
            this.initialize();
        }
    }

    public void destroy() throws Exception {
        if (this.consumer != null) {
            this.consumer.stop();
        }
    }

    protected void initialize() throws Exception {
        this.camelEndpoint = this.getCamelContext().getEndpoint(this.getCamelEndpointUri());
        this.consumer = this.camelEndpoint.createConsumer((Processor)new ConsumerProcessor());
        this.consumer.start();
    }

    protected class ConsumerProcessor
    implements Processor {
        protected ConsumerProcessor() {
        }

        public void process(final Exchange exchange) throws Exception {
            Message request = SpringIntegrationBinding.createSpringIntegrationMessage(exchange);
            if (exchange.getPattern().isOutCapable()) {
                exchange.getIn().getHeaders().put("replyChannel", CamelSourceAdapter.this.replyChannel);
                if (CamelSourceAdapter.this.replyChannel == null) {
                    throw new IllegalArgumentException("ReplyChannel has not been configured on: " + this);
                }
                CamelSourceAdapter.this.replyChannel.subscribe(new MessageHandler(){

                    public void handleMessage(Message<?> message) {
                        LOG.debug("Received {} from ReplyChannel: {}", message, (Object)CamelSourceAdapter.this.replyChannel);
                        SpringIntegrationBinding.storeToCamelMessage(message, exchange.getOut());
                    }
                });
            }
            CamelSourceAdapter.this.requestChannel.send(request);
        }
    }
}

