/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.snmp;

import javax.jbi.management.DeploymentException;
import javax.jbi.messaging.InOnly;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.MessagingException;
import javax.jbi.messaging.NormalizedMessage;
import org.apache.servicemix.common.endpoints.ConsumerEndpoint;
import org.apache.servicemix.snmp.SnmpEndpointType;
import org.apache.servicemix.snmp.marshaler.DefaultSnmpMarshaler;
import org.apache.servicemix.snmp.marshaler.SnmpMarshalerSupport;
import org.snmp4j.CommandResponder;
import org.snmp4j.CommandResponderEvent;
import org.snmp4j.PDU;
import org.snmp4j.Snmp;
import org.snmp4j.TransportMapping;
import org.snmp4j.smi.Address;
import org.snmp4j.smi.GenericAddress;
import org.snmp4j.smi.UdpAddress;
import org.snmp4j.transport.DefaultUdpTransportMapping;

public class SnmpTrapConsumerEndpoint
extends ConsumerEndpoint
implements SnmpEndpointType,
CommandResponder {
    public static final boolean DEFAULT_ENABLED_VALUE = true;
    private Address listenGenericAddress;
    private Snmp snmp;
    private TransportMapping transport;
    private String address;
    private boolean enabled = true;
    private SnmpMarshalerSupport marshaler = new DefaultSnmpMarshaler();

    public synchronized void activate() throws Exception {
        super.activate();
        if (this.isEnabled()) {
            logger.debug("Activating endpoint");
            this.listenGenericAddress = GenericAddress.parse((String)this.address);
            this.transport = new DefaultUdpTransportMapping((UdpAddress)this.listenGenericAddress);
            this.snmp = new Snmp(this.transport);
            this.snmp.addCommandResponder((CommandResponder)this);
        }
    }

    public synchronized void start() throws Exception {
        super.start();
        if (this.isEnabled()) {
            this.transport.listen();
        }
    }

    public synchronized void stop() throws Exception {
        if (this.isEnabled() && this.transport.isListening()) {
            this.transport.close();
        }
        super.stop();
    }

    public void validate() throws DeploymentException {
        super.validate();
        if (this.address == null) {
            throw new DeploymentException("The listen address attribute has to be specified!");
        }
        try {
            if (GenericAddress.parse((String)this.address) == null) {
                throw new DeploymentException("The specified address " + this.address + " is not valid!");
            }
        }
        catch (IllegalArgumentException ex) {
            throw new DeploymentException("The specified address " + this.address + " is not valid!");
        }
    }

    public void process(MessageExchange exchange) throws Exception {
    }

    public void processPdu(CommandResponderEvent event) {
        PDU pdu = event.getPDU();
        if (pdu != null) {
            this.sendSnmpTrapMessage(pdu);
        } else {
            logger.debug("Received invalid trap PDU: {}", (Object)pdu);
        }
    }

    private void sendSnmpTrapMessage(PDU pdu) {
        try {
            InOnly io = this.getExchangeFactory().createInOnlyExchange();
            this.configureExchangeTarget((MessageExchange)io);
            NormalizedMessage inMsg = io.createMessage();
            this.marshaler.convertToJBI((MessageExchange)io, inMsg, null, pdu);
            io.setInMessage(inMsg);
            this.getChannel().send((MessageExchange)io);
        }
        catch (MessagingException ex) {
            logger.error("Error while trying to send the snmp trap PDU to the jbi bus", (Throwable)ex);
        }
    }

    public Snmp getSnmp() {
        return this.snmp;
    }

    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public SnmpMarshalerSupport getMarshaler() {
        return this.marshaler;
    }

    public void setMarshaler(SnmpMarshalerSupport marshaler) {
        this.marshaler = marshaler;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }
}

