/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.eip.patterns;

import javax.jbi.management.DeploymentException;
import javax.jbi.messaging.ExchangeStatus;
import javax.jbi.messaging.Fault;
import javax.jbi.messaging.InOnly;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.NormalizedMessage;
import javax.jbi.messaging.RobustInOnly;
import org.apache.servicemix.common.util.MessageUtil;
import org.apache.servicemix.eip.EIPEndpoint;
import org.apache.servicemix.eip.support.ExchangeTarget;
import org.apache.servicemix.eip.support.Predicate;

public class MessageFilter
extends EIPEndpoint {
    private ExchangeTarget target;
    private Predicate filter;
    private boolean reportErrors;

    public ExchangeTarget getTarget() {
        return this.target;
    }

    public void setTarget(ExchangeTarget target) {
        this.target = target;
    }

    public Predicate getFilter() {
        return this.filter;
    }

    public void setFilter(Predicate filter) {
        this.filter = filter;
    }

    public boolean isReportErrors() {
        return this.reportErrors;
    }

    public void setReportErrors(boolean reportErrors) {
        this.reportErrors = reportErrors;
    }

    public void validate() throws DeploymentException {
        super.validate();
        if (this.target == null) {
            throw new IllegalArgumentException("target should be set to a valid ExchangeTarget");
        }
        if (this.filter == null) {
            throw new IllegalArgumentException("filter property should be set");
        }
    }

    protected void processSync(MessageExchange exchange) throws Exception {
        if (!(exchange instanceof InOnly) && !(exchange instanceof RobustInOnly)) {
            this.fail(exchange, new UnsupportedOperationException("Use an InOnly or RobustInOnly MEP"));
        } else {
            NormalizedMessage in = MessageUtil.copyIn((MessageExchange)exchange);
            MessageExchange me = this.getExchangeFactory().createExchange(exchange.getPattern());
            this.target.configureTarget(me, this.getContext());
            MessageUtil.transferToIn((NormalizedMessage)in, (MessageExchange)me);
            if (this.filter.matches(me)) {
                this.sendSync(me);
                if (me.getStatus() == ExchangeStatus.ERROR && this.reportErrors) {
                    this.fail(exchange, me.getError());
                } else if (me.getStatus() == ExchangeStatus.DONE) {
                    this.done(exchange);
                } else if (me.getFault() != null && this.reportErrors) {
                    Fault fault = MessageUtil.copyFault((MessageExchange)me);
                    this.done(me);
                    MessageUtil.transferToFault((Fault)fault, (MessageExchange)exchange);
                    this.sendSync(exchange);
                }
            } else {
                this.done(exchange);
            }
        }
    }

    protected void processAsync(MessageExchange exchange) throws Exception {
        if (this.reportErrors) {
            throw new UnsupportedOperationException("Not implemented");
        }
        if (exchange.getStatus() == ExchangeStatus.DONE) {
            return;
        }
        if (exchange.getStatus() == ExchangeStatus.ERROR) {
            return;
        }
        if (!(exchange instanceof InOnly) && !(exchange instanceof RobustInOnly)) {
            this.fail(exchange, new UnsupportedOperationException("Use an InOnly or RobustInOnly MEP"));
        } else if (exchange.getFault() != null) {
            this.done(exchange);
        } else {
            NormalizedMessage in = MessageUtil.copyIn((MessageExchange)exchange);
            MessageExchange me = this.getExchangeFactory().createExchange(exchange.getPattern());
            this.target.configureTarget(me, this.getContext());
            MessageUtil.transferToIn((NormalizedMessage)in, (MessageExchange)me);
            if (this.filter.matches(me)) {
                this.send(me);
            }
            this.done(exchange);
        }
    }
}

