/*
 * Decompiled with CFR 0.152.
 */
package org.quickfixj.java4.net.sf.retrotranslator.runtime.format;

import java.text.DecimalFormatSymbols;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.quickfixj.java4.net.sf.retrotranslator.runtime.format.Conversion;
import org.quickfixj.java4.net.sf.retrotranslator.runtime.java.util.FormatFlagsConversionMismatchException_;
import org.quickfixj.java4.net.sf.retrotranslator.runtime.java.util.IllegalFormatConversionException_;
import org.quickfixj.java4.net.sf.retrotranslator.runtime.java.util.IllegalFormatFlagsException_;
import org.quickfixj.java4.net.sf.retrotranslator.runtime.java.util.IllegalFormatPrecisionException_;
import org.quickfixj.java4.net.sf.retrotranslator.runtime.java.util.IllegalFormatWidthException_;
import org.quickfixj.java4.net.sf.retrotranslator.runtime.java.util.MissingFormatArgumentException_;
import org.quickfixj.java4.net.sf.retrotranslator.runtime.java.util.MissingFormatWidthException_;
import org.quickfixj.java4.net.sf.retrotranslator.runtime.java.util.UnknownFormatConversionException_;

public abstract class FormatContext {
    private static final DecimalFormatSymbols US_SYMBOLS = new DecimalFormatSymbols(Locale.US);
    private static final Pattern PATTERN = Pattern.compile("%(?:(\\d+)\\$)?([-#+ 0,(\\<]*)?(\\d+)?(?:\\.(\\d+))?([bBhHsScCdoxXeEfgGaA%n]|(?:[tT][HIklMSLNpzZsQBbhAaCYyjmdeRTrDFc]))");
    private Locale locale;
    private DecimalFormatSymbols symbols;
    private Object[] arguments;
    private int effectiveIndex;
    private int ordinaryIndex;
    private boolean effectiveIndexComputed;
    private String specifier;
    private int explicitIndex;
    private String flags;
    private int width;
    private int precision;
    private String conversion;

    protected FormatContext(Locale locale) {
        this.locale = locale;
    }

    public abstract void append(char var1);

    public abstract void append(String var1);

    public abstract void append(String var1, int var2, int var3);

    public abstract boolean writeFormattable();

    public void printf(String format, Object[] args) {
        this.arguments = args;
        this.effectiveIndex = 0;
        this.ordinaryIndex = 0;
        int position = 0;
        Matcher matcher = PATTERN.matcher(format);
        while (matcher.find(position)) {
            this.writeText(format, position, matcher.start());
            this.effectiveIndexComputed = false;
            this.specifier = matcher.group();
            this.explicitIndex = FormatContext.parse(matcher.group(1));
            String f = matcher.group(2);
            this.flags = f != null ? f : "";
            this.width = FormatContext.parse(matcher.group(3));
            this.precision = FormatContext.parse(matcher.group(4));
            this.conversion = matcher.group(5);
            Conversion.getInstance(this.conversion).format(this);
            position = matcher.end();
        }
        this.writeText(format, position, format.length());
    }

    private static int parse(String s) {
        return s == null ? -1 : Integer.valueOf(s);
    }

    private char getConversionType() {
        return this.conversion.charAt(0);
    }

    public int getWidth() {
        return this.width;
    }

    public int getPrecision() {
        return this.precision;
    }

    public int getNumberPrecision() {
        return this.precision >= 0 ? this.precision : 6;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public DecimalFormatSymbols getSymbols(boolean localized) {
        if (localized && this.locale != null) {
            if (this.symbols == null) {
                this.symbols = new DecimalFormatSymbols(this.locale);
            }
            return this.symbols;
        }
        return US_SYMBOLS;
    }

    public IllegalFormatConversionException_ getConversionException() {
        return new IllegalFormatConversionException_(this.getConversionType(), this.getArgument().getClass());
    }

    public boolean isUpperCase() {
        return Character.isUpperCase(this.getConversionType());
    }

    public boolean isFlag(char c) {
        return this.flags.indexOf(c) >= 0;
    }

    public Object getArgument() {
        if (!this.effectiveIndexComputed) {
            this.computeEffectiveIndex();
            this.effectiveIndexComputed = true;
        }
        return this.arguments[this.effectiveIndex - 1];
    }

    private void computeEffectiveIndex() {
        if (this.flags.indexOf(60) < 0) {
            int n = this.effectiveIndex = this.explicitIndex != -1 ? this.explicitIndex : (this.ordinaryIndex = this.ordinaryIndex + 1);
        }
        if (this.arguments == null || this.effectiveIndex == 0 || this.effectiveIndex > this.arguments.length) {
            throw new MissingFormatArgumentException_(this.specifier);
        }
    }

    private void writeText(String s, int start, int end) {
        if (start == end) {
            return;
        }
        int i = s.indexOf(37, start);
        if (i >= 0 && i < end) {
            String unknownFormat = s.substring(i + 1, end);
            throw new UnknownFormatConversionException_(unknownFormat.length() > 0 ? unknownFormat : "%");
        }
        this.append(s, start, end);
    }

    public void writeRestricted(String s) {
        this.writePadded(this.precision != -1 && this.precision < s.length() ? s.substring(0, this.precision) : s);
    }

    public void writePadded(String s) {
        if (this.isFlag('-')) {
            this.writeCaseSensitive(s);
            this.writePadding(s);
        } else {
            this.writePadding(s);
            this.writeCaseSensitive(s);
        }
    }

    private void writePadding(String s) {
        for (int i = this.width - s.length(); i > 0; --i) {
            this.append(' ');
        }
    }

    private void writeCaseSensitive(String s) {
        if (this.isUpperCase()) {
            this.append(s.toUpperCase());
        } else {
            this.append(s);
        }
    }

    public void assertNoFlag(char flag) {
        if (this.isFlag(flag)) {
            throw new FormatFlagsConversionMismatchException_(this.flags, this.getConversionType());
        }
    }

    public void assertNoPrecision() {
        if (this.precision != -1) {
            throw new IllegalFormatPrecisionException_(this.precision);
        }
    }

    public void assertNoWidth() {
        if (this.width != -1) {
            throw new IllegalFormatWidthException_(this.width);
        }
    }

    public void checkWidth() {
        if ((this.isFlag('-') || this.isFlag('0')) && this.width == -1) {
            throw new MissingFormatWidthException_(this.specifier);
        }
    }

    public void checkFlags() {
        if (this.isFlag('+') && this.isFlag(' ') || this.isFlag('-') && this.isFlag('0')) {
            throw new IllegalFormatFlagsException_(this.flags);
        }
    }
}

