/*
 * Decompiled with CFR 0.152.
 */
package org.quickfixj.jmx.mbean.connector;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import javax.management.MBeanRegistration;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.TabularData;
import org.quickfixj.QFJException;
import org.quickfixj.jmx.JmxExporter;
import org.quickfixj.jmx.mbean.JmxSupport;
import org.quickfixj.jmx.mbean.connector.ConnectorAdminMBean;
import org.quickfixj.jmx.mbean.session.SessionJmxExporter;
import org.quickfixj.jmx.openmbean.TabularDataAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import quickfix.Acceptor;
import quickfix.Connector;
import quickfix.Initiator;
import quickfix.Responder;
import quickfix.Session;
import quickfix.SessionID;
import quickfix.SessionSettings;
import quickfix.mina.SessionConnector;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class ConnectorAdmin
implements ConnectorAdminMBean,
MBeanRegistration {
    private Logger log = LoggerFactory.getLogger(this.getClass());
    public static final String ACCEPTOR_ROLE = "ACCEPTOR";
    public static final String INITIATOR_ROLE = "INITIATOR";
    private final Connector connector;
    private static final TabularDataAdapter tabularDataAdapter = new TabularDataAdapter();
    private final SessionJmxExporter sessionExporter;
    private final JmxExporter jmxExporter;
    private final ObjectName connectorName;
    private final List<ObjectName> sessionNames = new ArrayList<ObjectName>();
    private final SessionSettings settings;
    private String role = "N/A";
    private MBeanServer mbeanServer;

    public ConnectorAdmin(JmxExporter jmxExporter, Connector connector, ObjectName connectorName, SessionSettings settings, SessionJmxExporter sessionExporter) {
        this.jmxExporter = jmxExporter;
        this.connectorName = connectorName;
        this.settings = settings;
        this.sessionExporter = sessionExporter;
        if (connector instanceof Acceptor) {
            this.role = ACCEPTOR_ROLE;
        } else if (connector instanceof Initiator) {
            this.role = INITIATOR_ROLE;
        }
        this.connector = connector;
    }

    @Override
    public String getRole() {
        return this.role;
    }

    @Override
    public TabularData getSessions() throws IOException {
        ArrayList<ConnectorSession> sessions = new ArrayList<ConnectorSession>();
        for (SessionID sessionID : this.connector.getSessions()) {
            Session session = Session.lookupSession(sessionID);
            sessions.add(new ConnectorSession(session, this.sessionExporter.getSessionName(sessionID)));
        }
        try {
            return tabularDataAdapter.fromBeanList("Sessions", "Session", "sessionID", sessions);
        }
        catch (OpenDataException e) {
            throw JmxSupport.toIOException(e);
        }
    }

    public TabularData getLoggedOnSessions() throws OpenDataException {
        ArrayList<ObjectName> names = new ArrayList<ObjectName>();
        for (SessionID sessionID : this.connector.getSessions()) {
            Session session = Session.lookupSession(sessionID);
            if (!session.isLoggedOn()) continue;
            names.add(this.sessionExporter.getSessionName(sessionID));
        }
        return tabularDataAdapter.fromArray("Sessions", "SessionID", this.toObjectNameArray(names));
    }

    private ObjectName[] toObjectNameArray(List<ObjectName> sessions) {
        return sessions.toArray(new ObjectName[sessions.size()]);
    }

    @Override
    public void stop(boolean force) {
        this.log.info(new StringBuffer().append("JMX operation: stop ").append(this.getRole()).append(" ").append(this).toString());
        this.connector.stop(force);
    }

    @Override
    public String getHostName() {
        try {
            return InetAddress.getLocalHost().getCanonicalHostName();
        }
        catch (UnknownHostException e) {
            return "[UNKNOWN]";
        }
    }

    @Override
    public void stop() {
        this.stop(false);
    }

    @Override
    public ObjectName preRegister(MBeanServer server, ObjectName name) throws Exception {
        this.mbeanServer = server;
        return name;
    }

    @Override
    public void postRegister(Boolean registrationDone) {
        if (this.connector instanceof SessionConnector) {
            ((SessionConnector)this.connector).addPropertyChangeListener(new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent evt) {
                    if ("sessions".equals(evt.getPropertyName())) {
                        ConnectorAdmin.this.registerSessions();
                    }
                }
            });
        }
        this.registerSessions();
    }

    private void registerSessions() {
        ArrayList<SessionID> sessionIDs = this.connector.getSessions();
        for (int i = 0; i < sessionIDs.size(); ++i) {
            SessionID sessionID = sessionIDs.get(i);
            if (this.sessionExporter.getSessionName(sessionID) != null) continue;
            try {
                ObjectName name = this.sessionExporter.register(this.jmxExporter, Session.lookupSession(sessionID), this.connectorName, this.settings);
                this.sessionNames.add(name);
                continue;
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new QFJException("Connector MBean postregistration failed", e);
            }
        }
    }

    @Override
    public void preDeregister() throws Exception {
    }

    @Override
    public void postDeregister() {
        for (ObjectName sessionName : this.sessionNames) {
            try {
                this.mbeanServer.unregisterMBean(sessionName);
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new QFJException("Connector MBean postregistration failed", e);
            }
        }
    }

    public static class ConnectorSession {
        private Session session;
        private ObjectName sessionName;

        public ConnectorSession(Session session, ObjectName sessionName) {
            this.session = session;
            this.sessionName = sessionName;
        }

        public boolean isLoggedOn() {
            return this.session.isLoggedOn();
        }

        public SessionID getSessionID() {
            return this.session.getSessionID();
        }

        public ObjectName getSessionName() {
            return this.sessionName;
        }

        public String getRemoteAddress() {
            Responder responder = this.session.getResponder();
            return responder != null ? responder.getRemoteIPAddress() : "N/A";
        }
    }
}

