/*
 * Decompiled with CFR 0.152.
 */
package org.quickfixj.jmx.mbean.connector;

import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.quickfixj.QFJException;
import org.quickfixj.java4.edu.emory.mathcs.backport.java.util.concurrent.atomic.AtomicInteger;
import org.quickfixj.jmx.JmxExporter;
import org.quickfixj.jmx.mbean.ObjectNameFactory;
import org.quickfixj.jmx.mbean.connector.ConnectorAdmin;
import org.quickfixj.jmx.mbean.connector.SocketAcceptorAdmin;
import org.quickfixj.jmx.mbean.connector.SocketInitiatorAdmin;
import org.quickfixj.jmx.mbean.session.SessionJmxExporter;
import quickfix.Acceptor;
import quickfix.SessionID;
import quickfix.mina.SessionConnector;
import quickfix.mina.acceptor.AbstractSocketAcceptor;
import quickfix.mina.initiator.AbstractSocketInitiator;

public class ConnectorJmxExporter {
    private final SessionJmxExporter sessionExporter = new SessionJmxExporter();
    private static final AtomicInteger connectorIdCounter = new AtomicInteger();

    public ObjectName register(JmxExporter jmxExporter, SessionConnector connector) {
        return this.register(jmxExporter, connector, Integer.toString(connectorIdCounter.incrementAndGet()));
    }

    public ObjectName register(JmxExporter jmxExporter, SessionConnector connector, String connectorId) {
        try {
            ConnectorAdmin connectorAdmin;
            ObjectName connectorName = this.getConnectorName(connector, connectorId);
            if (connector instanceof AbstractSocketAcceptor) {
                connectorAdmin = new SocketAcceptorAdmin(jmxExporter, (AbstractSocketAcceptor)connector, connectorName, this.sessionExporter);
            } else if (connector instanceof AbstractSocketInitiator) {
                connectorAdmin = new SocketInitiatorAdmin(jmxExporter, (AbstractSocketInitiator)connector, connectorName, this.sessionExporter);
            } else {
                throw new QFJException("Unknown connector type: " + connector.getClass().getName());
            }
            jmxExporter.registerMBean(connectorAdmin, connectorName);
            return connectorName;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new QFJException("Failed to export connector MBean", e);
        }
    }

    private ObjectName getConnectorName(SessionConnector connector, String connectorId) throws MalformedObjectNameException {
        ObjectNameFactory nameFactory = new ObjectNameFactory();
        nameFactory.addProperty("type", "Connector");
        nameFactory.addProperty("role", connector instanceof Acceptor ? "Acceptor" : "Initiator");
        nameFactory.addProperty("id", connectorId);
        return nameFactory.createName();
    }

    public ObjectName lookupSessionName(SessionID sessionID) {
        return this.sessionExporter.getSessionName(sessionID);
    }
}

