/*
 * Decompiled with CFR 0.152.
 */
package quickfix;

import java.io.IOException;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import org.quickfixj.java4.net.sf.retrotranslator.runtime.java.lang._Integer;
import org.slf4j.LoggerFactory;
import quickfix.MessageStore;
import quickfix.Session;
import quickfix.SessionID;
import quickfix.SystemTime;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MemoryStore
implements MessageStore {
    private HashMap<Integer, String> messages = new HashMap();
    private int nextSenderMsgSeqNum;
    private int nextTargetMsgSeqNum;
    private SessionID sessionID;
    private Calendar creationTime = SystemTime.getUtcCalendar();
    static /* synthetic */ Class class$quickfix$MemoryStore;

    public MemoryStore() throws IOException {
        this.reset();
    }

    public MemoryStore(SessionID sessionID) {
        this.sessionID = sessionID;
    }

    @Override
    public void get(int startSequence, int endSequence, Collection<String> messages) throws IOException {
        for (int i = startSequence; i <= endSequence; ++i) {
            String message = this.messages.get(_Integer.valueOf(i));
            if (message == null) continue;
            messages.add(message);
        }
    }

    public boolean get(int sequence, String message) throws IOException {
        throw new UnsupportedOperationException("not supported");
    }

    @Override
    public Date getCreationTime() throws IOException {
        return this.creationTime.getTime();
    }

    void setCreationTime(Calendar creationTime) {
        this.creationTime = creationTime;
    }

    @Override
    public int getNextSenderMsgSeqNum() throws IOException {
        return this.nextSenderMsgSeqNum;
    }

    @Override
    public int getNextTargetMsgSeqNum() throws IOException {
        return this.nextTargetMsgSeqNum;
    }

    @Override
    public void incrNextSenderMsgSeqNum() throws IOException {
        this.setNextSenderMsgSeqNum(this.getNextSenderMsgSeqNum() + 1);
    }

    @Override
    public void incrNextTargetMsgSeqNum() throws IOException {
        this.setNextTargetMsgSeqNum(this.getNextTargetMsgSeqNum() + 1);
    }

    @Override
    public void reset() throws IOException {
        this.setNextSenderMsgSeqNum(1);
        this.setNextTargetMsgSeqNum(1);
        this.messages.clear();
        this.creationTime = SystemTime.getUtcCalendar();
    }

    @Override
    public boolean set(int sequence, String message) throws IOException {
        return this.messages.put(_Integer.valueOf(sequence), message) == null;
    }

    @Override
    public void setNextSenderMsgSeqNum(int next) throws IOException {
        this.nextSenderMsgSeqNum = next;
    }

    @Override
    public void setNextTargetMsgSeqNum(int next) throws IOException {
        this.nextTargetMsgSeqNum = next;
    }

    @Override
    public void refresh() throws IOException {
        String text = "memory store does not support refresh!";
        if (this.sessionID != null) {
            Session session = Session.lookupSession(this.sessionID);
            session.getLog().onErrorEvent("ERROR: memory store does not support refresh!");
        } else {
            Class<?> clazz = class$quickfix$MemoryStore;
            if (clazz == null) {
                clazz = class$quickfix$MemoryStore = new MemoryStore[0].getClass().getComponentType();
            }
            LoggerFactory.getLogger((Class)clazz).error("memory store does not support refresh!");
        }
    }
}

