/*
 * Decompiled with CFR 0.152.
 */
package quickfix;

import java.io.IOException;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import org.quickfixj.java4.edu.emory.mathcs.backport.java.util.concurrent.locks.Lock;
import org.quickfixj.java4.edu.emory.mathcs.backport.java.util.concurrent.locks.ReentrantLock;
import org.quickfixj.java4.net.sf.retrotranslator.runtime.java.lang._Integer;
import quickfix.Log;
import quickfix.Message;
import quickfix.MessageStore;
import quickfix.RuntimeError;
import quickfix.SystemTime;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SessionState {
    private final Object lock;
    private final Log log;
    private final MessageStore messageStore;
    private final Lock senderMsgSeqNumLock = new ReentrantLock();
    private final Lock targetMsgSeqNumLock = new ReentrantLock();
    private final boolean initiator;
    private long logonTimeoutMs = 10000L;
    private long logoutTimeoutMs = 2000L;
    private boolean logonSent;
    private boolean logonReceived;
    private boolean logoutSent;
    private boolean logoutReceived = false;
    private int testRequestCounter;
    private long lastSentTime;
    private long lastReceivedTime;
    private boolean withinHeartBeat;
    private double testRequestDelayMultiplier;
    private long heartBeatMillis = Long.MAX_VALUE;
    private int heartBeatInterval;
    private int[] resendRange = new int[]{0, 0, 0};
    private boolean resetSent;
    private boolean resetReceived;
    private String logoutReason;
    private final Map<Integer, Message> messageQueue = new LinkedHashMap<Integer, Message>();

    public SessionState(Object lock, Log log, int heartBeatInterval, boolean initiator, MessageStore messageStore, double testRequestDelayMultiplier) {
        this.lock = lock;
        this.initiator = initiator;
        this.messageStore = messageStore;
        this.setHeartBeatInterval(heartBeatInterval);
        this.log = log == null ? new NullLog() : log;
        this.testRequestDelayMultiplier = testRequestDelayMultiplier;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getHeartBeatInterval() {
        Object object = this.lock;
        synchronized (object) {
            return this.heartBeatInterval;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setHeartBeatInterval(int heartBeatInterval) {
        Object object = this.lock;
        synchronized (object) {
            this.heartBeatInterval = heartBeatInterval;
        }
        this.setHeartBeatMillis((long)heartBeatInterval * 1000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setHeartBeatMillis(long heartBeatMillis) {
        Object object = this.lock;
        synchronized (object) {
            this.heartBeatMillis = heartBeatMillis;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long getHeartBeatMillis() {
        Object object = this.lock;
        synchronized (object) {
            return this.heartBeatMillis;
        }
    }

    public boolean isHeartBeatNeeded() {
        long millisSinceLastSentTime = SystemTime.currentTimeMillis() - this.getLastSentTime();
        return millisSinceLastSentTime >= this.getHeartBeatMillis() && this.getTestRequestCounter() == 0;
    }

    public boolean isInitiator() {
        return this.initiator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getLastReceivedTime() {
        Object object = this.lock;
        synchronized (object) {
            return this.lastReceivedTime;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLastReceivedTime(long lastReceivedTime) {
        Object object = this.lock;
        synchronized (object) {
            this.lastReceivedTime = lastReceivedTime;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getLastSentTime() {
        Object object = this.lock;
        synchronized (object) {
            return this.lastSentTime;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLastSentTime(long lastSentTime) {
        Object object = this.lock;
        synchronized (object) {
            this.lastSentTime = lastSentTime;
        }
    }

    public Log getLog() {
        return this.log;
    }

    public boolean isLogonAlreadySent() {
        return this.isInitiator() && this.isLogonSent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isLogonReceived() {
        Object object = this.lock;
        synchronized (object) {
            return this.logonReceived;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLogonReceived(boolean logonReceived) {
        Object object = this.lock;
        synchronized (object) {
            this.logonReceived = logonReceived;
        }
    }

    public boolean isLogonSendNeeded() {
        return this.isInitiator() && !this.isLogonSent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isLogonSent() {
        Object object = this.lock;
        synchronized (object) {
            return this.logonSent;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLogonSent(boolean logonSent) {
        Object object = this.lock;
        synchronized (object) {
            this.logonSent = logonSent;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isLogonTimedOut() {
        Object object = this.lock;
        synchronized (object) {
            return this.isLogonSent() && SystemTime.currentTimeMillis() - this.getLastReceivedTime() >= this.getLogonTimeoutMs();
        }
    }

    public void setLogonTimeout(int logonTimeout) {
        this.setLogonTimeoutMs((long)logonTimeout * 1000L);
    }

    public int getLogonTimeout() {
        return (int)(this.getLogonTimeoutMs() / 1000L);
    }

    public void setLogoutTimeout(int logoutTimeout) {
        this.setLogoutTimeoutMs((long)logoutTimeout * 1000L);
    }

    public int getLogoutTimeout() {
        return (int)(this.getLogoutTimeoutMs() / 1000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setLogoutTimeoutMs(long logoutTimeoutMs) {
        Object object = this.lock;
        synchronized (object) {
            this.logoutTimeoutMs = logoutTimeoutMs;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long getLogoutTimeoutMs() {
        Object object = this.lock;
        synchronized (object) {
            return this.logoutTimeoutMs;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setLogonTimeoutMs(long logonTimeoutMs) {
        Object object = this.lock;
        synchronized (object) {
            this.logonTimeoutMs = logonTimeoutMs;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long getLogonTimeoutMs() {
        Object object = this.lock;
        synchronized (object) {
            return this.logonTimeoutMs;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isLogoutSent() {
        Object object = this.lock;
        synchronized (object) {
            return this.logoutSent;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLogoutSent(boolean logoutSent) {
        Object object = this.lock;
        synchronized (object) {
            this.logoutSent = logoutSent;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isLogoutReceived() {
        Object object = this.lock;
        synchronized (object) {
            return this.logoutReceived;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLogoutReceived(boolean logoutReceived) {
        Object object = this.lock;
        synchronized (object) {
            this.logoutReceived = logoutReceived;
        }
    }

    public boolean isLogoutTimedOut() {
        return this.isLogoutSent() && SystemTime.currentTimeMillis() - this.getLastSentTime() >= this.getLogoutTimeoutMs();
    }

    public MessageStore getMessageStore() {
        return this.messageStore;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getTestRequestCounter() {
        Object object = this.lock;
        synchronized (object) {
            return this.testRequestCounter;
        }
    }

    public double getTestRequestDelayMultiplier() {
        return this.testRequestDelayMultiplier;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearTestRequestCounter() {
        Object object = this.lock;
        synchronized (object) {
            this.testRequestCounter = 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void incrementTestRequestCounter() {
        Object object = this.lock;
        synchronized (object) {
            ++this.testRequestCounter;
        }
    }

    public boolean isTestRequestNeeded() {
        long millisSinceLastReceivedTime = this.timeSinceLastReceivedMessage();
        return (double)millisSinceLastReceivedTime >= (1.0 + this.testRequestDelayMultiplier) * (double)(this.getTestRequestCounter() + 1) * (double)this.getHeartBeatMillis();
    }

    private long timeSinceLastReceivedMessage() {
        return SystemTime.currentTimeMillis() - this.getLastReceivedTime();
    }

    public boolean isTimedOut() {
        long millisSinceLastReceivedTime = this.timeSinceLastReceivedMessage();
        return (double)millisSinceLastReceivedTime >= 2.4 * (double)this.getHeartBeatMillis();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isWithinHeartBeat() {
        Object object = this.lock;
        synchronized (object) {
            return this.withinHeartBeat;
        }
    }

    public boolean set(int sequence, String message) throws IOException {
        return this.messageStore.set(sequence, message);
    }

    public void get(int first, int last, Collection<String> messages) throws IOException {
        this.messageStore.get(first, last, messages);
    }

    public void enqueue(int sequence, Message message) {
        this.messageQueue.put(_Integer.valueOf(sequence), message);
    }

    public Message dequeue(int sequence) {
        return this.messageQueue.remove(_Integer.valueOf(sequence));
    }

    public Message getNextQueuedMessage() {
        return this.messageQueue.size() > 0 ? this.messageQueue.values().iterator().next() : null;
    }

    public Collection<Integer> getQueuedSeqNums() {
        return this.messageQueue.keySet();
    }

    public void clearQueue() {
        this.messageQueue.clear();
    }

    public void lockSenderMsgSeqNum() {
        this.senderMsgSeqNumLock.lock();
    }

    public void unlockSenderMsgSeqNum() {
        this.senderMsgSeqNumLock.unlock();
    }

    public void lockTargetMsgSeqNum() {
        this.targetMsgSeqNumLock.lock();
    }

    public void unlockTargetMsgSeqNum() {
        this.targetMsgSeqNumLock.unlock();
    }

    public int getNextSenderMsgSeqNum() throws IOException {
        return this.messageStore.getNextSenderMsgSeqNum();
    }

    public int getNextTargetMsgSeqNum() throws IOException {
        return this.messageStore.getNextTargetMsgSeqNum();
    }

    public void setNextTargetMsgSeqNum(int sequence) throws IOException {
        this.messageStore.setNextTargetMsgSeqNum(sequence);
    }

    public void incrNextSenderMsgSeqNum() throws IOException {
        this.messageStore.incrNextSenderMsgSeqNum();
    }

    public void incrNextTargetMsgSeqNum() throws IOException {
        this.messageStore.incrNextTargetMsgSeqNum();
    }

    public Date getCreationTime() throws IOException {
        return this.messageStore.getCreationTime();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean needReset() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            return this.messageStore.getNextSenderMsgSeqNum() != 1 || this.messageStore.getNextTargetMsgSeqNum() != 1;
        }
    }

    public void reset() {
        try {
            if (this.needReset()) {
                this.messageStore.reset();
            }
        }
        catch (IOException e) {
            throw new RuntimeError(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setResendRange(int low, int high) {
        Object object = this.lock;
        synchronized (object) {
            this.resendRange[0] = low;
            this.resendRange[1] = high;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setResendRange(int low, int high, int currentResend) {
        Object object = this.lock;
        synchronized (object) {
            this.resendRange[0] = low;
            this.resendRange[1] = high;
            this.resendRange[2] = currentResend;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isResendRequested() {
        Object object = this.lock;
        synchronized (object) {
            return this.resendRange[0] != 0 || this.resendRange[1] != 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] getResendRange() {
        Object object = this.lock;
        synchronized (object) {
            return this.resendRange;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isResetReceived() {
        Object object = this.lock;
        synchronized (object) {
            return this.resetReceived;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setResetReceived(boolean resetReceived) {
        Object object = this.lock;
        synchronized (object) {
            this.resetReceived = resetReceived;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isResetSent() {
        Object object = this.lock;
        synchronized (object) {
            return this.resetSent;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setResetSent(boolean resetSent) {
        Object object = this.lock;
        synchronized (object) {
            this.resetSent = resetSent;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLogoutReason(String reason) {
        Object object = this.lock;
        synchronized (object) {
            this.logoutReason = reason;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getLogoutReason() {
        Object object = this.lock;
        synchronized (object) {
            return this.logoutReason;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearLogoutReason() {
        Object object = this.lock;
        synchronized (object) {
            this.logoutReason = "";
        }
    }

    public Object getLock() {
        return this.lock;
    }

    private static final class NullLog
    implements Log {
        private NullLog() {
        }

        public void onOutgoing(String message) {
        }

        public void onIncoming(String message) {
        }

        public void onEvent(String text) {
        }

        public void onErrorEvent(String text) {
        }

        public void clear() {
        }
    }
}

