/*
 * Decompiled with CFR 0.152.
 */
package quickfix;

import quickfix.MessageStore;
import quickfix.MessageStoreFactory;
import quickfix.RuntimeError;
import quickfix.SessionID;
import quickfix.SessionSettings;
import quickfix.SleepycatStore;

public class SleepycatStoreFactory
implements MessageStoreFactory {
    public static final String SETTING_SLEEPYCAT_DATABASE_DIR = "SleepycatDatabaseDir";
    public static final String SETTING_SLEEPYCAT_SEQUENCE_DB_NAME = "SleepycatSequenceDbName";
    public static final String SETTING_SLEEPYCAT_MESSAGE_DB_NAME = "SleepycatMessageDbName";
    private SessionSettings settings = new SessionSettings();

    public SleepycatStoreFactory(SessionSettings settings) {
        this.settings = settings;
    }

    public MessageStore create(SessionID sessionID) {
        try {
            String dbDir = this.settings.getString(sessionID, SETTING_SLEEPYCAT_DATABASE_DIR);
            String seqDbName = "seq";
            if (this.settings.isSetting(sessionID, SETTING_SLEEPYCAT_SEQUENCE_DB_NAME)) {
                seqDbName = this.settings.getString(sessionID, SETTING_SLEEPYCAT_SEQUENCE_DB_NAME);
            }
            String msgDbName = "msg";
            if (this.settings.isSetting(sessionID, SETTING_SLEEPYCAT_MESSAGE_DB_NAME)) {
                msgDbName = this.settings.getString(sessionID, SETTING_SLEEPYCAT_MESSAGE_DB_NAME);
            }
            return new SleepycatStore(sessionID, dbDir, seqDbName, msgDbName);
        }
        catch (Exception e) {
            throw new RuntimeError(e);
        }
    }
}

