/*
 * Decompiled with CFR 0.152.
 */
package quickfix;

import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import quickfix.SystemTimeSource;

public class SystemTime {
    public static final TimeZone UTC_TIMEZONE = TimeZone.getTimeZone("UTC");
    private static SystemTimeSource DEFAULT_TIME_SOURCE;
    private static SystemTimeSource systemTimeSource;

    public static synchronized long currentTimeMillis() {
        return systemTimeSource.getTime();
    }

    public static Date getDate() {
        return new Date(SystemTime.currentTimeMillis());
    }

    public static synchronized void setTimeSource(SystemTimeSource systemTimeSource) {
        SystemTime.systemTimeSource = systemTimeSource != null ? systemTimeSource : DEFAULT_TIME_SOURCE;
    }

    public static Calendar getUtcCalendar() {
        Calendar c = Calendar.getInstance(UTC_TIMEZONE);
        c.setTimeInMillis(SystemTime.currentTimeMillis());
        return c;
    }

    public static Calendar getUtcCalendar(Date date) {
        Calendar c = SystemTime.getUtcCalendar();
        c.setTime(date);
        return c;
    }

    static {
        systemTimeSource = DEFAULT_TIME_SOURCE = new SystemTimeSource(){

            public long getTime() {
                return System.currentTimeMillis();
            }
        };
    }
}

