/*
 * Decompiled with CFR 0.152.
 */
package quickfix.field.converter;

import java.text.DateFormat;
import java.text.ParseException;
import java.util.Date;
import quickfix.FieldConvertError;
import quickfix.field.converter.AbstractDateTimeConverter;

public class UtcTimeOnlyConverter
extends AbstractDateTimeConverter {
    private static ThreadLocal<UtcTimeOnlyConverter> utcTimeConverter = new ThreadLocal();
    private DateFormat utcTimeFormat = this.createDateFormat("HH:mm:ss");
    private DateFormat utcTimeFormatMillis = this.createDateFormat("HH:mm:ss.SSS");

    public static String convert(Date d, boolean includeMilliseconds) {
        return UtcTimeOnlyConverter.getFormatter(includeMilliseconds).format(d);
    }

    private static DateFormat getFormatter(boolean includeMillis) {
        UtcTimeOnlyConverter converter = utcTimeConverter.get();
        if (converter == null) {
            converter = new UtcTimeOnlyConverter();
            utcTimeConverter.set(converter);
        }
        return includeMillis ? converter.utcTimeFormatMillis : converter.utcTimeFormat;
    }

    public static Date convert(String value) throws FieldConvertError {
        Date d = null;
        try {
            d = UtcTimeOnlyConverter.getFormatter(value.length() == 12).parse(value);
        }
        catch (ParseException e) {
            UtcTimeOnlyConverter.throwFieldConvertError(value, "time");
        }
        return d;
    }
}

