/*
 * Decompiled with CFR 0.152.
 */
package quickfix.mina;

import java.io.IOException;
import org.apache.mina.common.IoHandlerAdapter;
import org.apache.mina.common.IoSession;
import org.apache.mina.filter.codec.ProtocolCodecException;
import org.apache.mina.filter.codec.ProtocolDecoderException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import quickfix.InvalidMessage;
import quickfix.Message;
import quickfix.MessageUtils;
import quickfix.Session;
import quickfix.SessionID;
import quickfix.mina.CriticalProtocolCodecException;
import quickfix.mina.NetworkingOptions;

public abstract class AbstractIoHandler
extends IoHandlerAdapter {
    protected final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private final NetworkingOptions networkingOptions;

    public AbstractIoHandler(NetworkingOptions options) {
        this.networkingOptions = options;
    }

    public void exceptionCaught(IoSession ioSession, Throwable cause) throws Exception {
        String reason;
        boolean disconnectNeeded = false;
        Session quickFixSession = this.findQFSession(ioSession);
        Throwable realCause = cause;
        if (cause instanceof ProtocolDecoderException && cause.getCause() != null) {
            realCause = cause.getCause();
        }
        if (realCause instanceof IOException) {
            reason = quickFixSession != null && quickFixSession.isEnabled() ? "Socket exception (" + ioSession.getRemoteAddress() + "): " + cause : "Socket (" + ioSession.getRemoteAddress() + "): " + cause;
            disconnectNeeded = true;
        } else if (realCause instanceof CriticalProtocolCodecException) {
            reason = "Critical protocol codec error: " + cause;
            disconnectNeeded = true;
        } else {
            reason = realCause instanceof ProtocolCodecException ? "Protocol handler exception: " + cause : cause.toString();
        }
        if (disconnectNeeded) {
            if (quickFixSession != null) {
                quickFixSession.disconnect(reason, true);
            } else {
                this.log.error(reason, cause);
                ioSession.close();
            }
        } else {
            this.log.error(reason, cause);
        }
    }

    public void sessionCreated(IoSession ioSession) throws Exception {
        super.sessionCreated(ioSession);
        this.networkingOptions.apply(ioSession);
    }

    public void sessionClosed(IoSession ioSession) throws Exception {
        Session quickFixSession = this.findQFSession(ioSession);
        if (quickFixSession != null) {
            ioSession.removeAttribute("QF_SESSION");
            if (quickFixSession.hasResponder()) {
                quickFixSession.disconnect("IO Session closed", false);
            }
        }
    }

    public void messageReceived(IoSession ioSession, Object message) throws Exception {
        block5: {
            String messageString = (String)message;
            SessionID remoteSessionID = MessageUtils.getReverseSessionID(messageString);
            Session quickFixSession = this.findQFSession(ioSession, remoteSessionID);
            if (quickFixSession != null) {
                quickFixSession.getLog().onIncoming(messageString);
                try {
                    Message fixMessage = MessageUtils.parse(quickFixSession, messageString);
                    this.processMessage(ioSession, fixMessage);
                }
                catch (InvalidMessage e) {
                    if ("A".equals(MessageUtils.getMessageType(messageString))) {
                        this.log.error("Invalid LOGON message, disconnecting: " + e.getMessage());
                        ioSession.close();
                        break block5;
                    }
                    this.log.error("Invalid message: " + e.getMessage());
                }
            } else {
                this.log.error("Disconnecting; received message for unknown session: " + messageString);
                ioSession.close();
            }
        }
    }

    protected Session findQFSession(IoSession ioSession, SessionID sessionID) {
        Session quickfixSession = this.findQFSession(ioSession);
        if (quickfixSession == null) {
            quickfixSession = Session.lookupSession(sessionID);
        }
        return quickfixSession;
    }

    private Session findQFSession(IoSession ioSession) {
        return (Session)ioSession.getAttribute("QF_SESSION");
    }

    protected NetworkingOptions getNetworkingOptions() {
        return this.networkingOptions;
    }

    protected abstract void processMessage(IoSession var1, Message var2) throws Exception;
}

