/*
 * Decompiled with CFR 0.152.
 */
package quickfix.mina;

import org.quickfixj.java4.edu.emory.mathcs.backport.java.util.concurrent.BlockingQueue;
import org.quickfixj.java4.edu.emory.mathcs.backport.java.util.concurrent.LinkedBlockingQueue;
import org.quickfixj.java4.edu.emory.mathcs.backport.java.util.concurrent.TimeUnit;
import quickfix.FieldNotFound;
import quickfix.LogUtil;
import quickfix.Message;
import quickfix.Session;
import quickfix.SystemTime;
import quickfix.mina.EventHandlingStrategy;
import quickfix.mina.SessionConnector;

public class SingleThreadedEventHandlingStrategy
implements EventHandlingStrategy {
    private static final String MESSAGE_PROCESSOR_THREAD_NAME = "QFJ Message Processor";
    private final BlockingQueue<SessionMessageEvent> eventQueue = new LinkedBlockingQueue();
    private final SessionConnector sessionConnector;
    private boolean isStopped;
    private long stopTime = 0L;

    public SingleThreadedEventHandlingStrategy(SessionConnector connector) {
        this.sessionConnector = connector;
    }

    public void onMessage(Session quickfixSession, Message message) {
        try {
            this.eventQueue.put((Object)new SessionMessageEvent(quickfixSession, message));
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    public SessionConnector getSessionConnector() {
        return this.sessionConnector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void block() {
        while (true) {
            SingleThreadedEventHandlingStrategy singleThreadedEventHandlingStrategy = this;
            synchronized (singleThreadedEventHandlingStrategy) {
                if (this.isStopped) {
                    if (this.stopTime == 0L) {
                        this.stopTime = SystemTime.currentTimeMillis();
                    }
                    if (!this.sessionConnector.isLoggedOn() || SystemTime.currentTimeMillis() - this.stopTime > 5000L) {
                        this.sessionConnector.stopSessionTimer();
                        this.stopTime = 0L;
                        return;
                    }
                }
            }
            try {
                SessionMessageEvent event = this.getMessage();
                if (event == null) continue;
                event.processMessage();
            }
            catch (InterruptedException interruptedException) {
            }
        }
    }

    private SessionMessageEvent getMessage() throws InterruptedException {
        return (SessionMessageEvent)this.eventQueue.poll(1000L, TimeUnit.MILLISECONDS);
    }

    public void blockInThread() {
        this.startHandlingMessages();
        Thread messageProcessingThread = new Thread(new Runnable(){

            public void run() {
                SingleThreadedEventHandlingStrategy.this.block();
            }
        }, MESSAGE_PROCESSOR_THREAD_NAME);
        messageProcessingThread.setDaemon(true);
        messageProcessingThread.start();
    }

    private synchronized void startHandlingMessages() {
        this.isStopped = false;
    }

    public synchronized void stopHandlingMessages() {
        this.isStopped = true;
    }

    public int getQueueSize() {
        return this.eventQueue.size();
    }

    private static class SessionMessageEvent {
        private final Session quickfixSession;
        private final Message message;

        public SessionMessageEvent(Session session, Message message) {
            this.message = message;
            this.quickfixSession = session;
        }

        public void processMessage() {
            block6: {
                try {
                    if (this.quickfixSession.hasResponder()) {
                        this.quickfixSession.next(this.message);
                        break block6;
                    }
                    try {
                        String msgType = this.message.getHeader().getString(35);
                        if (msgType.equals("5")) {
                            this.quickfixSession.next(this.message);
                        }
                    }
                    catch (FieldNotFound ex) {}
                }
                catch (Throwable e) {
                    LogUtil.logThrowable(this.quickfixSession.getSessionID(), e.getMessage(), e);
                }
            }
        }
    }
}

