/*
 * Decompiled with CFR 0.152.
 */
package quickfix.mina;

import java.util.Collection;
import java.util.Iterator;
import org.quickfixj.java4.edu.emory.mathcs.backport.java.util.concurrent.BlockingQueue;
import org.quickfixj.java4.edu.emory.mathcs.backport.java.util.concurrent.ConcurrentHashMap;
import org.quickfixj.java4.edu.emory.mathcs.backport.java.util.concurrent.ConcurrentMap;
import org.quickfixj.java4.edu.emory.mathcs.backport.java.util.concurrent.LinkedBlockingQueue;
import org.quickfixj.java4.edu.emory.mathcs.backport.java.util.concurrent.TimeUnit;
import quickfix.LogUtil;
import quickfix.Message;
import quickfix.Session;
import quickfix.SessionID;
import quickfix.mina.EventHandlingStrategy;
import quickfix.mina.SessionConnector;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ThreadPerSessionEventHandlingStrategy
implements EventHandlingStrategy {
    private static final long THREAD_WAIT_FOR_MESSAGE_MS = 250L;
    private final ConcurrentMap<SessionID, MessageDispatchingThread> dispatchers = new ConcurrentHashMap();

    @Override
    public void onMessage(Session quickfixSession, Message message) {
        MessageDispatchingThread dispatcher = (MessageDispatchingThread)this.dispatchers.get((Object)quickfixSession.getSessionID());
        if (dispatcher == null) {
            MessageDispatchingThread temp = new MessageDispatchingThread(quickfixSession);
            dispatcher = (MessageDispatchingThread)this.dispatchers.putIfAbsent((Object)quickfixSession.getSessionID(), (Object)temp);
            if (dispatcher == null) {
                dispatcher = temp;
            }
            this.startDispatcherThread(dispatcher);
        }
        dispatcher.enqueue(message);
    }

    @Override
    public SessionConnector getSessionConnector() {
        return null;
    }

    protected void startDispatcherThread(MessageDispatchingThread dispatcher) {
        dispatcher.start();
    }

    public void stopDispatcherThreads() {
        Collection dispatchersToShutdown = this.dispatchers.values();
        for (MessageDispatchingThread dispatcher : dispatchersToShutdown) {
            dispatcher.stopDispatcher();
        }
        while (dispatchersToShutdown.size() > 0) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            Iterator iterator = dispatchersToShutdown.iterator();
            while (iterator.hasNext()) {
                MessageDispatchingThread messageDispatchingThread = (MessageDispatchingThread)iterator.next();
                if (!messageDispatchingThread.isStopped()) continue;
                iterator.remove();
            }
        }
    }

    BlockingQueue<Message> getMessages(SessionID sessionID) {
        MessageDispatchingThread dispatcher = this.getDispatcher(sessionID);
        return dispatcher.messages;
    }

    MessageDispatchingThread getDispatcher(SessionID sessionID) {
        return (MessageDispatchingThread)this.dispatchers.get((Object)sessionID);
    }

    Message getNextMessage(BlockingQueue<Message> messages) throws InterruptedException {
        return (Message)messages.poll(250L, TimeUnit.MILLISECONDS);
    }

    @Override
    public int getQueueSize() {
        int ret = 0;
        for (MessageDispatchingThread mdt : this.dispatchers.values()) {
            ret += mdt.getQueueSize();
        }
        return ret;
    }

    class MessageDispatchingThread
    extends Thread {
        private final Session quickfixSession;
        private final BlockingQueue<Message> messages;
        private volatile boolean stopped;
        private volatile boolean stopping;

        public MessageDispatchingThread(Session session) {
            super("QF/J Session dispatcher: " + session.getSessionID());
            this.messages = new LinkedBlockingQueue();
            this.stopped = false;
            this.stopping = false;
            this.quickfixSession = session;
        }

        public void enqueue(Message message) {
            try {
                this.messages.put((Object)message);
            }
            catch (InterruptedException e) {
                this.quickfixSession.getLog().onErrorEvent(e.toString());
            }
        }

        public int getQueueSize() {
            return this.messages.size();
        }

        public void run() {
            while (!this.stopping) {
                try {
                    Message message = ThreadPerSessionEventHandlingStrategy.this.getNextMessage(this.messages);
                    if (message == null || !this.quickfixSession.hasResponder()) continue;
                    this.quickfixSession.next(message);
                }
                catch (InterruptedException e) {
                    LogUtil.logThrowable(this.quickfixSession.getSessionID(), "Message dispatcher interrupted", (Throwable)e);
                    return;
                }
                catch (Throwable e) {
                    LogUtil.logThrowable(this.quickfixSession.getSessionID(), "Error during message processing", e);
                }
            }
            this.stopped = true;
        }

        public void stopDispatcher() {
            this.stopping = true;
            this.stopped = true;
        }

        public boolean isStopped() {
            return this.stopped;
        }
    }
}

