/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.application.deployment.management.impl;

import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.apache.aries.application.ApplicationMetadata;
import org.apache.aries.application.Content;
import org.apache.aries.application.InvalidAttributeException;
import org.apache.aries.application.ServiceDeclaration;
import org.apache.aries.application.deployment.management.internal.MessageUtil;
import org.apache.aries.application.management.AriesApplication;
import org.apache.aries.application.management.BundleInfo;
import org.apache.aries.application.management.ResolveConstraint;
import org.apache.aries.application.management.ResolverException;
import org.apache.aries.application.management.spi.resolve.AriesApplicationResolver;
import org.apache.aries.application.management.spi.resolve.DeploymentManifestManager;
import org.apache.aries.application.management.spi.resolve.PostResolveTransformer;
import org.apache.aries.application.management.spi.runtime.LocalPlatform;
import org.apache.aries.application.modelling.DeployedBundles;
import org.apache.aries.application.modelling.ExportedPackage;
import org.apache.aries.application.modelling.ExportedService;
import org.apache.aries.application.modelling.ImportedBundle;
import org.apache.aries.application.modelling.ImportedPackage;
import org.apache.aries.application.modelling.ModelledResource;
import org.apache.aries.application.modelling.ModelledResourceManager;
import org.apache.aries.application.modelling.ModellerException;
import org.apache.aries.application.modelling.ModellingManager;
import org.apache.aries.application.modelling.Provider;
import org.apache.aries.application.modelling.utils.ModellingHelper;
import org.apache.aries.application.utils.filesystem.FileSystem;
import org.apache.aries.application.utils.filesystem.IOUtils;
import org.apache.aries.application.utils.manifest.ManifestHeaderProcessor;
import org.osgi.framework.Filter;
import org.osgi.service.blueprint.container.ServiceUnavailableException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeploymentManifestManagerImpl
implements DeploymentManifestManager {
    private final Logger _logger = LoggerFactory.getLogger(DeploymentManifestManagerImpl.class);
    private AriesApplicationResolver resolver;
    private PostResolveTransformer postResolveTransformer = null;
    private ModelledResourceManager modelledResourceManager;
    private LocalPlatform localPlatform;
    private ModellingManager modellingManager;
    private ModellingHelper modellingHelper;
    private static final String FAKE_BUNDLE_NAME = "aries.internal.fake.service.bundle";

    public void setModellingManager(ModellingManager m) {
        this.modellingManager = m;
    }

    public void setModellingHelper(ModellingHelper mh) {
        this.modellingHelper = mh;
    }

    public LocalPlatform getLocalPlatform() {
        return this.localPlatform;
    }

    public void setLocalPlatform(LocalPlatform localPlatform) {
        this.localPlatform = localPlatform;
    }

    public ModelledResourceManager getModelledResourceManager() {
        return this.modelledResourceManager;
    }

    public void setModelledResourceManager(ModelledResourceManager modelledResourceManager) {
        this.modelledResourceManager = modelledResourceManager;
    }

    public void setPostResolveTransformer(PostResolveTransformer transformer) {
        this.postResolveTransformer = transformer;
    }

    public void setResolver(AriesApplicationResolver resolver) {
        this.resolver = resolver;
    }

    public Manifest generateDeploymentManifest(AriesApplication app, ResolveConstraint ... constraints) throws ResolverException {
        this._logger.debug("Method entry: {}, args {}", (Object)"generateDeploymentManifest", (Object)new Object[]{app, constraints});
        ApplicationMetadata appMetadata = app.getApplicationMetadata();
        Collection<ModelledResource> byValueBundles = null;
        try {
            byValueBundles = this.getByValueBundles(app);
        }
        catch (Exception e) {
            throw new ResolverException(e);
        }
        ArrayList bundlesToResolve = new ArrayList();
        bundlesToResolve.addAll(appMetadata.getApplicationContents());
        bundlesToResolve.addAll(app.getApplicationMetadata().getUseBundles());
        ArrayList<Content> restrictedReqs = new ArrayList<Content>();
        for (ResolveConstraint constraint : constraints) {
            Content content = ManifestHeaderProcessor.parseContent((String)constraint.getBundleName(), (String)constraint.getVersionRange().toString());
            restrictedReqs.add(content);
        }
        DeployedBundles deployedBundles = this.generateDeployedBundles(appMetadata, byValueBundles, restrictedReqs);
        Manifest man = this.generateDeploymentManifest(appMetadata.getApplicationSymbolicName(), appMetadata.getApplicationVersion().toString(), deployedBundles);
        this._logger.debug("Method exit: {}, returning {}", (Object)"generateDeploymentManifest", (Object)new Object[]{man});
        return man;
    }

    public DeployedBundles generateDeployedBundles(ApplicationMetadata appMetadata, Collection<ModelledResource> provideByValueBundles, Collection<Content> otherBundles) throws ResolverException {
        ModelledResource fakeBundleResource;
        this._logger.debug("Method entry: {}, args {}", (Object)"generateDeployedBundles", (Object)new Object[]{appMetadata, provideByValueBundles, otherBundles});
        Collection useBundleSet = appMetadata.getUseBundles();
        List appContent = appMetadata.getApplicationContents();
        ArrayList<Content> bundlesToResolve = new ArrayList<Content>();
        Set<ImportedBundle> appContentIB = this.toImportedBundle(appContent);
        Set<ImportedBundle> useBundleIB = this.toImportedBundle(useBundleSet);
        bundlesToResolve.addAll(useBundleSet);
        bundlesToResolve.addAll(appContent);
        bundlesToResolve.addAll(otherBundles);
        ArrayList<ModelledResource> byValueBundles = new ArrayList<ModelledResource>(provideByValueBundles);
        try {
            fakeBundleResource = this.createFakeBundle(appMetadata.getApplicationImportServices());
        }
        catch (InvalidAttributeException iax) {
            ResolverException rx = new ResolverException((Exception)((Object)iax));
            this._logger.debug("Method exit: {}, returning {}", (Object)"generateDeploymentManifest", (Object)new Object[]{rx});
            throw rx;
        }
        byValueBundles.add(fakeBundleResource);
        String appSymbolicName = appMetadata.getApplicationSymbolicName();
        String appVersion = appMetadata.getApplicationVersion().toString();
        String uniqueName = appSymbolicName + "_" + appVersion;
        DeployedBundles deployedBundles = this.modellingHelper.createDeployedBundles(appSymbolicName, appContentIB, useBundleIB, Arrays.asList(fakeBundleResource));
        Collection bundlesToBeProvisioned = this.resolver.resolve(appSymbolicName, appVersion, byValueBundles, bundlesToResolve);
        this.pruneFakeBundleFromResults(bundlesToBeProvisioned);
        if (bundlesToBeProvisioned.isEmpty()) {
            throw new ResolverException(MessageUtil.getMessage("EMPTY_DEPLOYMENT_CONTENT", uniqueName));
        }
        for (ModelledResource rbm : bundlesToBeProvisioned) {
            deployedBundles.addBundle(rbm);
        }
        Collection requiredUseBundle = deployedBundles.getRequiredUseBundle();
        if (requiredUseBundle.size() < useBundleSet.size()) {
            deployedBundles = this.modellingHelper.createDeployedBundles(appSymbolicName, appContentIB, useBundleIB, Arrays.asList(fakeBundleResource));
            bundlesToResolve.clear();
            bundlesToResolve.addAll(appContent);
            Collection<ImportedBundle> slimmedDownUseBundle = this.narrowUseBundles(useBundleIB, requiredUseBundle);
            bundlesToResolve.addAll(this.toContent(slimmedDownUseBundle));
            bundlesToBeProvisioned = this.resolver.resolve(appSymbolicName, appVersion, byValueBundles, bundlesToResolve);
            this.pruneFakeBundleFromResults(bundlesToBeProvisioned);
            for (ModelledResource rbm : bundlesToBeProvisioned) {
                deployedBundles.addBundle(rbm);
            }
        }
        HashSet<ModelledResource> sharedBundles = new HashSet<ModelledResource>();
        sharedBundles.addAll(deployedBundles.getDeployedProvisionBundle());
        sharedBundles.addAll(deployedBundles.getRequiredUseBundle());
        Collection appContentBundles = deployedBundles.getDeployedContent();
        ArrayList<Content> requiredSharedBundles = new ArrayList<Content>();
        for (ModelledResource mr : sharedBundles) {
            String version = mr.getExportedBundle().getVersion();
            String exactVersion = "[" + version + "," + version + "]";
            Content ib = ManifestHeaderProcessor.parseContent((String)mr.getExportedBundle().getSymbolicName(), (String)exactVersion);
            requiredSharedBundles.add(ib);
        }
        Collection resolvedSharedBundles = this.resolver.resolve(appSymbolicName, appVersion, byValueBundles, requiredSharedBundles);
        List<String> suspects = this.findSuspects(resolvedSharedBundles, sharedBundles, appContentBundles);
        if (!suspects.isEmpty()) {
            String mrName;
            StringBuilder msgs = new StringBuilder();
            ArrayList<String> unsatisfiedRequirements = new ArrayList<String>();
            HashMap isolatedBundles = new HashMap();
            for (ModelledResource mr : resolvedSharedBundles) {
                mrName = mr.getSymbolicName() + "_" + mr.getExportedBundle().getVersion();
                if (!suspects.contains(mrName)) continue;
                ArrayList<String> exportedPackages = new ArrayList<String>();
                isolatedBundles.put(mrName, exportedPackages);
                for (ExportedPackage ep : mr.getExportedPackages()) {
                    exportedPackages.add(ep.getPackageName());
                }
            }
            for (ModelledResource mr : resolvedSharedBundles) {
                mrName = mr.getSymbolicName() + "_" + mr.getExportedBundle().getVersion();
                if (suspects.contains(mrName)) continue;
                for (ImportedPackage ip : mr.getImportedPackages()) {
                    String packageName = ip.getPackageName();
                    ArrayList bundlesExportingPackage = new ArrayList();
                    for (Map.Entry currBundle : isolatedBundles.entrySet()) {
                        List exportedPackages = (List)currBundle.getValue();
                        if (exportedPackages == null || !exportedPackages.contains(packageName)) continue;
                        bundlesExportingPackage.add(currBundle.getKey());
                    }
                    if (bundlesExportingPackage.isEmpty()) continue;
                    String newMsg = bundlesExportingPackage.size() > 1 ? MessageUtil.getMessage("SHARED_BUNDLE_IMPORTING_FROM_ISOLATED_BUNDLES", mrName, packageName, bundlesExportingPackage) : MessageUtil.getMessage("SHARED_BUNDLE_IMPORTING_FROM_ISOLATED_BUNDLE", mrName, packageName, bundlesExportingPackage);
                    msgs.append("\n");
                    msgs.append(newMsg);
                    unsatisfiedRequirements.add(newMsg);
                }
            }
            if (msgs.length() != 0) {
                String message = MessageUtil.getMessage("SUSPECTED_CIRCULAR_DEPENDENCIES", appSymbolicName, msgs);
                ResolverException rx = new ResolverException(message);
                rx.setUnsatisfiedRequirements(unsatisfiedRequirements);
                this._logger.debug("Method exit: {}, returning {}", (Object)"generateDeploymentManifest", (Object)new Object[]{rx});
                throw rx;
            }
        }
        this.checkForIsolatedContentInProvisionBundle(appSymbolicName, deployedBundles);
        if (this.postResolveTransformer != null) {
            try {
                deployedBundles = this.postResolveTransformer.postResolveProcess(appMetadata, deployedBundles);
            }
            catch (ServiceUnavailableException e) {
                this._logger.debug(MessageUtil.getMessage("POST_RESOLVE_TRANSFORMER_UNAVAILABLE", new Object[]{e}));
            }
        }
        return deployedBundles;
    }

    public Manifest generateDeploymentManifest(String appSymbolicName, String appVersion, DeployedBundles deployedBundles) throws ResolverException {
        this._logger.debug("Method entry: {}, args {}", (Object)"generateDeploymentManifest", (Object)new Object[]{appSymbolicName, appVersion, deployedBundles});
        Map<String, String> deploymentManifestMap = this.generateDeploymentAttributes(appSymbolicName, appVersion, deployedBundles);
        Manifest man = this.convertMapToManifest(deploymentManifestMap);
        this._logger.debug("Method exit: {}, returning {}", (Object)"generateDeploymentManifest", (Object)man);
        return man;
    }

    private Collection<ImportedBundle> narrowUseBundles(Collection<ImportedBundle> useBundleSet, Collection<ModelledResource> requiredUseBundle) {
        this._logger.debug("Method entry: {}, args {}", (Object)"narrowUseBundles", (Object)new Object[]{useBundleSet, requiredUseBundle});
        HashSet<ImportedBundle> result = new HashSet<ImportedBundle>();
        block0: for (ImportedBundle ib : useBundleSet) {
            for (ModelledResource mb : requiredUseBundle) {
                if (!ib.isSatisfied((Provider)mb.getExportedBundle())) continue;
                result.add(ib);
                continue block0;
            }
        }
        this._logger.debug("Method exit: {}, returning {}", (Object)"narrowUseBundles", result);
        return result;
    }

    private Map<String, String> generateDeploymentAttributes(String appSymbolicName, String version, DeployedBundles deployedBundles) throws ResolverException {
        String importPackages;
        String importServices;
        String provisionBundle;
        this._logger.debug("Method entry: {}, args {}", (Object)"generateDeploymentAttributes", (Object)new Object[]{appSymbolicName, version});
        HashMap<String, String> result = new HashMap<String, String>();
        String content = deployedBundles.getContent();
        if (content.isEmpty()) {
            throw new ResolverException(MessageUtil.getMessage("EMPTY_DEPLOYMENT_CONTENT", appSymbolicName));
        }
        result.put("Deployed-Content", content);
        String useBundle = deployedBundles.getUseBundle();
        if (!useBundle.isEmpty()) {
            result.put("Deployed-Use-Bundle", useBundle);
        }
        if (!(provisionBundle = deployedBundles.getProvisionBundle()).isEmpty()) {
            result.put("Provision-Bundle", provisionBundle);
        }
        if (!(importServices = deployedBundles.getDeployedImportService()).isEmpty()) {
            result.put("DeployedService-Import", importServices);
        }
        if (!(importPackages = deployedBundles.getImportPackage()).isEmpty()) {
            result.put("Import-Package", importPackages);
        }
        result.put("Application-Version", version);
        result.put("Application-SymbolicName", appSymbolicName);
        result.putAll(deployedBundles.getExtraHeaders());
        this._logger.debug("Method exit: {}, returning {}", (Object)"generateDeploymentAttributes", result);
        return result;
    }

    private Manifest convertMapToManifest(Map<String, String> attributes) {
        this._logger.debug("Method entry: {}, args {}", (Object)"convertMapToManifest", (Object)new Object[]{attributes});
        Manifest man = new Manifest();
        Attributes att = man.getMainAttributes();
        att.putValue(Attributes.Name.MANIFEST_VERSION.toString(), "1.0");
        for (Map.Entry<String, String> entry : attributes.entrySet()) {
            att.putValue(entry.getKey(), entry.getValue());
        }
        this._logger.debug("Method exit: {}, returning {}", (Object)"convertMapToManifest", (Object)new Object[]{man});
        return man;
    }

    private ModelledResource createFakeBundle(Collection<ServiceDeclaration> appImportServices) throws InvalidAttributeException {
        this._logger.debug("Method entry: {}, args {}", (Object)"createFakeBundle", (Object)new Object[]{appImportServices});
        Attributes attrs = new Attributes();
        attrs.putValue("Bundle-SymbolicName", FAKE_BUNDLE_NAME);
        attrs.putValue("bundle-version", "1.0");
        attrs.putValue("Bundle-ManifestVersion", "2");
        ArrayList<ExportedService> exportedServices = new ArrayList<ExportedService>();
        for (ServiceDeclaration sDec : appImportServices) {
            List<String> ifaces = Arrays.asList(sDec.getInterfaceName());
            Filter filter = sDec.getFilter();
            HashMap<String, String> serviceProperties = filter != null ? ManifestHeaderProcessor.parseFilter((String)filter.toString()) : new HashMap<String, String>();
            serviceProperties.put("service.imported", "");
            exportedServices.add(this.modellingManager.getExportedService("", 0, ifaces, new HashMap(serviceProperties)));
        }
        ModelledResource fakeBundle = this.modellingManager.getModelledResource(null, attrs, null, exportedServices);
        this._logger.debug("Method exit: {}, returning {}", (Object)"createFakeBundle", (Object)new Object[]{fakeBundle});
        return fakeBundle;
    }

    private void pruneFakeBundleFromResults(Collection<ModelledResource> results) {
        this._logger.debug("Method entry: {}, args {}", (Object)"pruneFakeBundleFromResults", (Object)new Object[]{results});
        boolean fakeBundleRemoved = false;
        Iterator<ModelledResource> it = results.iterator();
        while (!fakeBundleRemoved && it.hasNext()) {
            ModelledResource mr = it.next();
            if (!mr.getExportedBundle().getSymbolicName().equals(FAKE_BUNDLE_NAME)) continue;
            it.remove();
            fakeBundleRemoved = true;
        }
        this._logger.debug("Method exit: {}, returning {}", (Object)"pruneFakeBundleFromResults");
    }

    private List<String> findSuspects(Collection<ModelledResource> resolvedSharedBundles, Collection<ModelledResource> sharedBundles, Collection<ModelledResource> appContentBundles) {
        this._logger.debug("Method entry: {}, args {}", (Object)"findSuspects", (Object)new Object[]{resolvedSharedBundles, sharedBundles, appContentBundles});
        HashSet<String> expectedBundles = new HashSet<String>();
        HashSet<String> isolatedBundles = new HashSet<String>();
        for (ModelledResource sb : sharedBundles) {
            expectedBundles.add(sb.getExportedBundle().getSymbolicName() + "_" + sb.getExportedBundle().getVersion());
        }
        for (ModelledResource sb : appContentBundles) {
            isolatedBundles.add(sb.getExportedBundle().getSymbolicName() + "_" + sb.getExportedBundle().getVersion());
        }
        ArrayList<String> suspects = new ArrayList<String>();
        for (ModelledResource mr : resolvedSharedBundles) {
            String thisBundle = mr.getExportedBundle().getSymbolicName() + "_" + mr.getExportedBundle().getVersion();
            if (expectedBundles.contains(thisBundle) || !isolatedBundles.contains(thisBundle)) continue;
            suspects.add(thisBundle);
        }
        this._logger.debug("Method exit: {}, returning {}", (Object)"findSuspects", (Object)new Object[]{suspects});
        return suspects;
    }

    private void checkForIsolatedContentInProvisionBundle(String applicationSymbolicName, DeployedBundles db) throws ResolverException {
        for (ModelledResource isolatedBundle : db.getDeployedContent()) {
            for (ModelledResource provisionBundle : db.getDeployedProvisionBundle()) {
                if (!isolatedBundle.getSymbolicName().equals(provisionBundle.getSymbolicName()) || !this.providesPackage(provisionBundle, db.getImportPackage())) continue;
                throw new ResolverException(MessageUtil.getMessage("ISOLATED_CONTENT_PROVISIONED", applicationSymbolicName, isolatedBundle.getSymbolicName(), isolatedBundle.getVersion(), provisionBundle.getVersion()));
            }
        }
    }

    private boolean providesPackage(ModelledResource bundle, String importPackages) {
        Map imports = ManifestHeaderProcessor.parseImportString((String)importPackages);
        try {
            for (Map.Entry e : imports.entrySet()) {
                ImportedPackage importPackage = this.modellingManager.getImportedPackage((String)e.getKey(), (Map)e.getValue());
                for (ExportedPackage export : bundle.getExportedPackages()) {
                    if (!importPackage.isSatisfied((Provider)export)) continue;
                    return true;
                }
            }
        }
        catch (InvalidAttributeException iae) {
            this._logger.error(MessageUtil.getMessage("UNEXPECTED_EXCEPTION_PARSING_IMPORTS", new Object[]{iae, importPackages}), (Throwable)iae);
        }
        return false;
    }

    private Set<ImportedBundle> toImportedBundle(Collection<Content> content) throws ResolverException {
        this._logger.debug("Method entry: {}, args {}", (Object)"toImportedBundle", (Object)new Object[]{content});
        HashSet<ImportedBundle> result = new HashSet<ImportedBundle>();
        for (Content c : content) {
            try {
                result.add(this.modellingManager.getImportedBundle(c.getContentName(), c.getVersion().toString()));
            }
            catch (InvalidAttributeException iax) {
                ResolverException rx = new ResolverException((Exception)((Object)iax));
                this._logger.debug("Method exit: {}, returning {}", (Object)"toImportedBundle", (Object)new Object[]{rx});
                throw rx;
            }
        }
        this._logger.debug("Method exit: {}, returning {}", (Object)"toImportedBundle", (Object)new Object[]{result});
        return result;
    }

    private Collection<Content> toContent(Collection<ImportedBundle> ibs) {
        ArrayList<Content> contents = new ArrayList<Content>();
        for (ImportedBundle ib : ibs) {
            contents.add(ManifestHeaderProcessor.parseContent((String)ib.getSymbolicName(), (String)ib.getVersionRange()));
        }
        return contents;
    }

    private Collection<ModelledResource> getByValueBundles(AriesApplication app) throws IOException, InvalidAttributeException, ModellerException {
        this._logger.debug("Method entry: {}, args {}", (Object)"getByValueBundles", (Object)new Object[]{app});
        Set bundles = app.getBundleInfo();
        ArrayList<ModelledResource> result = new ArrayList<ModelledResource>();
        for (BundleInfo bundleInfo : bundles) {
            String bundleLocation = bundleInfo.getLocation();
            String bundleFileName = bundleLocation.substring(bundleLocation.lastIndexOf(47) + 1);
            URL jarUrl = new URL(bundleLocation);
            URLConnection jarCon = jarUrl.openConnection();
            jarCon.connect();
            InputStream in = jarCon.getInputStream();
            File temp = new File(this.getLocalPlatform().getTemporaryDirectory() + bundleFileName);
            FileOutputStream out = new FileOutputStream(temp);
            IOUtils.copy((InputStream)in, (OutputStream)out);
            IOUtils.close((Closeable)out);
            result.add(this.modelledResourceManager.getModelledResource(null, FileSystem.getFSRoot((File)temp)));
            temp.delete();
        }
        this._logger.debug("Method exit: {}, returning {}", (Object)"getByValueBundles", (Object)new Object[]{result});
        return result;
    }
}

