/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.application.deployment.management.internal;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MessageUtil {
    private static final ResourceBundle messages = ResourceBundle.getBundle("org.apache.aries.application.deployment.management.messages.DeploymentManagementMessages");
    private List<Message> errors = new ArrayList<Message>();
    private List<Message> warnings = new ArrayList<Message>();
    private final String fileName;

    public MessageUtil(String fileName) {
        this.fileName = fileName;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void processMessages() {
        for (Message m : this.errors) {
        }
        for (Message message : this.warnings) {
        }
    }

    public List<String> getErrors() {
        ArrayList<String> result = new ArrayList<String>(this.warnings.size());
        for (Message m : this.warnings) {
            result.add(MessageFormat.format(messages.getString(m.msgKey), m.inserts));
        }
        return result;
    }

    public List<String> getWarnings() {
        ArrayList<String> result = new ArrayList<String>(this.warnings.size());
        for (Message m : this.warnings) {
            result.add(MessageFormat.format(messages.getString(m.msgKey), m.inserts));
        }
        return result;
    }

    public void clear() {
        this.errors.clear();
        this.warnings.clear();
    }

    public boolean hasErrors() {
        return !this.errors.isEmpty();
    }

    public void error(String msgKey, Object ... inserts) {
        this.errors.add(new Message(msgKey, null, inserts));
    }

    public void error(String msgKey, Exception e, Object ... inserts) {
        this.errors.add(new Message(msgKey, e, inserts));
    }

    public void warning(String msgKey, Object ... inserts) {
        this.warnings.add(new Message(msgKey, null, inserts));
    }

    public void warning(String msgKey, Exception e, Object ... inserts) {
        this.warnings.add(new Message(msgKey, e, inserts));
    }

    public static final String getMessage(String key, Object ... inserts) {
        String msg = messages.getString(key);
        if (inserts.length > 0) {
            msg = MessageFormat.format(msg, inserts);
        }
        return msg;
    }

    private static class Message {
        public String msgKey;
        public Object[] inserts;
        public Exception cause;

        public Message(String msgKey, Exception cause, Object[] inserts) {
            this.msgKey = msgKey;
            this.cause = cause;
            this.inserts = inserts;
        }
    }
}

