/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.jruby.CompatVersion;
import org.jruby.IncludedModuleWrapper;
import org.jruby.MetaClass;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyInstanceConfig;
import org.jruby.RubyKernel;
import org.jruby.RubyMethod;
import org.jruby.RubyNameError;
import org.jruby.RubyNumeric;
import org.jruby.RubyObject;
import org.jruby.RubyProc;
import org.jruby.RubyString;
import org.jruby.RubySymbol;
import org.jruby.RubyUnboundMethod;
import org.jruby.anno.FrameField;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyConstant;
import org.jruby.anno.JRubyMethod;
import org.jruby.anno.JavaMethodDescriptor;
import org.jruby.anno.TypePopulator;
import org.jruby.common.IRubyWarnings;
import org.jruby.compiler.ASTInspector;
import org.jruby.exceptions.RaiseException;
import org.jruby.internal.runtime.methods.AliasMethod;
import org.jruby.internal.runtime.methods.CallConfiguration;
import org.jruby.internal.runtime.methods.DefaultMethod;
import org.jruby.internal.runtime.methods.DynamicMethod;
import org.jruby.internal.runtime.methods.FullFunctionCallbackMethod;
import org.jruby.internal.runtime.methods.JavaMethod;
import org.jruby.internal.runtime.methods.MethodMethod;
import org.jruby.internal.runtime.methods.ProcMethod;
import org.jruby.internal.runtime.methods.ProfilingDynamicMethod;
import org.jruby.internal.runtime.methods.SimpleCallbackMethod;
import org.jruby.internal.runtime.methods.SynchronizedDynamicMethod;
import org.jruby.internal.runtime.methods.UndefinedMethod;
import org.jruby.internal.runtime.methods.WrapperMethod;
import org.jruby.javasupport.util.RuntimeHelpers;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.CallSite;
import org.jruby.runtime.CallType;
import org.jruby.runtime.MethodFactory;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.builtin.Variable;
import org.jruby.runtime.callback.Callback;
import org.jruby.runtime.callsite.CacheEntry;
import org.jruby.runtime.callsite.FunctionalCachingCallSite;
import org.jruby.runtime.load.IAutoloadMethod;
import org.jruby.runtime.marshal.MarshalStream;
import org.jruby.runtime.marshal.UnmarshalStream;
import org.jruby.util.ClassProvider;
import org.jruby.util.IdUtil;
import org.jruby.util.collections.WeakHashSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@JRubyClass(name={"Module"})
public class RubyModule
extends RubyObject {
    private static final boolean DEBUG = false;
    protected static final String ERR_INSECURE_SET_CONSTANT = "Insecure: can't modify constant";
    protected static final String ERR_FROZEN_CONST_TYPE = "class/module ";
    public static final Set<String> SCOPE_CAPTURING_METHODS = new HashSet<String>(Arrays.asList("eval", "module_eval", "class_eval", "instance_eval", "module_exec", "class_exec", "instance_exec", "binding", "local_variables"));
    public static final ObjectAllocator MODULE_ALLOCATOR = new ObjectAllocator(){

        public IRubyObject allocate(Ruby runtime2, RubyClass klass) {
            return new RubyModule(runtime2, klass);
        }
    };
    protected static final CacheEntryFactory NormalCacheEntryFactory = new CacheEntryFactory(){

        public CacheEntry newCacheEntry(DynamicMethod method2, int token) {
            return new CacheEntry(method2, token);
        }
    };
    private volatile CacheEntryFactory cacheEntryFactory;
    protected static final String ERR_INSECURE_SET_CLASS_VAR = "Insecure: can't modify class variable";
    protected static final String ERR_FROZEN_CVAR_TYPE = "class/module ";
    public KindOf kindOf = KindOf.DEFAULT_KIND_OF;
    public final int id;
    public RubyModule parent;
    protected String baseName;
    private String calculatedName;
    private String anonymousName;
    private volatile Map<String, IRubyObject> constants = Collections.EMPTY_MAP;
    private volatile Map<String, Autoload> autoloads = Collections.EMPTY_MAP;
    private volatile Map<String, DynamicMethod> methods = Collections.EMPTY_MAP;
    protected Map<String, CacheEntry> cachedMethods = Collections.EMPTY_MAP;
    protected int generation;
    protected volatile Set<RubyClass> includingHierarchies = Collections.EMPTY_SET;
    private volatile transient Set<ClassProvider> classProviders = Collections.EMPTY_SET;
    protected RubyClass superClass;
    public int index;
    private volatile Map<String, IRubyObject> classVariables = Collections.EMPTY_MAP;

    public static RubyClass createModuleClass(Ruby runtime2, RubyClass moduleClass) {
        moduleClass.index = 12;
        moduleClass.setReifiedClass(RubyModule.class);
        moduleClass.kindOf = new KindOf(){

            public boolean isKindOf(IRubyObject obj, RubyModule type2) {
                return obj instanceof RubyModule;
            }
        };
        moduleClass.defineAnnotatedMethods(RubyModule.class);
        moduleClass.defineAnnotatedMethods(ModuleKernelMethods.class);
        return moduleClass;
    }

    @Override
    public int getNativeTypeIndex() {
        return 12;
    }

    @Override
    public boolean isModule() {
        return true;
    }

    @Override
    public boolean isClass() {
        return false;
    }

    public boolean isSingleton() {
        return false;
    }

    public boolean isInstance(IRubyObject object) {
        return this.kindOf.isKindOf(object, this);
    }

    public Map<String, IRubyObject> getConstantMap() {
        return this.constants;
    }

    public synchronized Map<String, IRubyObject> getConstantMapForWrite() {
        return this.constants == Collections.EMPTY_MAP ? (this.constants = new ConcurrentHashMap<String, IRubyObject>(4, 0.9f, 1)) : this.constants;
    }

    private Map<String, Autoload> getAutoloadMap() {
        return this.autoloads;
    }

    private synchronized Map<String, Autoload> getAutoloadMapForWrite() {
        return this.autoloads == Collections.EMPTY_MAP ? (this.autoloads = new ConcurrentHashMap<String, Autoload>(4, 0.9f, 1)) : this.autoloads;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addIncludingHierarchy(IncludedModuleWrapper hierarchy) {
        Object object = this.getRuntime().getHierarchyLock();
        synchronized (object) {
            Set<RubyClass> oldIncludingHierarchies = this.includingHierarchies;
            if (oldIncludingHierarchies == Collections.EMPTY_SET) {
                this.includingHierarchies = oldIncludingHierarchies = new WeakHashSet<RubyClass>(4);
            }
            oldIncludingHierarchies.add(hierarchy);
        }
    }

    protected RubyModule(Ruby runtime2, RubyClass metaClass, boolean objectSpace) {
        super(runtime2, metaClass, objectSpace);
        this.id = runtime2.allocModuleId();
        runtime2.addModule(this);
        this.setFlag(4096, !this.isClass());
        this.generation = runtime2.getNextModuleGeneration();
        this.cacheEntryFactory = runtime2.getInstanceConfig().isProfiling() ? new ProfilingCacheEntryFactory(NormalCacheEntryFactory) : NormalCacheEntryFactory;
    }

    protected RubyModule(Ruby runtime2, RubyClass metaClass) {
        this(runtime2, metaClass, runtime2.isObjectSpaceEnabled());
    }

    protected RubyModule(Ruby runtime2) {
        this(runtime2, runtime2.getModule());
    }

    public boolean needsImplementer() {
        return this.getFlag(4096);
    }

    public static RubyModule newModule(Ruby runtime2) {
        return new RubyModule(runtime2);
    }

    public static RubyModule newModule(Ruby runtime2, String name2, RubyModule parent, boolean setParent) {
        RubyModule module = RubyModule.newModule(runtime2);
        module.setBaseName(name2);
        if (setParent) {
            module.setParent(parent);
        }
        parent.setConstant(name2, module);
        return module;
    }

    public synchronized void addClassProvider(ClassProvider provider) {
        if (!this.classProviders.contains(provider)) {
            HashSet<ClassProvider> cp = new HashSet<ClassProvider>(this.classProviders);
            cp.add(provider);
            this.classProviders = cp;
        }
    }

    public synchronized void removeClassProvider(ClassProvider provider) {
        HashSet<ClassProvider> cp = new HashSet<ClassProvider>(this.classProviders);
        cp.remove(provider);
        this.classProviders = cp;
    }

    private void checkForCyclicInclude(RubyModule m) throws RaiseException {
        if (this.getNonIncludedClass() == m.getNonIncludedClass()) {
            throw this.getRuntime().newArgumentError("cyclic include detected");
        }
    }

    private RubyClass searchProvidersForClass(String name2, RubyClass superClazz) {
        for (ClassProvider classProvider : this.classProviders) {
            RubyClass clazz = classProvider.defineClassUnder(this, name2, superClazz);
            if (clazz == null) continue;
            return clazz;
        }
        return null;
    }

    private RubyModule searchProvidersForModule(String name2) {
        for (ClassProvider classProvider : this.classProviders) {
            RubyModule module = classProvider.defineModuleUnder(this, name2);
            if (module == null) continue;
            return module;
        }
        return null;
    }

    public RubyClass getSuperClass() {
        return this.superClass;
    }

    public void setSuperClass(RubyClass superClass) {
        this.superClass = superClass;
        if (superClass != null && superClass.isSynchronized()) {
            this.becomeSynchronized();
        }
    }

    public RubyModule getParent() {
        return this.parent;
    }

    public void setParent(RubyModule parent) {
        this.parent = parent;
    }

    public Map<String, DynamicMethod> getMethods() {
        return this.methods;
    }

    public synchronized Map<String, DynamicMethod> getMethodsForWrite() {
        Map<String, DynamicMethod> myMethods = this.methods;
        return myMethods == Collections.EMPTY_MAP ? (this.methods = new ConcurrentHashMap<String, DynamicMethod>(0, 0.9f, 1)) : myMethods;
    }

    private void putMethod(String name2, DynamicMethod method2) {
        this.getMethodsForWrite().put(name2, method2);
        this.getRuntime().addProfiledMethod(name2, method2);
    }

    public boolean isIncluded() {
        return false;
    }

    public RubyModule getNonIncludedClass() {
        return this;
    }

    public String getBaseName() {
        return this.baseName;
    }

    public void setBaseName(String name2) {
        String oldName = this.baseName;
        this.baseName = name2;
        if (oldName == null) {
            this.calculatedName = null;
        }
    }

    public String getName() {
        if (this.calculatedName == null) {
            return this.calculateName();
        }
        return this.calculatedName;
    }

    private String calculateName() {
        if (this.getBaseName() == null) {
            return this.calculateAnonymousName();
        }
        Ruby runtime2 = this.getRuntime();
        String name2 = this.getBaseName();
        int parentCount = 0;
        for (RubyModule p2 = this.getParent(); p2 != null && p2 != runtime2.getObject(); p2 = p2.getParent()) {
            ++parentCount;
        }
        String[] parentNames = new String[parentCount];
        int i2 = parentCount - 1;
        int totalLength = name2.length() + parentCount * 2;
        RubyModule p3 = this.getParent();
        while (p3 != null && p3 != runtime2.getObject()) {
            String pName = p3.getBaseName();
            if (pName == null) {
                pName = p3.getName();
            }
            parentNames[i2] = pName;
            totalLength += pName.length();
            p3 = p3.getParent();
            --i2;
        }
        StringBuilder builder = new StringBuilder(totalLength);
        for (String parentName : parentNames) {
            builder.append(parentName).append("::");
        }
        builder.append(name2);
        this.calculatedName = builder.toString();
        return this.calculatedName;
    }

    private String calculateAnonymousName() {
        if (this.anonymousName == null) {
            StringBuilder anonBase = new StringBuilder(this.isClass() ? "#<Class:0x" : "#<Module:0x");
            anonBase.append(Integer.toHexString(System.identityHashCode(this))).append('>');
            this.anonymousName = anonBase.toString();
        }
        return this.anonymousName;
    }

    @Deprecated
    public IncludedModuleWrapper newIncludeClass(RubyClass superClazz) {
        IncludedModuleWrapper includedModule = new IncludedModuleWrapper(this.getRuntime(), superClazz, this);
        if (this.getSuperClass() != null) {
            includedModule.includeModule(this.getSuperClass());
        }
        return includedModule;
    }

    public RubyClass getClass(String name2) {
        IRubyObject module = this.getConstantAt(name2);
        if (module instanceof RubyClass) {
            return (RubyClass)module;
        }
        return null;
    }

    public RubyClass fastGetClass(String internedName) {
        IRubyObject module = this.fastGetConstantAt(internedName);
        if (module instanceof RubyClass) {
            return (RubyClass)module;
        }
        return null;
    }

    public synchronized void includeModule(IRubyObject arg2) {
        assert (arg2 != null);
        this.testFrozen("module");
        if (!this.isTaint()) {
            this.getRuntime().secure(4);
        }
        if (!(arg2 instanceof RubyModule)) {
            throw this.getRuntime().newTypeError("Wrong argument type " + arg2.getMetaClass().getName() + " (expected Module).");
        }
        RubyModule module = (RubyModule)arg2;
        this.checkForCyclicInclude(module);
        this.infectBy(module);
        this.doIncludeModule(module);
        this.invalidateConstantCache();
        this.invalidateCoreClasses();
        this.invalidateCacheDescendants();
    }

    public void defineMethod(String name2, Callback method2) {
        Visibility visibility = name2.equals("initialize") ? Visibility.PRIVATE : Visibility.PUBLIC;
        this.addMethod(name2, new FullFunctionCallbackMethod(this, method2, visibility));
    }

    public void defineAnnotatedMethod(Class clazz, String name2) {
        boolean foundMethod = false;
        for (Method method2 : clazz.getDeclaredMethods()) {
            if (!method2.getName().equals(name2) || !this.defineAnnotatedMethod(method2, MethodFactory.createFactory(this.getRuntime().getJRubyClassLoader()))) continue;
            foundMethod = true;
        }
        if (!foundMethod) {
            throw new RuntimeException("No JRubyMethod present for method " + name2 + "on class " + clazz.getName());
        }
    }

    public void defineAnnotatedConstants(Class clazz) {
        Field[] declaredFields;
        for (Field field2 : declaredFields = clazz.getDeclaredFields()) {
            if (!Modifier.isStatic(field2.getModifiers())) continue;
            this.defineAnnotatedConstant(field2);
        }
    }

    public boolean defineAnnotatedConstant(Field field2) {
        IRubyObject realVal;
        JRubyConstant jrubyConstant = field2.getAnnotation(JRubyConstant.class);
        if (jrubyConstant == null) {
            return false;
        }
        String[] names2 = jrubyConstant.value();
        if (names2.length == 0) {
            names2 = new String[]{field2.getName()};
        }
        Class<?> tp = field2.getType();
        try {
            realVal = tp == Integer.class || tp == Integer.TYPE || tp == Short.class || tp == Short.TYPE || tp == Byte.class || tp == Byte.TYPE ? RubyNumeric.int2fix(this.getRuntime(), field2.getInt(null)) : (tp == Boolean.class || tp == Boolean.TYPE ? (field2.getBoolean(null) ? this.getRuntime().getTrue() : this.getRuntime().getFalse()) : this.getRuntime().getNil());
        }
        catch (Exception e) {
            realVal = this.getRuntime().getNil();
        }
        for (String name2 : names2) {
            this.fastSetConstant(name2, realVal);
        }
        return true;
    }

    public void defineAnnotatedMethods(Class clazz) {
        this.defineAnnotatedMethodsIndividually(clazz);
    }

    public void defineAnnotatedMethodsIndividually(Class clazz) {
        TypePopulator populator;
        if (RubyInstanceConfig.FULL_TRACE_ENABLED || RubyInstanceConfig.REFLECTED_HANDLES) {
            populator = TypePopulator.DEFAULT;
        } else {
            try {
                String qualifiedName = "org.jruby.gen." + clazz.getCanonicalName().replace('.', '$');
                Class<?> populatorClass = Class.forName(qualifiedName + "$Populator");
                populator = (TypePopulator)populatorClass.newInstance();
            }
            catch (Throwable t) {
                populator = TypePopulator.DEFAULT;
            }
        }
        populator.populate(this, clazz);
    }

    public boolean defineAnnotatedMethod(String name2, List<JavaMethodDescriptor> methods2, MethodFactory methodFactory) {
        JavaMethodDescriptor desc = methods2.get(0);
        if (methods2.size() == 1) {
            return this.defineAnnotatedMethod(desc, methodFactory);
        }
        DynamicMethod dynamicMethod = methodFactory.getAnnotatedMethod(this, methods2);
        RubyModule.define(this, desc, dynamicMethod);
        return true;
    }

    public boolean defineAnnotatedMethod(Method method2, MethodFactory methodFactory) {
        JRubyMethod jrubyMethod = method2.getAnnotation(JRubyMethod.class);
        if (jrubyMethod == null) {
            return false;
        }
        if (jrubyMethod.compat() == CompatVersion.BOTH || this.getRuntime().getInstanceConfig().getCompatVersion() == jrubyMethod.compat()) {
            JavaMethodDescriptor desc = new JavaMethodDescriptor(method2);
            DynamicMethod dynamicMethod = methodFactory.getAnnotatedMethod(this, desc);
            RubyModule.define(this, desc, dynamicMethod);
            return true;
        }
        return false;
    }

    public boolean defineAnnotatedMethod(JavaMethodDescriptor desc, MethodFactory methodFactory) {
        JRubyMethod jrubyMethod = desc.anno;
        if (jrubyMethod == null) {
            return false;
        }
        if (jrubyMethod.compat() == CompatVersion.BOTH || this.getRuntime().getInstanceConfig().getCompatVersion() == jrubyMethod.compat()) {
            DynamicMethod dynamicMethod = methodFactory.getAnnotatedMethod(this, desc);
            RubyModule.define(this, desc, dynamicMethod);
            return true;
        }
        return false;
    }

    public void defineFastMethod(String name2, Callback method2) {
        Visibility visibility = name2.equals("initialize") ? Visibility.PRIVATE : Visibility.PUBLIC;
        this.addMethod(name2, new SimpleCallbackMethod(this, method2, visibility));
    }

    public void defineFastMethod(String name2, Callback method2, Visibility visibility) {
        this.addMethod(name2, new SimpleCallbackMethod(this, method2, visibility));
    }

    public void definePrivateMethod(String name2, Callback method2) {
        this.addMethod(name2, new FullFunctionCallbackMethod(this, method2, Visibility.PRIVATE));
    }

    public void defineFastPrivateMethod(String name2, Callback method2) {
        this.addMethod(name2, new SimpleCallbackMethod(this, method2, Visibility.PRIVATE));
    }

    public void defineFastProtectedMethod(String name2, Callback method2) {
        this.addMethod(name2, new SimpleCallbackMethod(this, method2, Visibility.PROTECTED));
    }

    public void undefineMethod(String name2) {
        this.addMethod(name2, UndefinedMethod.getInstance());
    }

    public void undef(ThreadContext context, String name2) {
        DynamicMethod method2;
        Ruby runtime2 = context.getRuntime();
        if (this == runtime2.getObject()) {
            runtime2.secure(4);
        }
        if (runtime2.getSafeLevel() >= 4 && !this.isTaint()) {
            throw new SecurityException("Insecure: can't undef");
        }
        this.testFrozen("module");
        if (name2.equals("__id__") || name2.equals("__send__")) {
            runtime2.getWarnings().warn(IRubyWarnings.ID.UNDEFINING_BAD, "undefining `" + name2 + "' may cause serious problem");
        }
        if ((method2 = this.searchMethod(name2)).isUndefined()) {
            String s0 = " class";
            RubyModule c = this;
            if (c.isSingleton()) {
                IRubyObject obj = ((MetaClass)c).getAttached();
                if (obj != null && obj instanceof RubyModule) {
                    c = (RubyModule)obj;
                    s0 = "";
                }
            } else if (c.isModule()) {
                s0 = " module";
            }
            throw runtime2.newNameError("Undefined method " + name2 + " for" + s0 + " '" + c.getName() + "'", name2);
        }
        this.addMethod(name2, UndefinedMethod.getInstance());
        if (this.isSingleton()) {
            IRubyObject singleton = ((MetaClass)this).getAttached();
            singleton.callMethod(context, "singleton_method_undefined", runtime2.newSymbol(name2));
        } else {
            this.callMethod(context, "method_undefined", (IRubyObject)runtime2.newSymbol(name2));
        }
    }

    @JRubyMethod(name={"include?"}, required=1)
    public IRubyObject include_p(ThreadContext context, IRubyObject arg2) {
        if (!arg2.isModule()) {
            throw context.getRuntime().newTypeError(arg2, context.getRuntime().getModule());
        }
        RubyModule moduleToCompare = (RubyModule)arg2;
        for (RubyClass p2 = this.getSuperClass(); p2 != null; p2 = p2.getSuperClass()) {
            if (!p2.isSame(moduleToCompare)) continue;
            return context.getRuntime().getTrue();
        }
        return context.getRuntime().getFalse();
    }

    public void addMethod(String name2, DynamicMethod method2) {
        Ruby runtime2 = this.getRuntime();
        if (this == runtime2.getObject()) {
            runtime2.secure(4);
        }
        if (runtime2.getSafeLevel() >= 4 && !this.isTaint()) {
            throw runtime2.newSecurityError("Insecure: can't define method");
        }
        this.testFrozen("class/module");
        this.addMethodInternal(name2, method2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMethodInternal(String name2, DynamicMethod method2) {
        Map<String, DynamicMethod> map = this.getMethodsForWrite();
        synchronized (map) {
            this.addMethodAtBootTimeOnly(name2, method2);
            this.invalidateCoreClasses();
            this.invalidateCacheDescendants();
        }
    }

    public void addMethodAtBootTimeOnly(String name2, DynamicMethod method2) {
        this.getMethodsForWrite().put(name2, method2);
        this.getRuntime().addProfiledMethod(name2, method2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeMethod(ThreadContext context, String name2) {
        Ruby runtime2 = context.getRuntime();
        if (this == runtime2.getObject()) {
            runtime2.secure(4);
        }
        if (runtime2.getSafeLevel() >= 4 && !this.isTaint()) {
            throw runtime2.newSecurityError("Insecure: can't remove method");
        }
        this.testFrozen("class/module");
        Map<String, DynamicMethod> map = this.getMethodsForWrite();
        synchronized (map) {
            DynamicMethod method2 = this.getMethodsForWrite().remove(name2);
            if (method2 == null) {
                throw runtime2.newNameError("method '" + name2 + "' not defined in " + this.getName(), name2);
            }
            this.invalidateCoreClasses();
            this.invalidateCacheDescendants();
        }
        if (this.isSingleton()) {
            IRubyObject singleton = ((MetaClass)this).getAttached();
            singleton.callMethod(context, "singleton_method_removed", runtime2.newSymbol(name2));
        } else {
            this.callMethod(context, "method_removed", (IRubyObject)runtime2.newSymbol(name2));
        }
    }

    public DynamicMethod searchMethod(String name2) {
        return this.searchWithCache((String)name2).method;
    }

    public CacheEntry searchWithCache(String name2) {
        CacheEntry entry = this.cacheHit(name2);
        if (entry != null) {
            return entry;
        }
        int token = this.getCacheToken();
        DynamicMethod method2 = this.searchMethodInner(name2);
        if (method2 instanceof DefaultMethod) {
            method2 = ((DefaultMethod)method2).getMethodForCaching();
        }
        return method2 != null ? this.addToCache(name2, method2, token) : this.addToCache(name2, UndefinedMethod.getInstance(), token);
    }

    public final int getCacheToken() {
        return this.generation;
    }

    private final Map<String, CacheEntry> getCachedMethods() {
        return this.cachedMethods;
    }

    private final Map<String, CacheEntry> getCachedMethodsForWrite() {
        Map<String, CacheEntry> myCachedMethods = this.cachedMethods;
        return myCachedMethods == Collections.EMPTY_MAP ? (this.cachedMethods = new ConcurrentHashMap<String, CacheEntry>(0, 0.75f, 1)) : myCachedMethods;
    }

    private CacheEntry cacheHit(String name2) {
        CacheEntry cacheEntry = this.getCachedMethods().get(name2);
        if (cacheEntry != null && cacheEntry.token == this.getCacheToken()) {
            return cacheEntry;
        }
        return null;
    }

    public void becomeSynchronized() {
        this.cacheEntryFactory = new SynchronizedCacheEntryFactory(this.cacheEntryFactory);
    }

    public boolean isSynchronized() {
        return this.cacheEntryFactory.hasCacheEntryFactory(SynchronizedCacheEntryFactory.class);
    }

    private CacheEntry addToCache(String name2, DynamicMethod method2, int token) {
        CacheEntry entry = this.cacheEntryFactory.newCacheEntry(method2, token);
        this.getCachedMethodsForWrite().put(name2, entry);
        return entry;
    }

    protected DynamicMethod searchMethodInner(String name2) {
        DynamicMethod method2 = this.getMethods().get(name2);
        if (method2 != null) {
            return method2;
        }
        return this.superClass == null ? null : this.superClass.searchMethodInner(name2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invalidateCacheDescendants() {
        this.invalidateCacheDescendantsInner();
        this.cachedMethods.clear();
        Object object = this.getRuntime().getHierarchyLock();
        synchronized (object) {
            for (RubyClass includingHierarchy : this.includingHierarchies) {
                includingHierarchy.invalidateCacheDescendants();
            }
        }
    }

    protected void invalidateCoreClasses() {
        if (!this.getRuntime().isBooting()) {
            if (this == this.getRuntime().getFixnum()) {
                this.getRuntime().setFixnumReopened(true);
            } else if (this == this.getRuntime().getFloat()) {
                this.getRuntime().setFloatReopened(true);
            }
        }
    }

    @Deprecated
    protected void invalidateCacheDescendantsInner() {
        this.generation = this.getRuntime().getNextModuleGeneration();
    }

    protected void invalidateConstantCache() {
        this.getRuntime().incrementConstantGeneration();
    }

    public DynamicMethod retrieveMethod(String name2) {
        return this.getMethods().get(name2);
    }

    public RubyModule findImplementer(RubyModule clazz) {
        for (RubyModule module = this; module != null; module = module.getSuperClass()) {
            if (!module.isSame(clazz)) continue;
            return module;
        }
        return null;
    }

    public void addModuleFunction(String name2, DynamicMethod method2) {
        this.addMethod(name2, method2);
        this.getSingletonClass().addMethod(name2, method2);
    }

    public void defineModuleFunction(String name2, Callback method2) {
        this.definePrivateMethod(name2, method2);
        this.getSingletonClass().defineMethod(name2, method2);
    }

    public void definePublicModuleFunction(String name2, Callback method2) {
        this.defineMethod(name2, method2);
        this.getSingletonClass().defineMethod(name2, method2);
    }

    public void defineFastModuleFunction(String name2, Callback method2) {
        this.defineFastPrivateMethod(name2, method2);
        this.getSingletonClass().defineFastMethod(name2, method2);
    }

    public void defineFastPublicModuleFunction(String name2, Callback method2) {
        this.defineFastMethod(name2, method2);
        this.getSingletonClass().defineFastMethod(name2, method2);
    }

    public synchronized void defineAlias(String name2, String oldName) {
        DynamicMethod method2;
        this.testFrozen("module");
        if (oldName.equals(name2)) {
            return;
        }
        Ruby runtime2 = this.getRuntime();
        if (this == runtime2.getObject()) {
            runtime2.secure(4);
        }
        if (SCOPE_CAPTURING_METHODS.contains(oldName)) {
            runtime2.getWarnings().warn("`" + oldName + "' should not be aliased");
        }
        if ((method2 = this.searchMethod(oldName)).isUndefined()) {
            if (this.isModule()) {
                method2 = runtime2.getObject().searchMethod(oldName);
            }
            if (method2.isUndefined()) {
                throw runtime2.newNameError("undefined method `" + oldName + "' for " + (this.isModule() ? "module" : "class") + " `" + this.getName() + "'", oldName);
            }
        }
        this.invalidateCoreClasses();
        this.invalidateCacheDescendants();
        this.putMethod(name2, new AliasMethod(this, method2, oldName));
    }

    public synchronized void defineAliases(List<String> aliases2, String oldName) {
        DynamicMethod method2;
        this.testFrozen("module");
        Ruby runtime2 = this.getRuntime();
        if (this == runtime2.getObject()) {
            runtime2.secure(4);
        }
        if ((method2 = this.searchMethod(oldName)).isUndefined()) {
            if (this.isModule()) {
                method2 = runtime2.getObject().searchMethod(oldName);
            }
            if (method2.isUndefined()) {
                throw runtime2.newNameError("undefined method `" + oldName + "' for " + (this.isModule() ? "module" : "class") + " `" + this.getName() + "'", oldName);
            }
        }
        for (String name2 : aliases2) {
            if (oldName.equals(name2)) continue;
            this.putMethod(name2, new AliasMethod(this, method2, oldName));
        }
        this.invalidateCoreClasses();
        this.invalidateCacheDescendants();
    }

    public RubyClass defineOrGetClassUnder(String name2, RubyClass superClazz) {
        RubyClass clazz;
        Ruby runtime2 = this.getRuntime();
        IRubyObject classObj = this.getConstantAtSpecial(name2);
        if (classObj != null) {
            if (!(classObj instanceof RubyClass)) {
                throw runtime2.newTypeError(name2 + " is not a class");
            }
            clazz = (RubyClass)classObj;
            if (superClazz != null) {
                RubyClass tmp;
                for (tmp = clazz.getSuperClass(); tmp != null && tmp.isIncluded(); tmp = tmp.getSuperClass()) {
                }
                if (tmp != null) {
                    tmp = tmp.getRealClass();
                }
                if (tmp != superClazz) {
                    throw runtime2.newTypeError("superclass mismatch for class " + name2);
                }
            }
            if (runtime2.getSafeLevel() >= 4) {
                throw runtime2.newTypeError("extending class prohibited");
            }
        } else if (this.classProviders == null || (clazz = this.searchProvidersForClass(name2, superClazz)) == null) {
            if (superClazz == null) {
                superClazz = runtime2.getObject();
            }
            clazz = superClazz == runtime2.getObject() && RubyInstanceConfig.REIFY_RUBY_CLASSES ? RubyClass.newClass(runtime2, superClazz, name2, REIFYING_OBJECT_ALLOCATOR, this, true) : RubyClass.newClass(runtime2, superClazz, name2, superClazz.getAllocator(), this, true);
        }
        return clazz;
    }

    public RubyModule defineOrGetModuleUnder(String name2) {
        RubyModule module;
        Ruby runtime2 = this.getRuntime();
        IRubyObject moduleObj = this.getConstantAtSpecial(name2);
        if (moduleObj != null) {
            if (!moduleObj.isModule()) {
                throw runtime2.newTypeError(name2 + " is not a module");
            }
            if (runtime2.getSafeLevel() >= 4) {
                throw runtime2.newSecurityError("extending module prohibited");
            }
            module = (RubyModule)moduleObj;
        } else if (this.classProviders == null || (module = this.searchProvidersForModule(name2)) == null) {
            module = RubyModule.newModule(runtime2, name2, this, true);
        }
        return module;
    }

    public RubyClass defineClassUnder(String name2, RubyClass superClass, ObjectAllocator allocator) {
        return this.getRuntime().defineClassUnder(name2, superClass, allocator, this);
    }

    public RubyModule defineModuleUnder(String name2) {
        return this.getRuntime().defineModuleUnder(name2, this);
    }

    private void addAccessor(ThreadContext context, String internedName, Visibility visibility, boolean readable, boolean writeable) {
        assert (internedName == internedName.intern()) : internedName + " is not interned";
        final Ruby runtime2 = context.getRuntime();
        if (visibility != Visibility.PRIVATE && visibility == Visibility.MODULE_FUNCTION) {
            visibility = Visibility.PRIVATE;
        }
        final String variableName = ("@" + internedName).intern();
        if (readable) {
            this.addMethod(internedName, new JavaMethod.JavaMethodZero(this, visibility, CallConfiguration.FrameNoneScopeNone){
                private RubyClass.VariableAccessor accessor;
                {
                    super(x0, x1, x2);
                    this.accessor = RubyClass.VariableAccessor.DUMMY_ACCESSOR;
                }

                public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name2) {
                    IRubyObject variable = (IRubyObject)this.verifyAccessor(self.getMetaClass().getRealClass()).get(self);
                    return variable == null ? runtime2.getNil() : variable;
                }

                private RubyClass.VariableAccessor verifyAccessor(RubyClass cls) {
                    RubyClass.VariableAccessor localAccessor = this.accessor;
                    if (localAccessor.getClassId() != cls.id) {
                        this.accessor = localAccessor = cls.getVariableAccessorForRead(variableName);
                    }
                    return localAccessor;
                }
            });
            this.callMethod(context, "method_added", (IRubyObject)runtime2.fastNewSymbol(internedName));
        }
        if (writeable) {
            internedName = (internedName + "=").intern();
            this.addMethod(internedName, new JavaMethod.JavaMethodOne(this, visibility, CallConfiguration.FrameNoneScopeNone){
                private RubyClass.VariableAccessor accessor;
                {
                    super(x0, x1, x2);
                    this.accessor = RubyClass.VariableAccessor.DUMMY_ACCESSOR;
                }

                public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name2, IRubyObject arg1) {
                    this.verifyAccessor(self.getMetaClass().getRealClass()).set(self, arg1);
                    return arg1;
                }

                private RubyClass.VariableAccessor verifyAccessor(RubyClass cls) {
                    RubyClass.VariableAccessor localAccessor = this.accessor;
                    if (localAccessor.getClassId() != cls.id) {
                        this.accessor = localAccessor = cls.getVariableAccessorForWrite(variableName);
                    }
                    return localAccessor;
                }
            });
            this.callMethod(context, "method_added", (IRubyObject)runtime2.fastNewSymbol(internedName));
        }
    }

    public void setMethodVisibility(IRubyObject[] methods2, Visibility visibility) {
        if (this.getRuntime().getSafeLevel() >= 4 && !this.isTaint()) {
            throw this.getRuntime().newSecurityError("Insecure: can't change method visibility");
        }
        for (int i2 = 0; i2 < methods2.length; ++i2) {
            this.exportMethod(methods2[i2].asJavaString(), visibility);
        }
    }

    public void exportMethod(String name2, Visibility visibility) {
        DynamicMethod method2;
        Ruby runtime2 = this.getRuntime();
        if (this == runtime2.getObject()) {
            this.getRuntime().secure(4);
        }
        if ((method2 = this.deepMethodSearch(name2, runtime2)).getVisibility() != visibility) {
            if (this == method2.getImplementationClass()) {
                method2.setVisibility(visibility);
            } else {
                this.addMethod(name2, new WrapperMethod(this, method2, visibility));
            }
            this.invalidateCoreClasses();
            this.invalidateCacheDescendants();
        }
    }

    private DynamicMethod deepMethodSearch(String name2, Ruby runtime2) {
        DynamicMethod method2 = this.searchMethod(name2);
        if (method2.isUndefined() && this.isModule()) {
            method2 = runtime2.getObject().searchMethod(name2);
        }
        if (method2.isUndefined()) {
            throw runtime2.newNameError("undefined method '" + name2 + "' for " + (this.isModule() ? "module" : "class") + " '" + this.getName() + "'", name2);
        }
        return method2;
    }

    public boolean isMethodBound(String name2, boolean checkVisibility) {
        DynamicMethod method2 = this.searchMethod(name2);
        if (!method2.isUndefined()) {
            return !checkVisibility || method2.getVisibility() != Visibility.PRIVATE;
        }
        return false;
    }

    public boolean isMethodBound(String name2, boolean checkVisibility, boolean checkRespondTo) {
        if (!checkRespondTo) {
            return this.isMethodBound(name2, checkVisibility);
        }
        DynamicMethod method2 = this.searchMethod(name2);
        if (!method2.isUndefined() && !method2.isNotImplemented()) {
            return !checkVisibility || method2.getVisibility() != Visibility.PRIVATE;
        }
        return false;
    }

    public void checkMethodBound(ThreadContext context, IRubyObject[] args2, Visibility visibility) {
        if (args2.length == 0) {
            throw context.getRuntime().newArgumentError("no method name given");
        }
        String name2 = args2[0].asJavaString();
        DynamicMethod method2 = this.searchMethod(name2);
        if (!method2.isUndefined() && method2.getVisibility() != visibility) {
            Ruby runtime2 = context.getRuntime();
            RubyNameError.RubyNameErrorMessage message2 = new RubyNameError.RubyNameErrorMessage(runtime2, this, runtime2.newString(name2), method2.getVisibility(), CallType.NORMAL);
            throw runtime2.newNoMethodError(message2.to_str(context).asJavaString(), name2, NEVER);
        }
    }

    public IRubyObject newMethod(IRubyObject receiver2, String methodName, boolean bound, Visibility visibility) {
        return this.newMethod(receiver2, methodName, bound, visibility, false, true);
    }

    public IRubyObject newMethod(IRubyObject receiver2, String methodName, boolean bound, Visibility visibility, boolean respondToMissing) {
        return this.newMethod(receiver2, methodName, bound, visibility, respondToMissing, true);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public IRubyObject newMethod(IRubyObject receiver2, String methodName, boolean bound, Visibility visibility, boolean respondToMissing, boolean priv) {
        DynamicMethod method2 = this.searchMethod(methodName);
        if (method2.isUndefined() || visibility != null && method2.getVisibility() != visibility) {
            if (!respondToMissing) throw this.getRuntime().newNameError("undefined method `" + methodName + "' for class `" + this.getName() + "'", methodName);
            if (!receiver2.respondsToMissing(methodName, priv)) throw this.getRuntime().newNameError("undefined method `" + methodName + "' for class `" + this.getName() + "'", methodName);
            method2 = new RespondToMissingMethod(this, Visibility.PUBLIC, methodName);
        }
        RubyModule implementationModule = method2.getImplementationClass();
        RubyModule originModule = this;
        while (originModule != implementationModule && originModule.isSingleton()) {
            originModule = ((MetaClass)originModule).getRealClass();
        }
        RubyMethod newMethod = bound ? RubyMethod.newMethod(implementationModule, methodName, originModule, methodName, method2, receiver2) : RubyUnboundMethod.newUnboundMethod(implementationModule, methodName, originModule, methodName, method2);
        newMethod.infectBy(this);
        return newMethod;
    }

    @JRubyMethod(name={"define_method"}, visibility=Visibility.PRIVATE, reads={FrameField.VISIBILITY})
    public IRubyObject define_method(ThreadContext context, IRubyObject arg0, Block block) {
        Ruby runtime2 = context.getRuntime();
        String name2 = arg0.asJavaString().intern();
        DynamicMethod newMethod = null;
        Visibility visibility = Visibility.PUBLIC;
        RubyProc proc2 = runtime2.newProc(Block.Type.LAMBDA, block);
        proc2.getBlock().type = Block.Type.LAMBDA;
        newMethod = this.createProcMethod(name2, visibility, proc2);
        RuntimeHelpers.addInstanceMethod(this, name2, newMethod, visibility, context, runtime2);
        return proc2;
    }

    @JRubyMethod(name={"define_method"}, visibility=Visibility.PRIVATE, reads={FrameField.VISIBILITY})
    public IRubyObject define_method(ThreadContext context, IRubyObject arg0, IRubyObject arg1, Block block) {
        RubyObject body;
        Ruby runtime2 = context.getRuntime();
        String name2 = arg0.asJavaString().intern();
        DynamicMethod newMethod = null;
        Visibility visibility = Visibility.PUBLIC;
        if (runtime2.getProc().isInstance(arg1)) {
            RubyProc proc2;
            body = proc2 = (RubyProc)arg1;
            newMethod = this.createProcMethod(name2, visibility, proc2);
        } else if (runtime2.getMethod().isInstance(arg1)) {
            RubyMethod method2 = (RubyMethod)arg1;
            body = method2;
            newMethod = new MethodMethod(this, method2.unbind(), visibility);
        } else {
            throw runtime2.newTypeError("wrong argument type " + arg1.getType().getName() + " (expected Proc/Method)");
        }
        RuntimeHelpers.addInstanceMethod(this, name2, newMethod, visibility, context, runtime2);
        return body;
    }

    @Deprecated
    public IRubyObject define_method(ThreadContext context, IRubyObject[] args2, Block block) {
        switch (args2.length) {
            case 1: {
                return this.define_method(context, args2[0], block);
            }
            case 2: {
                return this.define_method(context, args2[0], args2[1], block);
            }
        }
        throw context.getRuntime().newArgumentError("wrong number of arguments (" + args2.length + " for 2)");
    }

    private DynamicMethod createProcMethod(String name2, Visibility visibility, RubyProc proc2) {
        Block block = proc2.getBlock();
        block.getBinding().getFrame().setKlazz(this);
        block.getBinding().getFrame().setName(name2);
        block.getBinding().setMethod(name2);
        StaticScope scope = block.getBody().getStaticScope();
        scope.makeArgumentScope();
        Arity arity2 = block.arity();
        scope.setRequiredArgs(arity2.required());
        if (!arity2.isFixed()) {
            scope.setRestArg(arity2.required());
        }
        return new ProcMethod(this, proc2, visibility);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public IRubyObject executeUnder(ThreadContext context, Callback method2, IRubyObject[] args2, Block block) {
        context.preExecuteUnder(this, block);
        try {
            IRubyObject iRubyObject = method2.execute(this, args2, block);
            return iRubyObject;
        }
        finally {
            context.postExecuteUnder();
        }
    }

    @JRubyMethod(name={"name"})
    public IRubyObject name() {
        Ruby runtime2 = this.getRuntime();
        if (this.getBaseName() == null) {
            return RubyString.newEmptyString(runtime2);
        }
        return runtime2.newString(this.getName());
    }

    @JRubyMethod(name={"name"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject name19() {
        Ruby runtime2 = this.getRuntime();
        if (this.getBaseName() == null) {
            return runtime2.getNil();
        }
        return runtime2.newString(this.getName());
    }

    protected IRubyObject cloneMethods(RubyModule clone) {
        RubyModule realType = this.getNonIncludedClass();
        for (Map.Entry<String, DynamicMethod> entry : this.getMethods().entrySet()) {
            DynamicMethod method2 = entry.getValue();
            if (method2.getImplementationClass() != realType && !method2.isUndefined()) continue;
            DynamicMethod clonedMethod = method2.dup();
            clonedMethod.setImplementationClass(clone);
            clone.putMethod(entry.getKey(), clonedMethod);
        }
        return clone;
    }

    @Override
    @JRubyMethod(name={"initialize_copy"}, required=1)
    public IRubyObject initialize_copy(IRubyObject original) {
        super.initialize_copy(original);
        RubyModule originalModule = (RubyModule)original;
        if (!this.getMetaClass().isSingleton()) {
            this.setMetaClass(originalModule.getSingletonClassClone());
        }
        this.setSuperClass(originalModule.getSuperClass());
        if (originalModule.hasVariables()) {
            this.syncVariables(originalModule);
        }
        this.syncConstants(originalModule);
        originalModule.cloneMethods(this);
        return this;
    }

    public void syncConstants(RubyModule other) {
        if (other.getConstantMap() != Collections.EMPTY_MAP) {
            this.getConstantMapForWrite().putAll(other.getConstantMap());
        }
    }

    public void syncClassVariables(RubyModule other) {
        if (other.getClassVariablesForRead() != Collections.EMPTY_MAP) {
            this.getClassVariables().putAll(other.getClassVariablesForRead());
        }
    }

    @JRubyMethod(name={"included_modules"})
    public RubyArray included_modules(ThreadContext context) {
        RubyArray ary = context.getRuntime().newArray();
        for (RubyClass p2 = this.getSuperClass(); p2 != null; p2 = p2.getSuperClass()) {
            if (!p2.isIncluded()) continue;
            ary.append(p2.getNonIncludedClass());
        }
        return ary;
    }

    @JRubyMethod(name={"ancestors"})
    public RubyArray ancestors(ThreadContext context) {
        return context.getRuntime().newArray(this.getAncestorList());
    }

    @Deprecated
    public RubyArray ancestors() {
        return this.getRuntime().newArray(this.getAncestorList());
    }

    public List<IRubyObject> getAncestorList() {
        ArrayList<IRubyObject> list2 = new ArrayList<IRubyObject>();
        for (RubyModule module = this; module != null; module = module.getSuperClass()) {
            if (module.isSingleton()) continue;
            list2.add(module.getNonIncludedClass());
        }
        return list2;
    }

    public boolean hasModuleInHierarchy(RubyModule type2) {
        for (RubyModule module = this; module != null; module = module.getSuperClass()) {
            if (module.getNonIncludedClass() != type2) continue;
            return true;
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.id;
    }

    @Override
    @JRubyMethod(name={"hash"})
    public RubyFixnum hash() {
        return this.getRuntime().newFixnum(this.id);
    }

    @Override
    @JRubyMethod(name={"to_s"})
    public IRubyObject to_s() {
        if (this.isSingleton()) {
            IRubyObject attached = ((MetaClass)this).getAttached();
            StringBuilder buffer = new StringBuilder("#<Class:");
            if (attached != null) {
                if (attached instanceof RubyClass || attached instanceof RubyModule) {
                    buffer.append(attached.inspect());
                } else {
                    buffer.append(attached.anyToString());
                }
            }
            buffer.append(">");
            return this.getRuntime().newString(buffer.toString());
        }
        return this.getRuntime().newString(this.getName());
    }

    @Override
    @JRubyMethod(name={"==="}, required=1)
    public RubyBoolean op_eqq(ThreadContext context, IRubyObject obj) {
        return context.getRuntime().newBoolean(this.isInstance(obj));
    }

    @Override
    public boolean equals(Object other) {
        return this == other;
    }

    @Override
    @JRubyMethod(name={"=="}, required=1)
    public IRubyObject op_equal(ThreadContext context, IRubyObject other) {
        return super.op_equal(context, other);
    }

    @Override
    @JRubyMethod(name={"freeze"})
    public final IRubyObject freeze(ThreadContext context) {
        this.to_s();
        return super.freeze(context);
    }

    @JRubyMethod(name={"<="}, required=1)
    public IRubyObject op_le(IRubyObject obj) {
        if (!(obj instanceof RubyModule)) {
            throw this.getRuntime().newTypeError("compared with non class/module");
        }
        if (this.isKindOfModule((RubyModule)obj)) {
            return this.getRuntime().getTrue();
        }
        if (((RubyModule)obj).isKindOfModule(this)) {
            return this.getRuntime().getFalse();
        }
        return this.getRuntime().getNil();
    }

    @JRubyMethod(name={"<"}, required=1)
    public IRubyObject op_lt(IRubyObject obj) {
        return obj == this ? this.getRuntime().getFalse() : this.op_le(obj);
    }

    @JRubyMethod(name={">="}, required=1)
    public IRubyObject op_ge(IRubyObject obj) {
        if (!(obj instanceof RubyModule)) {
            throw this.getRuntime().newTypeError("compared with non class/module");
        }
        return ((RubyModule)obj).op_le(this);
    }

    @JRubyMethod(name={">"}, required=1)
    public IRubyObject op_gt(IRubyObject obj) {
        return this == obj ? this.getRuntime().getFalse() : this.op_ge(obj);
    }

    @JRubyMethod(name={"<=>"}, required=1)
    public IRubyObject op_cmp(IRubyObject obj) {
        if (this == obj) {
            return this.getRuntime().newFixnum(0);
        }
        if (!(obj instanceof RubyModule)) {
            return this.getRuntime().getNil();
        }
        RubyModule module = (RubyModule)obj;
        if (module.isKindOfModule(this)) {
            return this.getRuntime().newFixnum(1);
        }
        if (this.isKindOfModule(module)) {
            return this.getRuntime().newFixnum(-1);
        }
        return this.getRuntime().getNil();
    }

    public boolean isKindOfModule(RubyModule type2) {
        for (RubyModule module = this; module != null; module = module.getSuperClass()) {
            if (!module.isSame(type2)) continue;
            return true;
        }
        return false;
    }

    protected boolean isSame(RubyModule module) {
        return this == module;
    }

    @JRubyMethod(name={"initialize"}, frame=true, visibility=Visibility.PRIVATE)
    public IRubyObject initialize(Block block) {
        if (block.isGiven()) {
            block.getBinding().setVisibility(Visibility.PUBLIC);
            block.yieldNonArray(this.getRuntime().getCurrentContext(), this, this, this);
        }
        return this.getRuntime().getNil();
    }

    @JRubyMethod(name={"initialize"}, frame=true, compat=CompatVersion.RUBY1_9, visibility=Visibility.PRIVATE)
    public IRubyObject initialize19(ThreadContext context, Block block) {
        if (block.isGiven()) {
            block.getBinding().setVisibility(Visibility.PUBLIC);
            this.module_exec(context, new IRubyObject[]{this}, block);
        }
        return this.getRuntime().getNil();
    }

    public void addReadWriteAttribute(ThreadContext context, String name2) {
        this.addAccessor(context, name2.intern(), Visibility.PUBLIC, true, true);
    }

    public void addReadAttribute(ThreadContext context, String name2) {
        this.addAccessor(context, name2.intern(), Visibility.PUBLIC, true, false);
    }

    public void addWriteAttribute(ThreadContext context, String name2) {
        this.addAccessor(context, name2.intern(), Visibility.PUBLIC, false, true);
    }

    @JRubyMethod(name={"attr"}, required=1, optional=1, visibility=Visibility.PRIVATE, reads={FrameField.VISIBILITY}, compat=CompatVersion.RUBY1_8)
    public IRubyObject attr(ThreadContext context, IRubyObject[] args2) {
        boolean writeable = args2.length > 1 ? args2[1].isTrue() : false;
        Visibility visibility = context.getCurrentVisibility();
        this.addAccessor(context, args2[0].asJavaString().intern(), visibility, true, writeable);
        return this.getRuntime().getNil();
    }

    @JRubyMethod(name={"attr"}, rest=true, visibility=Visibility.PRIVATE, reads={FrameField.VISIBILITY}, compat=CompatVersion.RUBY1_9)
    public IRubyObject attr19(ThreadContext context, IRubyObject[] args2) {
        Ruby runtime2 = context.getRuntime();
        if (args2.length == 2 && (args2[1] == runtime2.getTrue() || args2[1] == runtime2.getFalse())) {
            runtime2.getWarnings().warn(IRubyWarnings.ID.OBSOLETE_ARGUMENT, "optional boolean argument is obsoleted");
            this.addAccessor(context, args2[0].asJavaString().intern(), context.getCurrentVisibility(), args2[0].isTrue(), true);
            return runtime2.getNil();
        }
        return this.attr_reader(context, args2);
    }

    @Deprecated
    public IRubyObject attr_reader(IRubyObject[] args2) {
        return this.attr_reader(this.getRuntime().getCurrentContext(), args2);
    }

    @JRubyMethod(name={"attr_reader"}, rest=true, visibility=Visibility.PRIVATE, reads={FrameField.VISIBILITY})
    public IRubyObject attr_reader(ThreadContext context, IRubyObject[] args2) {
        Visibility visibility = context.getCurrentVisibility();
        for (int i2 = 0; i2 < args2.length; ++i2) {
            this.addAccessor(context, args2[i2].asJavaString().intern(), visibility, true, false);
        }
        return context.getRuntime().getNil();
    }

    @JRubyMethod(name={"attr_writer"}, rest=true, visibility=Visibility.PRIVATE, reads={FrameField.VISIBILITY})
    public IRubyObject attr_writer(ThreadContext context, IRubyObject[] args2) {
        Visibility visibility = context.getCurrentVisibility();
        for (int i2 = 0; i2 < args2.length; ++i2) {
            this.addAccessor(context, args2[i2].asJavaString().intern(), visibility, false, true);
        }
        return context.getRuntime().getNil();
    }

    @Deprecated
    public IRubyObject attr_accessor(IRubyObject[] args2) {
        return this.attr_accessor(this.getRuntime().getCurrentContext(), args2);
    }

    @JRubyMethod(name={"attr_accessor"}, rest=true, visibility=Visibility.PRIVATE, reads={FrameField.VISIBILITY})
    public IRubyObject attr_accessor(ThreadContext context, IRubyObject[] args2) {
        Visibility visibility = context.getCurrentVisibility();
        for (int i2 = 0; i2 < args2.length; ++i2) {
            this.addAccessor(context, args2[i2].asJavaString().intern(), visibility, true, true);
        }
        return context.getRuntime().getNil();
    }

    private RubyArray instance_methods(IRubyObject[] args2, Visibility visibility, boolean not, boolean useSymbols) {
        boolean includeSuper = args2.length > 0 ? args2[0].isTrue() : true;
        Ruby runtime2 = this.getRuntime();
        RubyArray ary = runtime2.newArray();
        HashSet<String> seen = new HashSet<String>();
        this.populateInstanceMethodNames(seen, ary, visibility, not, useSymbols, includeSuper);
        return ary;
    }

    public void populateInstanceMethodNames(Set<String> seen, RubyArray ary, Visibility visibility, boolean not, boolean useSymbols, boolean includeSuper) {
        Ruby runtime2 = this.getRuntime();
        for (RubyModule type2 = this; type2 != null; type2 = type2.getSuperClass()) {
            RubyModule realType = type2.getNonIncludedClass();
            for (Map.Entry<String, DynamicMethod> entry : type2.getMethods().entrySet()) {
                String methodName = entry.getKey();
                if (seen.contains(methodName)) continue;
                seen.add(methodName);
                DynamicMethod method2 = entry.getValue();
                if (method2.getImplementationClass() != realType || (not || method2.getVisibility() != visibility) && (!not || method2.getVisibility() == visibility) || method2.isUndefined()) continue;
                ary.append(useSymbols ? runtime2.newSymbol(methodName) : runtime2.newString(methodName));
            }
            if (!includeSuper) break;
        }
    }

    @JRubyMethod(name={"instance_methods"}, optional=1, compat=CompatVersion.RUBY1_8)
    public RubyArray instance_methods(IRubyObject[] args2) {
        return this.instance_methods(args2, Visibility.PRIVATE, true, false);
    }

    @JRubyMethod(name={"instance_methods"}, optional=1, compat=CompatVersion.RUBY1_9)
    public RubyArray instance_methods19(IRubyObject[] args2) {
        return this.instance_methods(args2, Visibility.PRIVATE, true, true);
    }

    @JRubyMethod(name={"public_instance_methods"}, optional=1, compat=CompatVersion.RUBY1_8)
    public RubyArray public_instance_methods(IRubyObject[] args2) {
        return this.instance_methods(args2, Visibility.PUBLIC, false, false);
    }

    @JRubyMethod(name={"public_instance_methods"}, optional=1, compat=CompatVersion.RUBY1_9)
    public RubyArray public_instance_methods19(IRubyObject[] args2) {
        return this.instance_methods(args2, Visibility.PUBLIC, false, true);
    }

    @JRubyMethod(name={"instance_method"}, required=1)
    public IRubyObject instance_method(IRubyObject symbol) {
        return this.newMethod(null, symbol.asJavaString(), false, null);
    }

    @JRubyMethod(name={"protected_instance_methods"}, optional=1, compat=CompatVersion.RUBY1_8)
    public RubyArray protected_instance_methods(IRubyObject[] args2) {
        return this.instance_methods(args2, Visibility.PROTECTED, false, false);
    }

    @JRubyMethod(name={"protected_instance_methods"}, optional=1, compat=CompatVersion.RUBY1_9)
    public RubyArray protected_instance_methods19(IRubyObject[] args2) {
        return this.instance_methods(args2, Visibility.PROTECTED, false, true);
    }

    @JRubyMethod(name={"private_instance_methods"}, optional=1, compat=CompatVersion.RUBY1_8)
    public RubyArray private_instance_methods(IRubyObject[] args2) {
        return this.instance_methods(args2, Visibility.PRIVATE, false, false);
    }

    @JRubyMethod(name={"private_instance_methods"}, optional=1, compat=CompatVersion.RUBY1_9)
    public RubyArray private_instance_methods19(IRubyObject[] args2) {
        return this.instance_methods(args2, Visibility.PRIVATE, false, true);
    }

    @JRubyMethod(name={"append_features"}, required=1, visibility=Visibility.PRIVATE)
    public RubyModule append_features(IRubyObject module) {
        if (!(module instanceof RubyModule)) {
            throw this.getRuntime().newTypeError(module, this.getRuntime().getClassClass());
        }
        ((RubyModule)module).includeModule(this);
        return this;
    }

    @JRubyMethod(name={"extend_object"}, required=1, visibility=Visibility.PRIVATE)
    public IRubyObject extend_object(IRubyObject obj) {
        obj.getSingletonClass().includeModule(this);
        return obj;
    }

    @JRubyMethod(name={"include"}, rest=true, visibility=Visibility.PRIVATE)
    public RubyModule include(IRubyObject[] modules) {
        ThreadContext context = this.getRuntime().getCurrentContext();
        int i2 = modules.length;
        while (--i2 >= 0) {
            IRubyObject obj = modules[i2];
            if (obj.isModule()) continue;
            throw context.getRuntime().newTypeError(obj, context.getRuntime().getModule());
        }
        for (i2 = modules.length - 1; i2 >= 0; --i2) {
            modules[i2].callMethod(context, "append_features", this);
            modules[i2].callMethod(context, "included", this);
        }
        return this;
    }

    @JRubyMethod(name={"included"}, required=1, visibility=Visibility.PRIVATE)
    public IRubyObject included(ThreadContext context, IRubyObject other) {
        return context.getRuntime().getNil();
    }

    @JRubyMethod(name={"extended"}, required=1, frame=true, visibility=Visibility.PRIVATE)
    public IRubyObject extended(ThreadContext context, IRubyObject other, Block block) {
        return context.getRuntime().getNil();
    }

    private void setVisibility(ThreadContext context, IRubyObject[] args2, Visibility visibility) {
        if (context.getRuntime().getSafeLevel() >= 4 && !this.isTaint()) {
            throw context.getRuntime().newSecurityError("Insecure: can't change method visibility");
        }
        if (args2.length == 0) {
            context.setCurrentVisibility(visibility);
        } else {
            this.setMethodVisibility(args2, visibility);
        }
    }

    @JRubyMethod(name={"public"}, rest=true, visibility=Visibility.PRIVATE, writes={FrameField.VISIBILITY})
    public RubyModule rbPublic(ThreadContext context, IRubyObject[] args2) {
        this.setVisibility(context, args2, Visibility.PUBLIC);
        return this;
    }

    @JRubyMethod(name={"protected"}, rest=true, visibility=Visibility.PRIVATE, writes={FrameField.VISIBILITY})
    public RubyModule rbProtected(ThreadContext context, IRubyObject[] args2) {
        this.setVisibility(context, args2, Visibility.PROTECTED);
        return this;
    }

    @JRubyMethod(name={"private"}, rest=true, visibility=Visibility.PRIVATE, writes={FrameField.VISIBILITY})
    public RubyModule rbPrivate(ThreadContext context, IRubyObject[] args2) {
        this.setVisibility(context, args2, Visibility.PRIVATE);
        return this;
    }

    @JRubyMethod(name={"module_function"}, rest=true, visibility=Visibility.PRIVATE, writes={FrameField.VISIBILITY})
    public RubyModule module_function(ThreadContext context, IRubyObject[] args2) {
        Ruby runtime2 = context.getRuntime();
        if (runtime2.getSafeLevel() >= 4 && !this.isTaint()) {
            throw runtime2.newSecurityError("Insecure: can't change method visibility");
        }
        if (args2.length == 0) {
            context.setCurrentVisibility(Visibility.MODULE_FUNCTION);
        } else {
            this.setMethodVisibility(args2, Visibility.PRIVATE);
            for (int i2 = 0; i2 < args2.length; ++i2) {
                String name2 = args2[i2].asJavaString().intern();
                DynamicMethod method2 = this.deepMethodSearch(name2, runtime2);
                this.getSingletonClass().addMethod(name2, new WrapperMethod((RubyModule)this.getSingletonClass(), method2, Visibility.PUBLIC));
                this.callMethod(context, "singleton_method_added", (IRubyObject)context.getRuntime().fastNewSymbol(name2));
            }
        }
        return this;
    }

    @JRubyMethod(name={"method_added"}, required=1, visibility=Visibility.PRIVATE)
    public IRubyObject method_added(ThreadContext context, IRubyObject nothing) {
        return context.getRuntime().getNil();
    }

    @JRubyMethod(name={"method_removed"}, required=1, visibility=Visibility.PRIVATE)
    public IRubyObject method_removed(ThreadContext context, IRubyObject nothing) {
        return context.getRuntime().getNil();
    }

    @JRubyMethod(name={"method_undefined"}, required=1, visibility=Visibility.PRIVATE)
    public IRubyObject method_undefined(ThreadContext context, IRubyObject nothing) {
        return context.getRuntime().getNil();
    }

    @JRubyMethod(name={"method_defined?"}, required=1)
    public RubyBoolean method_defined_p(ThreadContext context, IRubyObject symbol) {
        return this.isMethodBound(symbol.asJavaString(), true) ? context.getRuntime().getTrue() : context.getRuntime().getFalse();
    }

    @JRubyMethod(name={"public_method_defined?"}, required=1)
    public IRubyObject public_method_defined(ThreadContext context, IRubyObject symbol) {
        DynamicMethod method2 = this.searchMethod(symbol.asJavaString());
        return context.getRuntime().newBoolean(!method2.isUndefined() && method2.getVisibility() == Visibility.PUBLIC);
    }

    @JRubyMethod(name={"protected_method_defined?"}, required=1)
    public IRubyObject protected_method_defined(ThreadContext context, IRubyObject symbol) {
        DynamicMethod method2 = this.searchMethod(symbol.asJavaString());
        return context.getRuntime().newBoolean(!method2.isUndefined() && method2.getVisibility() == Visibility.PROTECTED);
    }

    @JRubyMethod(name={"private_method_defined?"}, required=1)
    public IRubyObject private_method_defined(ThreadContext context, IRubyObject symbol) {
        DynamicMethod method2 = this.searchMethod(symbol.asJavaString());
        return context.getRuntime().newBoolean(!method2.isUndefined() && method2.getVisibility() == Visibility.PRIVATE);
    }

    @JRubyMethod(name={"public_class_method"}, rest=true)
    public RubyModule public_class_method(IRubyObject[] args2) {
        this.getMetaClass().setMethodVisibility(args2, Visibility.PUBLIC);
        return this;
    }

    @JRubyMethod(name={"private_class_method"}, rest=true)
    public RubyModule private_class_method(IRubyObject[] args2) {
        this.getMetaClass().setMethodVisibility(args2, Visibility.PRIVATE);
        return this;
    }

    @JRubyMethod(name={"alias_method"}, required=2, visibility=Visibility.PRIVATE)
    public RubyModule alias_method(ThreadContext context, IRubyObject newId, IRubyObject oldId) {
        RubySymbol newSym;
        String newName = newId.asJavaString();
        this.defineAlias(newName, oldId.asJavaString());
        RubySymbol rubySymbol = newSym = newId instanceof RubySymbol ? (RubySymbol)newId : context.getRuntime().newSymbol(newName);
        if (this.isSingleton()) {
            ((MetaClass)this).getAttached().callMethod(context, "singleton_method_added", newSym);
        } else {
            this.callMethod(context, "method_added", (IRubyObject)newSym);
        }
        return this;
    }

    @JRubyMethod(name={"undef_method"}, required=1, rest=true, visibility=Visibility.PRIVATE)
    public RubyModule undef_method(ThreadContext context, IRubyObject[] args2) {
        for (int i2 = 0; i2 < args2.length; ++i2) {
            this.undef(context, args2[i2].asJavaString());
        }
        return this;
    }

    @JRubyMethod(name={"module_eval", "class_eval"}, frame=true)
    public IRubyObject module_eval(ThreadContext context, Block block) {
        return this.specificEval(context, this, block);
    }

    @JRubyMethod(name={"module_eval", "class_eval"}, frame=true)
    public IRubyObject module_eval(ThreadContext context, IRubyObject arg0, Block block) {
        return this.specificEval(context, this, arg0, block);
    }

    @JRubyMethod(name={"module_eval", "class_eval"}, frame=true)
    public IRubyObject module_eval(ThreadContext context, IRubyObject arg0, IRubyObject arg1, Block block) {
        return this.specificEval(context, this, arg0, arg1, block);
    }

    @JRubyMethod(name={"module_eval", "class_eval"}, frame=true)
    public IRubyObject module_eval(ThreadContext context, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2, Block block) {
        return this.specificEval(context, this, arg0, arg1, arg2, block);
    }

    @Deprecated
    public IRubyObject module_eval(ThreadContext context, IRubyObject[] args2, Block block) {
        return this.specificEval(context, this, args2, block);
    }

    @JRubyMethod(name={"module_exec", "class_exec"}, frame=true)
    public IRubyObject module_exec(ThreadContext context, Block block) {
        if (block.isGiven()) {
            return this.yieldUnder(context, this, IRubyObject.NULL_ARRAY, block);
        }
        throw context.getRuntime().newLocalJumpErrorNoBlock();
    }

    @JRubyMethod(name={"module_exec", "class_exec"}, rest=true, frame=true)
    public IRubyObject module_exec(ThreadContext context, IRubyObject[] args2, Block block) {
        if (block.isGiven()) {
            return this.yieldUnder(context, this, args2, block);
        }
        throw context.getRuntime().newLocalJumpErrorNoBlock();
    }

    @JRubyMethod(name={"remove_method"}, required=1, rest=true, visibility=Visibility.PRIVATE)
    public RubyModule remove_method(ThreadContext context, IRubyObject[] args2) {
        for (int i2 = 0; i2 < args2.length; ++i2) {
            this.removeMethod(context, args2[i2].asJavaString());
        }
        return this;
    }

    public static void marshalTo(RubyModule module, MarshalStream output) throws IOException {
        output.registerLinkTarget(module);
        output.writeString(MarshalStream.getPathFromClass(module));
    }

    public static RubyModule unmarshalFrom(UnmarshalStream input) throws IOException {
        String name2 = RubyString.byteListToString(input.unmarshalString());
        RubyModule result2 = UnmarshalStream.getModuleFromPath(input.getRuntime(), name2);
        input.registerLinkTarget(result2);
        return result2;
    }

    @JRubyMethod(name={"nesting"}, frame=true, meta=true)
    public static RubyArray nesting(ThreadContext context, IRubyObject recv2, Block block) {
        Ruby runtime2 = context.getRuntime();
        RubyClass object = runtime2.getObject();
        StaticScope scope = context.getCurrentScope().getStaticScope();
        RubyArray result2 = runtime2.newArray();
        StaticScope current2 = scope;
        while (current2.getModule() != object) {
            result2.append(current2.getModule());
            current2 = current2.getPreviousCRefScope();
        }
        return result2;
    }

    private void doIncludeModule(RubyModule baseModule) {
        List<RubyModule> modulesToInclude = this.gatherModules(baseModule);
        RubyModule currentInclusionPoint = this;
        block0: for (RubyModule nextModule : modulesToInclude) {
            this.checkForCyclicInclude(nextModule);
            boolean superclassSeen = false;
            for (RubyClass nextClass = this.getSuperClass(); nextClass != null; nextClass = nextClass.getSuperClass()) {
                if (this.doesTheClassWrapTheModule(nextClass, nextModule)) {
                    if (superclassSeen) continue block0;
                    currentInclusionPoint = nextClass;
                    continue block0;
                }
                superclassSeen = true;
            }
            currentInclusionPoint = this.proceedWithInclude(currentInclusionPoint, nextModule);
        }
    }

    private boolean doesTheClassWrapTheModule(RubyClass theClass, RubyModule theModule) {
        return theClass.isIncluded() && theClass.getNonIncludedClass() == theModule.getNonIncludedClass();
    }

    private List<RubyModule> gatherModules(RubyModule baseModule) {
        ArrayList<RubyModule> modulesToInclude = new ArrayList<RubyModule>();
        while (baseModule != null) {
            modulesToInclude.add(baseModule);
            baseModule = baseModule.getSuperClass();
        }
        return modulesToInclude;
    }

    private RubyModule proceedWithInclude(RubyModule insertAbove, RubyModule moduleToInclude) {
        IncludedModuleWrapper wrapper = new IncludedModuleWrapper(this.getRuntime(), insertAbove.getSuperClass(), moduleToInclude.getNonIncludedClass());
        if (insertAbove instanceof RubyClass) {
            RubyClass insertAboveClass = (RubyClass)insertAbove;
            if (insertAboveClass.getSuperClass() != null) {
                insertAboveClass.getSuperClass().replaceSubclass(insertAboveClass, wrapper);
            }
            wrapper.addSubclass(insertAboveClass);
        }
        insertAbove.setSuperClass(wrapper);
        insertAbove = insertAbove.getSuperClass();
        return insertAbove;
    }

    @JRubyMethod(name={"class_variable_defined?"}, required=1)
    public IRubyObject class_variable_defined_p(ThreadContext context, IRubyObject var) {
        String internedName = this.validateClassVariable(var.asJavaString().intern());
        RubyModule module = this;
        do {
            if (!module.fastHasClassVariable(internedName)) continue;
            return context.getRuntime().getTrue();
        } while ((module = module.getSuperClass()) != null);
        return context.getRuntime().getFalse();
    }

    @JRubyMethod(name={"class_variable_get"}, visibility=Visibility.PRIVATE, compat=CompatVersion.RUBY1_8)
    public IRubyObject class_variable_get(IRubyObject var) {
        return this.fastGetClassVar(this.validateClassVariable(var.asJavaString()).intern());
    }

    @JRubyMethod(name={"class_variable_get"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject class_variable_get19(IRubyObject var) {
        return this.class_variable_get(var);
    }

    @JRubyMethod(name={"class_variable_set"}, visibility=Visibility.PRIVATE, compat=CompatVersion.RUBY1_8)
    public IRubyObject class_variable_set(IRubyObject var, IRubyObject value2) {
        return this.fastSetClassVar(this.validateClassVariable(var.asJavaString()).intern(), value2);
    }

    @JRubyMethod(name={"class_variable_set"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject class_variable_set19(IRubyObject var, IRubyObject value2) {
        return this.class_variable_set(var, value2);
    }

    @JRubyMethod(name={"remove_class_variable"}, visibility=Visibility.PRIVATE, compat=CompatVersion.RUBY1_8)
    public IRubyObject remove_class_variable(ThreadContext context, IRubyObject name2) {
        return this.removeClassVariable(name2.asJavaString());
    }

    @JRubyMethod(name={"remove_class_variable"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject remove_class_variable19(ThreadContext context, IRubyObject name2) {
        return this.remove_class_variable(context, name2);
    }

    @JRubyMethod(name={"class_variables"}, compat=CompatVersion.RUBY1_8)
    public RubyArray class_variables(ThreadContext context) {
        Ruby runtime2 = context.getRuntime();
        RubyArray ary = runtime2.newArray();
        Collection<String> names2 = this.classVariablesCommon();
        ary.addAll(names2);
        return ary;
    }

    @JRubyMethod(name={"class_variables"}, compat=CompatVersion.RUBY1_9)
    public RubyArray class_variables19(ThreadContext context) {
        Ruby runtime2 = context.getRuntime();
        RubyArray ary = runtime2.newArray();
        Collection<String> names2 = this.classVariablesCommon();
        for (String name2 : names2) {
            ary.add(runtime2.newSymbol(name2));
        }
        return ary;
    }

    private Collection<String> classVariablesCommon() {
        HashSet<String> names2 = new HashSet<String>();
        for (RubyModule p2 = this; p2 != null; p2 = p2.getSuperClass()) {
            names2.addAll(p2.getClassVariableNameList());
        }
        return names2;
    }

    @JRubyMethod(name={"const_defined?"}, required=1, compat=CompatVersion.RUBY1_8)
    public RubyBoolean const_defined_p(ThreadContext context, IRubyObject symbol) {
        return context.getRuntime().newBoolean(this.fastIsConstantDefined(this.validateConstant(symbol.asJavaString()).intern()));
    }

    @JRubyMethod(name={"const_defined?"}, required=1, optional=1, compat=CompatVersion.RUBY1_9)
    public RubyBoolean const_defined_p19(ThreadContext context, IRubyObject[] args2) {
        IRubyObject symbol = args2[0];
        boolean inherit = args2.length == 1 || !args2[1].isNil() && args2[1].isTrue();
        return context.getRuntime().newBoolean(this.fastIsConstantDefined19(this.validateConstant(symbol.asJavaString()).intern(), inherit));
    }

    @JRubyMethod(name={"const_get"}, required=1, compat=CompatVersion.RUBY1_8)
    public IRubyObject const_get(IRubyObject symbol) {
        return this.getConstant(this.validateConstant(symbol.asJavaString()));
    }

    @JRubyMethod(name={"const_get"}, required=1, optional=1, compat=CompatVersion.RUBY1_9)
    public IRubyObject const_get(ThreadContext context, IRubyObject[] args2) {
        IRubyObject symbol = args2[0];
        boolean inherit = args2.length == 1 || !args2[1].isNil() && args2[1].isTrue();
        return this.getConstant(this.validateConstant(symbol.asJavaString()), inherit, inherit);
    }

    @JRubyMethod(name={"const_set"}, required=2)
    public IRubyObject const_set(IRubyObject symbol, IRubyObject value2) {
        IRubyObject constant = this.setConstant(this.validateConstant(symbol.asJavaString()).intern(), value2);
        if (constant instanceof RubyModule) {
            ((RubyModule)constant).calculateName();
        }
        return constant;
    }

    @JRubyMethod(name={"remove_const"}, required=1, visibility=Visibility.PRIVATE)
    public IRubyObject remove_const(ThreadContext context, IRubyObject rubyName) {
        String name2 = this.validateConstant(rubyName.asJavaString());
        IRubyObject value2 = this.deleteConstant(name2);
        if (value2 != null) {
            this.invalidateConstantCache();
            if (value2 != UNDEF) {
                return value2;
            }
            this.removeAutoload(name2);
            return context.getRuntime().getNil();
        }
        if (this.hasConstantInHierarchy(name2)) {
            throw this.cannotRemoveError(name2);
        }
        throw context.getRuntime().newNameError("constant " + name2 + " not defined for " + this.getName(), name2);
    }

    private boolean hasConstantInHierarchy(String name2) {
        for (RubyModule p2 = this; p2 != null; p2 = p2.getSuperClass()) {
            if (!p2.hasConstant(name2)) continue;
            return true;
        }
        return false;
    }

    @JRubyMethod(name={"const_missing"}, required=1, frame=true)
    public IRubyObject const_missing(ThreadContext context, IRubyObject rubyName, Block block) {
        Ruby runtime2 = context.getRuntime();
        String name2 = this != runtime2.getObject() ? this.getName() + "::" + rubyName.asJavaString() : rubyName.asJavaString();
        throw runtime2.newNameError("uninitialized constant " + name2, name2);
    }

    @JRubyMethod(name={"constants"}, compat=CompatVersion.RUBY1_8)
    public RubyArray constants(ThreadContext context) {
        Ruby runtime2 = context.getRuntime();
        RubyArray array = runtime2.newArray();
        Collection<String> constantNames = this.constantsCommon(runtime2, true, true);
        array.addAll(constantNames);
        return array;
    }

    @JRubyMethod(name={"constants"}, compat=CompatVersion.RUBY1_9)
    public RubyArray constants19(ThreadContext context) {
        return this.constantsCommon19(context, true, true);
    }

    @JRubyMethod(name={"constants"}, compat=CompatVersion.RUBY1_9)
    public RubyArray constants19(ThreadContext context, IRubyObject allConstants) {
        return this.constantsCommon19(context, false, allConstants.isTrue());
    }

    public RubyArray constantsCommon19(ThreadContext context, boolean replaceModule, boolean allConstants) {
        Ruby runtime2 = context.getRuntime();
        RubyArray array = runtime2.newArray();
        Collection<String> constantNames = this.constantsCommon(runtime2, replaceModule, allConstants);
        for (String name2 : constantNames) {
            array.add(runtime2.newSymbol(name2));
        }
        return array;
    }

    public Collection<String> constantsCommon(Ruby runtime2, boolean replaceModule, boolean allConstants) {
        RubyClass objectClass = runtime2.getObject();
        Collection<Object> constantNames = new HashSet();
        if (allConstants) {
            if (replaceModule && runtime2.getModule() == this || objectClass == this) {
                constantNames = objectClass.getConstantNames();
            } else {
                HashSet<String> names2 = new HashSet<String>();
                for (RubyModule module = this; module != null && module != objectClass; module = module.getSuperClass()) {
                    names2.addAll(module.getConstantNames());
                }
                constantNames = names2;
            }
        } else {
            constantNames = replaceModule && runtime2.getModule() == this || objectClass == this ? objectClass.getConstantNames() : this.getConstantNames();
        }
        return constantNames;
    }

    public IRubyObject setClassVar(String name2, IRubyObject value2) {
        RubyModule module = this;
        do {
            if (!module.hasClassVariable(name2)) continue;
            return module.storeClassVariable(name2, value2);
        } while ((module = module.getSuperClass()) != null);
        return this.storeClassVariable(name2, value2);
    }

    public IRubyObject fastSetClassVar(String internedName, IRubyObject value2) {
        assert (internedName == internedName.intern()) : internedName + " is not interned";
        RubyModule module = this;
        do {
            if (!module.fastHasClassVariable(internedName)) continue;
            return module.fastStoreClassVariable(internedName, value2);
        } while ((module = module.getSuperClass()) != null);
        return this.fastStoreClassVariable(internedName, value2);
    }

    public IRubyObject getClassVar(String name2) {
        assert (IdUtil.isClassVariable(name2));
        RubyModule module = this;
        do {
            IRubyObject value2;
            if ((value2 = module.fetchClassVariable(name2)) == null) continue;
            return value2;
        } while ((module = module.getSuperClass()) != null);
        throw this.getRuntime().newNameError("uninitialized class variable " + name2 + " in " + this.getName(), name2);
    }

    public IRubyObject fastGetClassVar(String internedName) {
        assert (internedName == internedName.intern()) : internedName + " is not interned";
        assert (IdUtil.isClassVariable(internedName));
        RubyModule module = this;
        do {
            IRubyObject value2;
            if ((value2 = module.fetchClassVariable(internedName)) == null) continue;
            return value2;
        } while ((module = module.getSuperClass()) != null);
        throw this.getRuntime().newNameError("uninitialized class variable " + internedName + " in " + this.getName(), internedName);
    }

    public boolean isClassVarDefined(String name2) {
        RubyModule module = this;
        do {
            if (!module.hasClassVariable(name2)) continue;
            return true;
        } while ((module = module.getSuperClass()) != null);
        return false;
    }

    public boolean fastIsClassVarDefined(String internedName) {
        assert (internedName == internedName.intern()) : internedName + " is not interned";
        RubyModule module = this;
        do {
            if (!module.fastHasClassVariable(internedName)) continue;
            return true;
        } while ((module = module.getSuperClass()) != null);
        return false;
    }

    @Deprecated
    public IRubyObject removeCvar(IRubyObject name2) {
        return this.removeClassVariable(name2.asJavaString());
    }

    public IRubyObject removeClassVariable(String name2) {
        String javaName = this.validateClassVariable(name2);
        IRubyObject value2 = this.deleteClassVariable(javaName);
        if (value2 != null) {
            return value2;
        }
        if (this.fastIsClassVarDefined(javaName)) {
            throw this.cannotRemoveError(javaName);
        }
        throw this.getRuntime().newNameError("class variable " + javaName + " not defined for " + this.getName(), javaName);
    }

    public IRubyObject getConstantAtSpecial(String name2) {
        IRubyObject value2 = this == this.getRuntime().getObject() ? this.getConstantNoConstMissing(name2) : this.fetchConstant(name2);
        return value2 == UNDEF ? this.resolveUndefConstant(this.getRuntime(), name2) : value2;
    }

    public IRubyObject getConstantAt(String name2) {
        IRubyObject value2 = this.fetchConstant(name2);
        return value2 == UNDEF ? this.resolveUndefConstant(this.getRuntime(), name2) : value2;
    }

    public IRubyObject fastGetConstantAt(String internedName) {
        assert (internedName == internedName.intern()) : internedName + " is not interned";
        IRubyObject value2 = this.fastFetchConstant(internedName);
        return value2 == UNDEF ? this.resolveUndefConstant(this.getRuntime(), internedName) : value2;
    }

    public IRubyObject getConstant(String name2) {
        return this.getConstant(name2, true);
    }

    public IRubyObject getConstant(String name2, boolean inherit) {
        return this.getConstant(name2.intern(), inherit, true);
    }

    public IRubyObject getConstant(String name2, boolean inherit, boolean includeObject) {
        IRubyObject value2 = this.getConstantNoConstMissing(name2, inherit, includeObject);
        Ruby runtime2 = this.getRuntime();
        return value2 == null ? this.callMethod(runtime2.getCurrentContext(), "const_missing", (IRubyObject)runtime2.fastNewSymbol(name2)) : value2;
    }

    public IRubyObject fastGetConstant(String internedName) {
        return this.fastGetConstant(internedName, true);
    }

    public IRubyObject fastGetConstant(String internedName, boolean inherit) {
        IRubyObject value2 = this.getConstantNoConstMissing(internedName, inherit);
        Ruby runtime2 = this.getRuntime();
        return value2 == null ? this.callMethod(runtime2.getCurrentContext(), "const_missing", (IRubyObject)runtime2.fastNewSymbol(internedName)) : value2;
    }

    public IRubyObject getConstantNoConstMissing(String name2) {
        return this.getConstantNoConstMissing(name2, true);
    }

    public IRubyObject getConstantNoConstMissing(String name2, boolean inherit) {
        return this.getConstantNoConstMissing(name2, inherit, true);
    }

    public IRubyObject getConstantNoConstMissing(String name2, boolean inherit, boolean includeObject) {
        assert (IdUtil.isConstant(name2));
        IRubyObject constant = this.iterateConstantNoConstMissing(name2, this, inherit);
        if (constant == null && !this.isClass() && includeObject) {
            constant = this.iterateConstantNoConstMissing(name2, this.getRuntime().getObject(), inherit);
        }
        return constant;
    }

    private IRubyObject iterateConstantNoConstMissing(String name2, RubyModule init, boolean inherit) {
        for (RubyModule p2 = init; p2 != null; p2 = p2.getSuperClass()) {
            IRubyObject value2 = p2.getConstantAt(name2);
            if (value2 != null) {
                return value2 == UNDEF ? null : value2;
            }
            if (!inherit) break;
        }
        return null;
    }

    public IRubyObject getConstantFrom(String name2) {
        return this.fastGetConstantFrom(name2.intern());
    }

    public IRubyObject fastGetConstantFrom(String internedName) {
        IRubyObject value2 = this.fastGetConstantFromNoConstMissing(internedName);
        return value2 != null ? value2 : this.fastGetConstantFromConstMissing(internedName);
    }

    public IRubyObject fastGetConstantFromNoConstMissing(String internedName) {
        assert (internedName == internedName.intern()) : internedName + " is not interned";
        assert (IdUtil.isConstant(internedName));
        Ruby runtime2 = this.getRuntime();
        RubyClass objectClass = runtime2.getObject();
        for (RubyModule p2 = this; p2 != null; p2 = p2.getSuperClass()) {
            IRubyObject value2 = p2.constantTableFastFetch(internedName);
            if (value2 == null) continue;
            if (value2 == UNDEF) {
                return p2.resolveUndefConstant(runtime2, internedName);
            }
            if (p2 == objectClass && this != objectClass) {
                String badCName = this.getName() + "::" + internedName;
                runtime2.getWarnings().warn(IRubyWarnings.ID.CONSTANT_BAD_REFERENCE, "toplevel constant " + internedName + " referenced by " + badCName);
            }
            return value2;
        }
        return null;
    }

    public IRubyObject fastGetConstantFromConstMissing(String internedName) {
        assert (internedName == internedName.intern()) : internedName + " is not interned";
        assert (IdUtil.isConstant(internedName));
        return this.callMethod(this.getRuntime().getCurrentContext(), "const_missing", (IRubyObject)this.getRuntime().fastNewSymbol(internedName));
    }

    public IRubyObject resolveUndefConstant(Ruby runtime2, String name2) {
        return this.getAutoloadConstant(runtime2, name2);
    }

    public IRubyObject setConstantQuiet(String name2, IRubyObject value2) {
        return this.setConstantCommon(name2, value2, false);
    }

    public IRubyObject setConstant(String name2, IRubyObject value2) {
        return this.setConstantCommon(name2, value2, true);
    }

    private IRubyObject setConstantCommon(String name2, IRubyObject value2, boolean warn2) {
        RubyModule module;
        IRubyObject oldValue = this.fetchConstant(name2);
        if (oldValue != null) {
            if (oldValue == UNDEF) {
                this.setAutoloadConstant(name2, value2);
            } else {
                if (warn2) {
                    this.getRuntime().getWarnings().warn(IRubyWarnings.ID.CONSTANT_ALREADY_INITIALIZED, "already initialized constant " + name2);
                }
                this.storeConstant(name2, value2);
            }
        } else {
            this.storeConstant(name2, value2);
        }
        this.invalidateConstantCache();
        if (value2 instanceof RubyModule && (module = (RubyModule)value2) != this && module.getBaseName() == null) {
            module.setBaseName(name2);
            module.setParent(this);
        }
        return value2;
    }

    public IRubyObject fastSetConstant(String internedName, IRubyObject value2) {
        return this.setConstant(internedName, value2);
    }

    public void defineConstant(String name2, IRubyObject value2) {
        assert (value2 != null);
        if (this == this.getRuntime().getClassClass()) {
            this.getRuntime().secure(4);
        }
        if (!IdUtil.isValidConstantName(name2)) {
            throw this.getRuntime().newNameError("bad constant name " + name2, name2);
        }
        this.setConstant(name2, value2);
    }

    public boolean isConstantDefined(String name2) {
        assert (IdUtil.isConstant(name2));
        boolean isObject = this == this.getRuntime().getObject();
        RubyModule module = this;
        do {
            IRubyObject value2;
            if ((value2 = module.constantTableFetch(name2)) == null) continue;
            if (value2 != UNDEF) {
                return true;
            }
            return this.getAutoloadMap().get(name2) != null;
        } while (isObject && (module = module.getSuperClass()) != null);
        return false;
    }

    public boolean fastIsConstantDefined(String internedName) {
        assert (internedName == internedName.intern()) : internedName + " is not interned";
        assert (IdUtil.isConstant(internedName));
        boolean isObject = this == this.getRuntime().getObject();
        RubyModule module = this;
        do {
            IRubyObject value2;
            if ((value2 = module.constantTableFastFetch(internedName)) == null) continue;
            if (value2 != UNDEF) {
                return true;
            }
            return this.getAutoloadMap().get(internedName) != null;
        } while (isObject && (module = module.getSuperClass()) != null);
        return false;
    }

    public boolean fastIsConstantDefined19(String internedName) {
        return this.fastIsConstantDefined19(internedName, true);
    }

    public boolean fastIsConstantDefined19(String internedName, boolean inherit) {
        assert (internedName == internedName.intern()) : internedName + " is not interned";
        assert (IdUtil.isConstant(internedName));
        for (RubyModule module = this; module != null; module = module.getSuperClass()) {
            IRubyObject value2 = module.constantTableFastFetch(internedName);
            if (value2 != null) {
                if (value2 != UNDEF) {
                    return true;
                }
                return this.getAutoloadMap().get(internedName) != null;
            }
            if (!inherit) break;
        }
        return false;
    }

    private RaiseException cannotRemoveError(String id2) {
        return this.getRuntime().newNameError("cannot remove " + id2 + " for " + this.getName(), id2);
    }

    public boolean hasInternalModuleVariable(String name2) {
        for (RubyModule module = this; module != null; module = module.getSuperClass()) {
            if (!module.hasInternalVariable(name2)) continue;
            return true;
        }
        return false;
    }

    public IRubyObject searchInternalModuleVariable(String name2) {
        for (RubyModule module = this; module != null; module = module.getSuperClass()) {
            IRubyObject value2 = (IRubyObject)module.getInternalVariable(name2);
            if (value2 == null) continue;
            return value2;
        }
        return null;
    }

    public void setInternalModuleVariable(String name2, IRubyObject value2) {
        for (RubyModule module = this; module != null; module = module.getSuperClass()) {
            if (!module.hasInternalVariable(name2)) continue;
            module.setInternalVariable(name2, value2);
            return;
        }
        this.setInternalVariable(name2, value2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map<String, IRubyObject> getClassVariables() {
        if (this.classVariables == Collections.EMPTY_MAP) {
            RubyModule rubyModule = this;
            synchronized (rubyModule) {
                if (this.classVariables == Collections.EMPTY_MAP) {
                    this.classVariables = new ConcurrentHashMap<String, IRubyObject>(4, 0.75f, 2);
                }
            }
        }
        return this.classVariables;
    }

    protected Map<String, IRubyObject> getClassVariablesForRead() {
        return this.classVariables;
    }

    public boolean hasClassVariable(String name2) {
        assert (IdUtil.isClassVariable(name2));
        return this.getClassVariablesForRead().containsKey(name2);
    }

    public boolean fastHasClassVariable(String internedName) {
        return this.hasClassVariable(internedName);
    }

    public IRubyObject fetchClassVariable(String name2) {
        assert (IdUtil.isClassVariable(name2));
        return this.getClassVariablesForRead().get(name2);
    }

    public IRubyObject fastFetchClassVariable(String internedName) {
        return this.fetchClassVariable(internedName);
    }

    public IRubyObject storeClassVariable(String name2, IRubyObject value2) {
        assert (IdUtil.isClassVariable(name2) && value2 != null);
        this.ensureClassVariablesSettable();
        this.getClassVariables().put(name2, value2);
        return value2;
    }

    public IRubyObject fastStoreClassVariable(String internedName, IRubyObject value2) {
        return this.storeClassVariable(internedName, value2);
    }

    public IRubyObject deleteClassVariable(String name2) {
        assert (IdUtil.isClassVariable(name2));
        this.ensureClassVariablesSettable();
        return this.getClassVariablesForRead().remove(name2);
    }

    public List<String> getClassVariableNameList() {
        return new ArrayList<String>(this.getClassVariablesForRead().keySet());
    }

    protected final String validateClassVariable(String name2) {
        if (IdUtil.isValidClassVariableName(name2)) {
            return name2;
        }
        throw this.getRuntime().newNameError("`" + name2 + "' is not allowed as a class variable name", name2);
    }

    protected final void ensureClassVariablesSettable() {
        Ruby runtime2 = this.getRuntime();
        if (!this.isFrozen() && (runtime2.getSafeLevel() < 4 || this.isTaint())) {
            return;
        }
        if (runtime2.getSafeLevel() >= 4 && !this.isTaint()) {
            throw runtime2.newSecurityError(ERR_INSECURE_SET_CONSTANT);
        }
        if (this.isFrozen()) {
            if (this instanceof RubyModule) {
                throw runtime2.newFrozenError("class/module ");
            }
            throw runtime2.newFrozenError("");
        }
    }

    public boolean hasConstant(String name2) {
        assert (IdUtil.isConstant(name2));
        return this.constantTableContains(name2);
    }

    public boolean fastHasConstant(String internedName) {
        assert (IdUtil.isConstant(internedName));
        return this.constantTableFastContains(internedName);
    }

    public IRubyObject fetchConstant(String name2) {
        assert (IdUtil.isConstant(name2));
        return this.constantTableFetch(name2);
    }

    public IRubyObject fastFetchConstant(String internedName) {
        assert (IdUtil.isConstant(internedName));
        return this.constantTableFastFetch(internedName);
    }

    public IRubyObject storeConstant(String name2, IRubyObject value2) {
        assert (IdUtil.isConstant(name2) && value2 != null);
        this.ensureConstantsSettable();
        return this.constantTableStore(name2, value2);
    }

    public IRubyObject fastStoreConstant(String internedName, IRubyObject value2) {
        assert (IdUtil.isConstant(internedName) && value2 != null);
        this.ensureConstantsSettable();
        return this.constantTableFastStore(internedName, value2);
    }

    public IRubyObject deleteConstant(String name2) {
        assert (IdUtil.isConstant(name2));
        this.ensureConstantsSettable();
        return this.constantTableRemove(name2);
    }

    @Deprecated
    public List<Variable<IRubyObject>> getStoredConstantList() {
        return null;
    }

    @Deprecated
    public List<String> getStoredConstantNameList() {
        return new ArrayList<String>(this.getConstantMap().keySet());
    }

    public Collection<String> getConstantNames() {
        return this.getConstantMap().keySet();
    }

    protected final String validateConstant(String name2) {
        if (IdUtil.isValidConstantName(name2)) {
            return name2;
        }
        throw this.getRuntime().newNameError("wrong constant name " + name2, name2);
    }

    protected final void ensureConstantsSettable() {
        boolean isSecure;
        boolean bl = isSecure = this.getRuntime().getSafeLevel() >= 4 && !this.isTaint();
        if (isSecure) {
            throw this.getRuntime().newSecurityError(ERR_INSECURE_SET_CONSTANT);
        }
        if (this.isFrozen()) {
            throw this.getRuntime().newFrozenError("class/module ");
        }
    }

    protected boolean constantTableContains(String name2) {
        return this.getConstantMap().containsKey(name2);
    }

    protected boolean constantTableFastContains(String internedName) {
        return this.getConstantMap().containsKey(internedName);
    }

    protected IRubyObject constantTableFetch(String name2) {
        return this.getConstantMap().get(name2);
    }

    protected IRubyObject constantTableFastFetch(String internedName) {
        return this.getConstantMap().get(internedName);
    }

    protected IRubyObject constantTableStore(String name2, IRubyObject value2) {
        this.getConstantMapForWrite().put(name2, value2);
        return value2;
    }

    protected IRubyObject constantTableFastStore(String internedName, IRubyObject value2) {
        this.getConstantMapForWrite().put(internedName, value2);
        return value2;
    }

    protected IRubyObject constantTableRemove(String name2) {
        return this.getConstantMapForWrite().remove(name2);
    }

    protected void defineAutoload(String name2, IAutoloadMethod loadMethod) {
        this.storeConstant(name2, RubyObject.UNDEF);
        this.getAutoloadMapForWrite().put(name2, new Autoload(loadMethod));
    }

    protected IRubyObject finishAutoload(String name2) {
        Autoload autoload2 = this.getAutoloadMap().get(name2);
        if (autoload2 != null) {
            IRubyObject value2 = autoload2.getValue();
            if (value2 != null) {
                this.storeConstant(name2, value2);
            }
            this.removeAutoload(name2);
            return value2;
        }
        return null;
    }

    public IRubyObject getAutoloadConstant(Ruby runtime2, String name2) {
        Autoload autoload2 = this.getAutoloadMap().get(name2);
        if (autoload2 == null) {
            return null;
        }
        return autoload2.getConstant(runtime2.getCurrentContext());
    }

    private void setAutoloadConstant(String name2, IRubyObject value2) {
        Autoload autoload2 = this.getAutoloadMap().get(name2);
        if (autoload2 != null) {
            if (!autoload2.setConstant(this.getRuntime().getCurrentContext(), value2)) {
                this.storeConstant(name2, value2);
                this.removeAutoload(name2);
            }
        } else {
            this.storeConstant(name2, value2);
        }
    }

    private void removeAutoload(String name2) {
        this.getAutoloadMapForWrite().remove(name2);
    }

    protected String getAutoloadFile(String name2) {
        Autoload autoload2 = this.getAutoloadMap().get(name2);
        if (autoload2 != null) {
            return autoload2.getFile();
        }
        return null;
    }

    private static void define(RubyModule module, JavaMethodDescriptor desc, DynamicMethod dynamicMethod) {
        block17: {
            String baseName;
            RubyClass singletonClass;
            JRubyMethod jrubyMethod;
            block18: {
                String baseName2;
                jrubyMethod = desc.anno;
                if (jrubyMethod.frame()) {
                    for (String name2 : jrubyMethod.name()) {
                        ASTInspector.FRAME_AWARE_METHODS.add(name2);
                    }
                }
                if (jrubyMethod.compat() != CompatVersion.BOTH && module.getRuntime().getInstanceConfig().getCompatVersion() != jrubyMethod.compat()) break block17;
                if (!jrubyMethod.meta()) break block18;
                singletonClass = module.getSingletonClass();
                dynamicMethod.setImplementationClass(singletonClass);
                if (jrubyMethod.name().length == 0) {
                    baseName2 = desc.name;
                    singletonClass.addMethod(baseName2, dynamicMethod);
                } else {
                    baseName2 = jrubyMethod.name()[0];
                    String[] arr$ = jrubyMethod.name();
                    int len$ = arr$.length;
                    for (int i$ = 0; i$ < len$; ++i$) {
                        String name3 = arr$[i$];
                        singletonClass.addMethod(name3, dynamicMethod);
                    }
                }
                if (jrubyMethod.alias().length <= 0) break block17;
                for (String alias2 : jrubyMethod.alias()) {
                    singletonClass.defineAlias(alias2, baseName2);
                }
                break block17;
            }
            if (jrubyMethod.name().length == 0) {
                baseName = desc.name;
                module.addMethod(baseName, dynamicMethod);
            } else {
                baseName = jrubyMethod.name()[0];
                String[] arr$ = jrubyMethod.name();
                int len$ = arr$.length;
                for (int i$ = 0; i$ < len$; ++i$) {
                    String name4 = arr$[i$];
                    module.addMethod(name4, dynamicMethod);
                }
            }
            if (jrubyMethod.alias().length > 0) {
                for (String alias3 : jrubyMethod.alias()) {
                    module.defineAlias(alias3, baseName);
                }
            }
            if (jrubyMethod.module()) {
                singletonClass = module.getSingletonClass();
                DynamicMethod moduleMethod = dynamicMethod.dup();
                moduleMethod.setVisibility(Visibility.PUBLIC);
                if (jrubyMethod.name().length == 0) {
                    baseName = desc.name;
                    singletonClass.addMethod(desc.name, moduleMethod);
                } else {
                    baseName = jrubyMethod.name()[0];
                    for (String name5 : jrubyMethod.name()) {
                        singletonClass.addMethod(name5, moduleMethod);
                    }
                }
                if (jrubyMethod.alias().length > 0) {
                    for (String alias4 : jrubyMethod.alias()) {
                        singletonClass.defineAlias(alias4, baseName);
                    }
                }
            }
        }
    }

    private class Autoload {
        private volatile ThreadContext ctx = null;
        private final Object ctxLock = new Object();
        private volatile IRubyObject value = null;
        private final IAutoloadMethod loadMethod;

        Autoload(IAutoloadMethod loadMethod) {
            this.loadMethod = loadMethod;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        IRubyObject getConstant(ThreadContext ctx) {
            Object object = this.ctxLock;
            synchronized (object) {
                if (this.ctx == null) {
                    this.ctx = ctx;
                } else if (this.isSelf(ctx)) {
                    return this.getValue();
                }
                this.getLoadMethod().load(ctx.runtime);
            }
            return this.getValue();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean setConstant(ThreadContext ctx, IRubyObject value2) {
            Object object = this.ctxLock;
            synchronized (object) {
                if (this.ctx == null) {
                    return false;
                }
                if (this.isSelf(ctx)) {
                    this.value = value2;
                    return true;
                }
                return false;
            }
        }

        IRubyObject getValue() {
            return this.value;
        }

        String getFile() {
            return this.getLoadMethod().file();
        }

        private IAutoloadMethod getLoadMethod() {
            return this.loadMethod;
        }

        private boolean isSelf(ThreadContext rhs) {
            return this.ctx != null && this.ctx.getThread() == rhs.getThread();
        }
    }

    public static class RespondToMissingMethod
    extends JavaMethod.JavaMethodNBlock {
        final CallSite site;

        public RespondToMissingMethod(RubyModule implClass, Visibility vis, String methodName) {
            super(implClass, vis);
            this.site = new FunctionalCachingCallSite(methodName);
        }

        public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name2, IRubyObject[] args2, Block block) {
            return this.site.call(context, self, self, args2, block);
        }

        public boolean equals(Object other) {
            if (!(other instanceof RespondToMissingMethod)) {
                return false;
            }
            RespondToMissingMethod rtmm = (RespondToMissingMethod)other;
            return this.site.methodName.equals(rtmm.site.methodName) && this.getImplementationClass() == rtmm.getImplementationClass();
        }
    }

    protected static class ProfilingCacheEntryFactory
    extends WrapperCacheEntryFactory {
        public ProfilingCacheEntryFactory(CacheEntryFactory previous) {
            super(previous);
        }

        public CacheEntry newCacheEntry(DynamicMethod method2, int token) {
            if (method2.isUndefined()) {
                return new CacheEntry(method2, token);
            }
            CacheEntry delegated = this.previous.newCacheEntry(method2, token);
            return new CacheEntry(new ProfilingDynamicMethod(delegated.method), delegated.token);
        }
    }

    protected static class SynchronizedCacheEntryFactory
    extends WrapperCacheEntryFactory {
        public SynchronizedCacheEntryFactory(CacheEntryFactory previous) {
            super(previous);
        }

        public CacheEntry newCacheEntry(DynamicMethod method2, int token) {
            if (method2.isUndefined()) {
                return new CacheEntry(method2, token);
            }
            CacheEntry delegated = this.previous.newCacheEntry(method2, token);
            return new CacheEntry(new SynchronizedDynamicMethod(delegated.method), delegated.token);
        }
    }

    protected static abstract class WrapperCacheEntryFactory
    extends CacheEntryFactory {
        protected final CacheEntryFactory previous;

        public WrapperCacheEntryFactory(CacheEntryFactory previous) {
            this.previous = previous;
        }

        public CacheEntryFactory getPrevious() {
            return this.previous;
        }
    }

    protected static abstract class CacheEntryFactory {
        protected CacheEntryFactory() {
        }

        public abstract CacheEntry newCacheEntry(DynamicMethod var1, int var2);

        public boolean hasCacheEntryFactory(Class cacheEntryFactoryClass) {
            CacheEntryFactory current2 = this;
            while (current2 instanceof WrapperCacheEntryFactory) {
                if (cacheEntryFactoryClass.isAssignableFrom(current2.getClass())) {
                    return true;
                }
                current2 = ((WrapperCacheEntryFactory)current2).getPrevious();
            }
            return cacheEntryFactoryClass.isAssignableFrom(current2.getClass());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class MethodClumper {
        Map<String, List<JavaMethodDescriptor>> annotatedMethods = new HashMap<String, List<JavaMethodDescriptor>>();
        Map<String, List<JavaMethodDescriptor>> staticAnnotatedMethods = new HashMap<String, List<JavaMethodDescriptor>>();
        Map<String, List<JavaMethodDescriptor>> annotatedMethods1_8 = new HashMap<String, List<JavaMethodDescriptor>>();
        Map<String, List<JavaMethodDescriptor>> staticAnnotatedMethods1_8 = new HashMap<String, List<JavaMethodDescriptor>>();
        Map<String, List<JavaMethodDescriptor>> annotatedMethods1_9 = new HashMap<String, List<JavaMethodDescriptor>>();
        Map<String, List<JavaMethodDescriptor>> staticAnnotatedMethods1_9 = new HashMap<String, List<JavaMethodDescriptor>>();
        Map<String, List<JavaMethodDescriptor>> allAnnotatedMethods = new HashMap<String, List<JavaMethodDescriptor>>();

        public void clump(Class cls) {
            Method[] declaredMethods;
            for (Method method2 : declaredMethods = cls.getDeclaredMethods()) {
                JRubyMethod anno = method2.getAnnotation(JRubyMethod.class);
                if (anno == null) continue;
                JavaMethodDescriptor desc = new JavaMethodDescriptor(method2);
                String name2 = anno.name().length == 0 ? method2.getName() : anno.name()[0];
                Map<String, List<JavaMethodDescriptor>> methodsHash = null;
                methodsHash = desc.isStatic ? (anno.compat() == CompatVersion.RUBY1_8 ? this.staticAnnotatedMethods1_8 : (anno.compat() == CompatVersion.RUBY1_9 ? this.staticAnnotatedMethods1_9 : this.staticAnnotatedMethods)) : (anno.compat() == CompatVersion.RUBY1_8 ? this.annotatedMethods1_8 : (anno.compat() == CompatVersion.RUBY1_9 ? this.annotatedMethods1_9 : this.annotatedMethods));
                List<JavaMethodDescriptor> methodDescs = methodsHash.get(name2);
                if (methodDescs == null) {
                    methodDescs = new ArrayList<JavaMethodDescriptor>();
                    methodsHash.put(name2, methodDescs);
                }
                methodDescs.add(desc);
                methodDescs = this.allAnnotatedMethods.get(name2);
                if (methodDescs == null) {
                    methodDescs = new ArrayList<JavaMethodDescriptor>();
                    this.allAnnotatedMethods.put(name2, methodDescs);
                }
                methodDescs.add(desc);
            }
        }

        public Map<String, List<JavaMethodDescriptor>> getAllAnnotatedMethods() {
            return this.allAnnotatedMethods;
        }

        public Map<String, List<JavaMethodDescriptor>> getAnnotatedMethods() {
            return this.annotatedMethods;
        }

        public Map<String, List<JavaMethodDescriptor>> getAnnotatedMethods1_8() {
            return this.annotatedMethods1_8;
        }

        public Map<String, List<JavaMethodDescriptor>> getAnnotatedMethods1_9() {
            return this.annotatedMethods1_9;
        }

        public Map<String, List<JavaMethodDescriptor>> getStaticAnnotatedMethods() {
            return this.staticAnnotatedMethods;
        }

        public Map<String, List<JavaMethodDescriptor>> getStaticAnnotatedMethods1_8() {
            return this.staticAnnotatedMethods1_8;
        }

        public Map<String, List<JavaMethodDescriptor>> getStaticAnnotatedMethods1_9() {
            return this.staticAnnotatedMethods1_9;
        }
    }

    public static class KindOf {
        public static final KindOf DEFAULT_KIND_OF = new KindOf();

        public boolean isKindOf(IRubyObject obj, RubyModule type2) {
            return obj.getMetaClass().hasModuleInHierarchy(type2);
        }
    }

    public static class ModuleKernelMethods {
        @JRubyMethod
        public static IRubyObject autoload(IRubyObject recv2, IRubyObject arg0, IRubyObject arg1) {
            return RubyKernel.autoload(recv2, arg0, arg1);
        }

        @JRubyMethod(name={"autoload?"})
        public static IRubyObject autoload_p(ThreadContext context, IRubyObject recv2, IRubyObject arg0) {
            return RubyKernel.autoload_p(context, recv2, arg0);
        }
    }
}

