/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.dsml.jndi;

import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.SearchResult;
import org.castor.core.util.Base64Encoder;
import org.exolab.castor.dsml.ImportExportException;
import org.exolab.castor.dsml.Producer;
import org.xml.sax.DocumentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributeListImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JNDIProducer
extends Producer {
    public JNDIProducer(DocumentHandler docHandler, boolean namespace) {
        super(docHandler, namespace);
    }

    public void produce(String name, Attributes attrs) throws SAXException, NamingException {
        this.leaveSchema();
        this.enterDirectory();
        AttributeListImpl attrList = new AttributeListImpl();
        attrList.addAttribute("dn", "CDATA", name);
        this._docHandler.startElement(this.prefix("entry"), attrList);
        if (attrs != null) {
            Attribute attr = attrs.get("objectclass");
            if (attr != null) {
                attrList = new AttributeListImpl();
                this._docHandler.startElement(this.prefix("objectclass"), attrList);
                NamingEnumeration<?> values = attr.getAll();
                while (values.hasMore()) {
                    Object value = values.next();
                    char[] chars = value != null ? value.toString().toCharArray() : new char[]{};
                    attrList = new AttributeListImpl();
                    this._docHandler.startElement(this.prefix("oc-value"), attrList);
                    this._docHandler.characters(chars, 0, chars.length);
                    this._docHandler.endElement(this.prefix("oc-value"));
                }
                this._docHandler.endElement(this.prefix("objectclass"));
            }
            NamingEnumeration<? extends Attribute> enumeration = attrs.getAll();
            while (enumeration.hasMore()) {
                attr = enumeration.next();
                if (attr.getID().equals("objectclass")) continue;
                attrList = new AttributeListImpl();
                attrList.addAttribute("name", "CDATA", attr.getID());
                this._docHandler.startElement(this.prefix("attr"), attrList);
                NamingEnumeration<?> values = attr.getAll();
                while (values.hasMore()) {
                    char[] chars = null;
                    byte[] bytes = null;
                    attrList = new AttributeListImpl();
                    Object value = values.next();
                    if (value == null) {
                        chars = new char[]{};
                    } else if (value instanceof String) {
                        chars = ((String)value).toCharArray();
                    } else if (value instanceof byte[]) {
                        bytes = (byte[])value;
                    } else {
                        chars = value.toString().toCharArray();
                    }
                    if (chars != null) {
                        boolean encode = false;
                        boolean wchar = false;
                        int i = 0;
                        while (i < chars.length && !wchar) {
                            char c;
                            if ((c = chars[i++]) >= '\u0100') {
                                encode = true;
                                wchar = true;
                                continue;
                            }
                            if (c < '\u0080' && (c >= ' ' || c == '\n' || c == '\t')) continue;
                            encode = true;
                        }
                        if (encode) {
                            if (wchar) {
                                bytes = new byte[chars.length << 1];
                                int j = 0;
                                for (i = 0; i < chars.length; ++i) {
                                    bytes[j++] = (byte)(chars[i] >> 8);
                                    bytes[j++] = (byte)(0xFF & chars[i]);
                                }
                            } else {
                                bytes = new byte[chars.length];
                                for (i = 0; i < chars.length; ++i) {
                                    bytes[i] = (byte)chars[i];
                                }
                            }
                        }
                    }
                    if (bytes != null) {
                        chars = Base64Encoder.encode(bytes);
                        attrList.addAttribute("encoding", "NMTOKEN", "base64");
                    }
                    this._docHandler.startElement(this.prefix("value"), attrList);
                    this._docHandler.characters(chars, 0, chars.length);
                    this._docHandler.endElement(this.prefix("value"));
                }
                this._docHandler.endElement(this.prefix("attr"));
            }
        }
        this._docHandler.endElement(this.prefix("entry"));
    }

    public void produce(SearchResult result) throws SAXException {
        try {
            this.produce(result.getName(), result.getAttributes());
        }
        catch (NamingException except) {
            throw new SAXException(except.toString());
        }
    }

    public void produce(NamingEnumeration<SearchResult> results) throws ImportExportException, SAXException {
        try {
            while (results.hasMore()) {
                SearchResult result = results.next();
                this.produce(result.getName(), result.getAttributes());
            }
        }
        catch (NamingException except) {
            throw new ImportExportException(except);
        }
    }
}

