/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.scriptbuilder.domain;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.jclouds.scriptbuilder.domain.OsFamily;
import org.jclouds.scriptbuilder.domain.ShellToken;
import org.jclouds.scriptbuilder.domain.Statement;
import org.jclouds.scriptbuilder.domain.StatementList;
import org.jclouds.scriptbuilder.domain.Statements;

public class AppendFile
implements Statement {
    public static final String MARKER = "END_OF_FILE";
    final String path;
    final Iterable<String> lines;
    final String marker;

    public AppendFile(String path, Iterable<String> lines) {
        this(path, lines, MARKER);
    }

    public AppendFile(String path, Iterable<String> lines, String marker) {
        this.path = (String)Preconditions.checkNotNull((Object)path, (Object)"path");
        this.lines = (Iterable)Preconditions.checkNotNull(lines, (Object)"lines");
        this.marker = (String)Preconditions.checkNotNull((Object)marker, (Object)"marker");
        Preconditions.checkState((Iterables.size(lines) > 0 ? 1 : 0) != 0, (Object)"you must pass something to execute");
    }

    public static String escapeVarTokens(String toEscape, OsFamily family) {
        HashMap inputToEscape = Maps.newHashMap();
        for (ShellToken token : ImmutableList.of((Object)((Object)ShellToken.VARL), (Object)((Object)ShellToken.VARR))) {
            if (token.to(family).equals("")) continue;
            String tokenS = "{" + token.toString().toLowerCase() + "}";
            inputToEscape.put(tokenS, "{escvar}" + tokenS);
        }
        for (Map.Entry entry : inputToEscape.entrySet()) {
            toEscape = toEscape.replace((CharSequence)entry.getKey(), (CharSequence)entry.getValue());
        }
        return toEscape;
    }

    @Override
    public Iterable<String> functionDependencies(OsFamily family) {
        return Collections.emptyList();
    }

    @Override
    public String render(OsFamily family) {
        ArrayList statements = Lists.newArrayList();
        if (family == OsFamily.UNIX) {
            StringBuilder builder = new StringBuilder();
            this.hereFile(this.path, builder);
            statements.add(Statements.interpret(builder.toString()));
        } else {
            for (String line : this.lines) {
                statements.add(this.appendToFile(line, this.path, family));
            }
        }
        return new StatementList(statements).render(family);
    }

    protected void hereFile(String path, StringBuilder builder) {
        builder.append("cat >> ").append(path).append(" <<'").append(this.marker).append("'\n");
        for (String line : this.lines) {
            builder.append(line).append("\n");
        }
        builder.append(this.marker).append("\n");
    }

    protected Statement appendToFile(String line, String path, OsFamily family) {
        String quote = "";
        if (!ShellToken.VQ.to(family).equals("")) {
            quote = "'";
        } else {
            line = AppendFile.escapeVarTokens(line, family);
        }
        return Statements.interpret(String.format("echo %s%s%s >>%s{lf}", quote, line, quote, path));
    }
}

