/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.scriptbuilder.domain;

import com.google.common.base.CaseFormat;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.jclouds.scriptbuilder.domain.OsFamily;
import org.jclouds.scriptbuilder.domain.ShellToken;
import org.jclouds.scriptbuilder.domain.Statement;
import org.jclouds.scriptbuilder.domain.StatementList;
import org.jclouds.scriptbuilder.domain.Statements;
import org.jclouds.scriptbuilder.util.Utils;

public class CreateRunScript
extends StatementList {
    public static final String MARKER = "END_OF_SCRIPT";
    final String instanceName;
    final Iterable<String> exports;
    final String pwd;
    public static final Map<OsFamily, String> OS_TO_CHMOD_PATTERN = ImmutableMap.of((Object)((Object)OsFamily.UNIX), (Object)"chmod u+x {file}\n", (Object)((Object)OsFamily.WINDOWS), (Object)"");
    public static final Pattern REDIRECT_FD_PATTERN = Pattern.compile(".*[0-2]>>.*");

    public CreateRunScript(String instanceName, Iterable<String> exports, String pwd, Iterable<Statement> statements) {
        super(statements);
        this.instanceName = (String)Preconditions.checkNotNull((Object)instanceName, (Object)"instanceName");
        this.exports = (Iterable)Preconditions.checkNotNull(exports, (Object)"exports");
        this.pwd = ((String)Preconditions.checkNotNull((Object)pwd, (Object)"pwd")).replaceAll("[/\\\\]", "{fs}");
    }

    public static String escapeVarTokens(String toEscape, OsFamily family) {
        HashMap inputToEscape = Maps.newHashMap();
        for (ShellToken token : ImmutableList.of((Object)((Object)ShellToken.VARL), (Object)((Object)ShellToken.VARR))) {
            if (token.to(family).equals("")) continue;
            String tokenS = "{" + token.toString().toLowerCase() + "}";
            inputToEscape.put(tokenS, "{escvar}" + tokenS);
        }
        for (Map.Entry entry : inputToEscape.entrySet()) {
            toEscape = toEscape.replace((CharSequence)entry.getKey(), (CharSequence)entry.getValue());
        }
        return toEscape;
    }

    @Override
    public Iterable<String> functionDependencies(OsFamily family) {
        return Collections.emptyList();
    }

    @Override
    public String render(OsFamily family) {
        ArrayList statements = Lists.newArrayList();
        Map<String, String> tokenMap = ShellToken.tokenValueMap(family);
        String runScript = Utils.replaceTokens(this.pwd + "{fs}" + this.instanceName + ".{sh}", tokenMap);
        statements.add(Statements.interpret(String.format("{md} %s{lf}", this.pwd)));
        if (family == OsFamily.UNIX) {
            StringBuilder builder = new StringBuilder();
            builder.append("\n");
            this.addUnixRunScriptHeader(family, runScript, builder);
            builder.append("\n");
            this.addUnixRunScript(runScript, builder);
            builder.append("\n");
            this.addUnixRunScriptFooter(family, runScript, builder);
            builder.append("\n");
            statements.add(Statements.interpret(builder.toString()));
        } else {
            statements.add(Statements.interpret(String.format("{rm} %s 2{closeFd}{lf}", runScript)));
            for (String line : Splitter.on((String)ShellToken.LF.to(family)).split((CharSequence)ShellToken.BEGIN_SCRIPT.to(family))) {
                if (line.equals("")) continue;
                statements.add(this.appendToFile(line, runScript, family));
            }
            statements.add(new AddTitleToFile(this.instanceName, runScript));
            statements.add(this.appendToFile(Utils.writeZeroPath(family).replace(ShellToken.LF.to(family), ""), runScript, family));
            statements.add(new AddExportToFile("instanceName", this.instanceName, runScript));
            for (String export : this.exports) {
                statements.add(new AddExportToFile(export, Utils.replaceTokens("{varl}" + CaseFormat.LOWER_CAMEL.to(CaseFormat.UPPER_UNDERSCORE, export) + "{varr}", tokenMap), runScript));
            }
            statements.add(this.appendToFile("{cd} " + this.pwd, runScript, family));
            statements.addAll(statements);
            for (String line : Splitter.on((String)ShellToken.LF.to(family)).split((CharSequence)ShellToken.END_SCRIPT.to(family))) {
                if (line.equals("")) continue;
                statements.add(this.appendToFile(line, runScript, family));
            }
        }
        statements.add(Statements.interpret(Utils.replaceTokens(OS_TO_CHMOD_PATTERN.get((Object)family), (Map<String, String>)ImmutableMap.of((Object)"file", (Object)runScript))));
        return new StatementList(statements).render(family);
    }

    private void addUnixRunScriptFooter(OsFamily family, String runScript, StringBuilder builder) {
        builder.append("# add runscript footer\n");
        builder.append("cat >> ").append(runScript).append(" <<'").append(MARKER).append("'\n");
        builder.append(ShellToken.END_SCRIPT.to(family));
        builder.append(MARKER).append("\n");
    }

    private void addUnixRunScript(String runScript, StringBuilder builder) {
        builder.append("# add desired commands from the user\n");
        builder.append("cat >> ").append(runScript).append(" <<'").append(MARKER).append("'\n");
        builder.append("cd ").append(this.pwd).append("\n");
        for (Statement statement : this.statements) {
            builder.append(statement.render(OsFamily.UNIX)).append("\n");
        }
        builder.append(MARKER).append("\n");
    }

    private void addUnixRunScriptHeader(OsFamily family, String runScript, StringBuilder builder) {
        builder.append("# create runscript header\n");
        builder.append("cat > ").append(runScript).append(" <<").append(MARKER).append("\n");
        builder.append(ShellToken.BEGIN_SCRIPT.to(family));
        builder.append("PROMPT_COMMAND='echo -ne \"\\033]0;").append(this.instanceName).append("\\007\"'\n");
        builder.append(Utils.writeZeroPath(family));
        builder.append("export INSTANCE_NAME='").append(this.instanceName).append("'\n");
        for (String export : this.exports) {
            String variableNameInUpper = CaseFormat.LOWER_CAMEL.to(CaseFormat.UPPER_UNDERSCORE, export);
            builder.append("export ").append(variableNameInUpper).append("='$").append(variableNameInUpper).append("'\n");
        }
        builder.append(MARKER).append("\n");
    }

    private Statement appendToFile(String line, String runScript, OsFamily family) {
        String quote = "";
        if (!ShellToken.VQ.to(family).equals("")) {
            quote = "'";
        } else {
            line = CreateRunScript.escapeVarTokens(line, family);
        }
        return Statements.interpret(CreateRunScript.addSpaceToEnsureWeDontAccidentallyRedirectFd(String.format("echo %s%s%s>>%s{lf}", quote, line, quote, runScript)));
    }

    static String addSpaceToEnsureWeDontAccidentallyRedirectFd(String line) {
        return REDIRECT_FD_PATTERN.matcher(line).matches() ? line.replace(">>", " >>") : line;
    }

    public static class AddExportToFile
    implements Statement {
        final String export;
        final String value;
        final String file;
        public static final Map<OsFamily, String> OS_TO_EXPORT_PATTERN = ImmutableMap.of((Object)((Object)OsFamily.UNIX), (Object)"echo \"export {export}='{value}'\">>{file}\n", (Object)((Object)OsFamily.WINDOWS), (Object)"echo set {export}={value}>>{file}\r\n");

        public AddExportToFile(String export, String value, String file) {
            this.export = (String)Preconditions.checkNotNull((Object)CaseFormat.LOWER_CAMEL.to(CaseFormat.UPPER_UNDERSCORE, export), (Object)"export");
            this.value = (String)Preconditions.checkNotNull((Object)value, (Object)"value");
            this.file = (String)Preconditions.checkNotNull((Object)file, (Object)"file");
        }

        @Override
        public Iterable<String> functionDependencies(OsFamily family) {
            return Collections.emptyList();
        }

        @Override
        public String render(OsFamily family) {
            return CreateRunScript.addSpaceToEnsureWeDontAccidentallyRedirectFd(Utils.replaceTokens(OS_TO_EXPORT_PATTERN.get((Object)family), (Map<String, String>)ImmutableMap.of((Object)"export", (Object)this.export, (Object)"value", (Object)this.value, (Object)"file", (Object)this.file)));
        }
    }

    public static class AddTitleToFile
    implements Statement {
        final String title;
        final String file;
        public static final Map<OsFamily, String> OS_TO_TITLE_PATTERN = ImmutableMap.of((Object)((Object)OsFamily.UNIX), (Object)"echo \"PROMPT_COMMAND='echo -ne \\\"\\033]0;{title}\\007\\\"'\">>{file}\n", (Object)((Object)OsFamily.WINDOWS), (Object)"echo title {title}>>{file}\r\n");

        public AddTitleToFile(String title, String file) {
            this.title = (String)Preconditions.checkNotNull((Object)title, (Object)"title");
            this.file = (String)Preconditions.checkNotNull((Object)file, (Object)"file");
        }

        @Override
        public Iterable<String> functionDependencies(OsFamily family) {
            return Collections.emptyList();
        }

        @Override
        public String render(OsFamily family) {
            return CreateRunScript.addSpaceToEnsureWeDontAccidentallyRedirectFd(Utils.replaceTokens(OS_TO_TITLE_PATTERN.get((Object)family), (Map<String, String>)ImmutableMap.of((Object)"title", (Object)this.title, (Object)"file", (Object)this.file)));
        }
    }
}

