/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.scriptbuilder.domain;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.List;
import org.jclouds.scriptbuilder.domain.AcceptsStatementVisitor;
import org.jclouds.scriptbuilder.domain.OsFamily;
import org.jclouds.scriptbuilder.domain.Statement;
import org.jclouds.scriptbuilder.domain.StatementVisitor;

public class StatementList
implements Statement,
AcceptsStatementVisitor {
    public final List<Statement> statements;

    public StatementList(Statement ... statements) {
        this.statements = ImmutableList.copyOf((Object[])((Object[])Preconditions.checkNotNull((Object)statements, (Object)"statements")));
    }

    public StatementList(Iterable<Statement> statements) {
        this.statements = ImmutableList.copyOf((Iterable)((Iterable)Preconditions.checkNotNull(statements, (Object)"statements")));
    }

    @Override
    public String render(OsFamily family) {
        StringBuilder statementsBuilder = new StringBuilder();
        for (Statement statement : this.statements) {
            statementsBuilder.append(statement.render(family));
        }
        return statementsBuilder.toString();
    }

    @Override
    public Iterable<String> functionDependencies(OsFamily family) {
        ImmutableList.Builder functions = ImmutableList.builder();
        for (Statement statement : this.statements) {
            functions.addAll(statement.functionDependencies(family));
        }
        return functions.build();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.statements == null ? 0 : ((Object)this.statements).hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        StatementList other = (StatementList)obj;
        return !(this.statements == null ? other.statements != null : !((Object)this.statements).equals(other.statements));
    }

    @Override
    public void accept(StatementVisitor visitor) {
        for (Statement statement : this.statements) {
            visitor.visit(statement);
        }
    }
}

