/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.webconsole;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.GeneralSecurityException;
import java.security.Principal;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.AccountException;
import javax.security.auth.login.FailedLoginException;
import javax.security.auth.login.LoginContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.felix.webconsole.WebConsoleSecurityProvider2;
import org.apache.felix.webconsole.internal.servlet.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JaasSecurityProvider
implements WebConsoleSecurityProvider2 {
    private static final Logger LOG = LoggerFactory.getLogger(JaasSecurityProvider.class);
    private static final String HEADER_WWW_AUTHENTICATE = "WWW-Authenticate";
    private static final String HEADER_AUTHORIZATION = "Authorization";
    private static final String AUTHENTICATION_SCHEME_BASIC = "Basic";
    private String realm;
    private String role;

    public String getRealm() {
        return this.realm;
    }

    public void setRealm(String realm) {
        this.realm = realm;
    }

    public String getRole() {
        return this.role;
    }

    public void setRole(String role) {
        this.role = role;
    }

    public Object authenticate(String username, String password) {
        return this.doAuthenticate(username, password);
    }

    public Subject doAuthenticate(final String username, final String password) {
        try {
            Subject subject = new Subject();
            LoginContext loginContext = new LoginContext(this.realm, subject, new CallbackHandler(){

                public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
                    for (int i = 0; i < callbacks.length; ++i) {
                        if (callbacks[i] instanceof NameCallback) {
                            ((NameCallback)callbacks[i]).setName(username);
                            continue;
                        }
                        if (callbacks[i] instanceof PasswordCallback) {
                            ((PasswordCallback)callbacks[i]).setPassword(password.toCharArray());
                            continue;
                        }
                        throw new UnsupportedCallbackException(callbacks[i]);
                    }
                }
            });
            loginContext.login();
            if (this.role != null && this.role.length() > 0) {
                String clazz = "org.apache.karaf.jaas.modules.RolePrincipal";
                String name = this.role;
                int idx = this.role.indexOf(58);
                if (idx > 0) {
                    clazz = this.role.substring(0, idx);
                    name = this.role.substring(idx + 1);
                }
                boolean found = false;
                for (Principal p : subject.getPrincipals()) {
                    if (!p.getClass().getName().equals(clazz) || !p.getName().equals(name)) continue;
                    found = true;
                    break;
                }
                if (!found) {
                    throw new FailedLoginException("User does not have the required role " + this.role);
                }
            }
            return subject;
        }
        catch (FailedLoginException e) {
            LOG.debug("Login failed", (Throwable)e);
            return null;
        }
        catch (AccountException e) {
            LOG.warn("Account failure", (Throwable)e);
            return null;
        }
        catch (GeneralSecurityException e) {
            LOG.error("General Security Exception", (Throwable)e);
            return null;
        }
    }

    public boolean authorize(Object o, String s) {
        return true;
    }

    public boolean authenticate(HttpServletRequest request, HttpServletResponse response) {
        int blank;
        String authHeader = request.getHeader(HEADER_AUTHORIZATION);
        if (authHeader != null && authHeader.length() > 0 && (blank = (authHeader = authHeader.trim()).indexOf(32)) > 0) {
            String authType = authHeader.substring(0, blank);
            String authInfo = authHeader.substring(blank).trim();
            if (authType.equalsIgnoreCase(AUTHENTICATION_SCHEME_BASIC)) {
                try {
                    String srcString = JaasSecurityProvider.base64Decode(authInfo);
                    int i = srcString.indexOf(58);
                    String username = srcString.substring(0, i);
                    String password = srcString.substring(i + 1);
                    Subject subject = this.doAuthenticate(username, password);
                    if (subject != null) {
                        request.setAttribute("org.osgi.service.http.authentication.type", (Object)"BASIC");
                        request.setAttribute("org.osgi.service.http.authentication.remote.user", (Object)username);
                        request.setAttribute("org.apache.felix.webconsole.user", (Object)username);
                        request.setAttribute("karaf.subject.runas", (Object)subject);
                        return true;
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }
        try {
            response.setHeader(HEADER_WWW_AUTHENTICATE, "Basic realm=\"" + this.realm + "\"");
            response.setStatus(401);
            response.setContentLength(0);
            response.flushBuffer();
        }
        catch (IOException ioe) {
            // empty catch block
        }
        return false;
    }

    private static String base64Decode(String srcString) {
        byte[] transformed = Base64.decodeBase64((String)srcString);
        try {
            return new String(transformed, "ISO-8859-1");
        }
        catch (UnsupportedEncodingException uee) {
            return new String(transformed);
        }
    }
}

