/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.epc.strategy;

import com.google.common.base.Preconditions;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Resource;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jclouds.compute.domain.ImageBuilder;
import org.jclouds.compute.domain.OperatingSystem;
import org.jclouds.compute.domain.OsFamily;
import org.jclouds.compute.util.ComputeServiceUtils;
import org.jclouds.ec2.compute.strategy.ReviseParsedImage;
import org.jclouds.ec2.domain.Image;
import org.jclouds.logging.Logger;

@Singleton
public class EucalyptusPartnerCloudReviseParsedImage
implements ReviseParsedImage {
    public static final Pattern PATTERN = Pattern.compile("^([^-]+)-([^-]+)-.*");
    public static final Pattern WINDOWS = Pattern.compile("^windows-([^/]+)/.*");
    private final Map<OsFamily, Map<String, String>> osVersionMap;
    @Resource
    @Named(value="jclouds.compute")
    protected Logger logger = Logger.NULL;

    @Inject
    public EucalyptusPartnerCloudReviseParsedImage(Map<OsFamily, Map<String, String>> osVersionMap) {
        this.osVersionMap = (Map)Preconditions.checkNotNull(osVersionMap, (Object)"osVersionMap");
    }

    public void reviseParsedImage(Image from, ImageBuilder builder, OsFamily family, OperatingSystem.Builder osBuilder) {
        try {
            if (from.getImageLocation().startsWith("windows")) {
                family = OsFamily.WINDOWS;
                osBuilder.family(family);
                Matcher matcher = WINDOWS.matcher(from.getImageLocation());
                if (matcher.find()) {
                    osBuilder.version(ComputeServiceUtils.parseVersionOrReturnEmptyString((OsFamily)family, (String)matcher.group(1).replace('-', ' ').replace('s', 'S'), this.osVersionMap));
                }
            } else {
                Matcher matcher = PATTERN.matcher(from.getImageLocation());
                if (matcher.find()) {
                    family = OsFamily.fromValue((String)matcher.group(1));
                    osBuilder.family(family);
                    osBuilder.version(ComputeServiceUtils.parseVersionOrReturnEmptyString((OsFamily)family, (String)matcher.group(2), this.osVersionMap));
                }
            }
        }
        catch (IllegalArgumentException e) {
            this.logger.debug("<< didn't match os(%s)", new Object[]{from.getImageLocation()});
        }
        catch (NoSuchElementException e) {
            this.logger.debug("<< didn't match at all(%s)", new Object[]{from.getImageLocation()});
        }
    }
}

