/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.cxf.common.message;

import java.util.List;
import java.util.Map;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.component.cxf.common.message.CxfMessageHelper;
import org.apache.camel.component.cxf.common.message.CxfMessageMapper;
import org.apache.camel.spi.HeaderFilterStrategy;
import org.apache.cxf.helpers.CastUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultCxfMesssageMapper
implements CxfMessageMapper {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultCxfMesssageMapper.class);

    @Override
    public org.apache.cxf.message.Message createCxfMessageFromCamelExchange(Exchange camelExchange, HeaderFilterStrategy headerFilterStrategy) {
        org.apache.cxf.message.Message answer = CxfMessageHelper.getCxfInMessage(headerFilterStrategy, camelExchange, false);
        Message camelMessage = camelExchange.getIn();
        String requestContentType = this.getRequestContentType(camelMessage);
        String acceptContentTypes = (String)camelMessage.getHeader("Accept", String.class);
        if (acceptContentTypes == null) {
            acceptContentTypes = "*/*";
        }
        String enc = this.getCharacterEncoding(camelMessage);
        String requestURI = this.getRequestURI(camelMessage);
        String path = this.getPath(camelMessage);
        String basePath = this.getBasePath(camelExchange);
        String verb = this.getVerb(camelMessage);
        String queryString = this.getQueryString(camelMessage);
        answer.put((Object)"org.apache.cxf.request.uri", (Object)requestURI);
        answer.put((Object)org.apache.cxf.message.Message.BASE_PATH, (Object)basePath);
        answer.put((Object)"org.apache.cxf.request.method", (Object)verb);
        answer.put((Object)org.apache.cxf.message.Message.PATH_INFO, (Object)path);
        answer.put((Object)"Content-Type", (Object)requestContentType);
        answer.put((Object)"Accept", (Object)acceptContentTypes);
        answer.put((Object)org.apache.cxf.message.Message.ENCODING, (Object)enc);
        answer.put((Object)org.apache.cxf.message.Message.QUERY_STRING, (Object)queryString);
        LOG.trace("Processing {}, requestContentType = {}, acceptContentTypes = {}, encoding = {}, path = {}, basePath = {}, verb = {}", new Object[]{camelExchange, requestContentType, acceptContentTypes, enc, path, basePath, verb});
        return answer;
    }

    @Override
    public void propagateResponseHeadersToCamel(org.apache.cxf.message.Message cxfMessage, Exchange exchange, HeaderFilterStrategy strategy) {
        String key;
        Object value;
        LOG.trace("Propagating response headers from CXF message {}", (Object)cxfMessage);
        if (strategy == null) {
            return;
        }
        Map camelHeaders = exchange.getOut().getHeaders();
        camelHeaders.putAll(exchange.getIn().getHeaders());
        Map cxfHeaders = CastUtils.cast((Map)((Map)cxfMessage.get((Object)org.apache.cxf.message.Message.PROTOCOL_HEADERS)));
        if (cxfHeaders != null) {
            for (Map.Entry entry : cxfHeaders.entrySet()) {
                if (strategy.applyFilterToExternalHeaders((String)entry.getKey(), entry.getValue(), exchange)) continue;
                camelHeaders.put(entry.getKey(), ((List)entry.getValue()).get(0));
                LOG.trace("Populate header from CXF header={} value={}", entry.getKey(), entry.getValue());
            }
        }
        if ((value = cxfMessage.get((Object)(key = org.apache.cxf.message.Message.RESPONSE_CODE))) != null && !strategy.applyFilterToExternalHeaders(key, value, exchange)) {
            camelHeaders.put("CamelHttpResponseCode", value);
            LOG.trace("Populate header from CXF header={} value={} as {}", new Object[]{key, value, "CamelHttpResponseCode"});
        }
        if (cxfMessage.get((Object)"Content-Type") != null) {
            camelHeaders.put("Content-Type", cxfMessage.get((Object)"Content-Type"));
        }
    }

    protected String getPath(Message camelMessage) {
        String answer = (String)camelMessage.getHeader("CamelHttpPath", String.class);
        return answer;
    }

    protected String getRequestURI(Message camelMessage) {
        String answer = (String)camelMessage.getHeader("CamelHttpUri", String.class);
        return answer;
    }

    protected String getBasePath(Exchange camelExchange) {
        String answer = (String)camelExchange.getIn().getHeader("CamelHttpBaseUri", String.class);
        if (answer == null) {
            answer = camelExchange.getFromEndpoint().getEndpointUri();
        }
        return answer;
    }

    protected String getVerb(Message camelMessage) {
        String answer = (String)camelMessage.getHeader("CamelHttpMethod", String.class);
        return answer;
    }

    protected String getQueryString(Message camelMessage) {
        String answer = (String)camelMessage.getHeader("CamelHttpQuery", String.class);
        return answer;
    }

    protected String getCharacterEncoding(Message camelMessage) {
        String answer = (String)camelMessage.getHeader("CamelHttpCharacterEncoding", String.class);
        if (answer == null) {
            answer = (String)camelMessage.getHeader("CamelCharsetName", String.class);
        }
        return answer;
    }

    protected String getRequestContentType(Message camelMessage) {
        String answer = (String)camelMessage.getHeader("Content-Type", String.class);
        if (answer != null) {
            return answer;
        }
        return "*/*";
    }
}

