/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dataformat.soap;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBIntrospector;
import javax.xml.namespace.QName;
import javax.xml.ws.WebFault;
import org.apache.camel.Exchange;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.dataformat.soap.SoapDataFormatAdapter;
import org.apache.camel.dataformat.soap.SoapJaxbDataFormat;
import org.w3._2003._05.soap_envelope.Body;
import org.w3._2003._05.soap_envelope.Detail;
import org.w3._2003._05.soap_envelope.Envelope;
import org.w3._2003._05.soap_envelope.Fault;
import org.w3._2003._05.soap_envelope.Faultcode;
import org.w3._2003._05.soap_envelope.Faultreason;
import org.w3._2003._05.soap_envelope.Header;
import org.w3._2003._05.soap_envelope.ObjectFactory;
import org.w3._2003._05.soap_envelope.Reasontext;

public class Soap12DataFormatAdapter
implements SoapDataFormatAdapter {
    private static final String SOAP_PACKAGE_NAME = Envelope.class.getPackage().getName();
    private static final QName FAULT_CODE_SERVER = new QName("http://www.w3.org/2003/05/soap-envelope", "Receiver");
    private final SoapJaxbDataFormat dataFormat;

    public Soap12DataFormatAdapter(SoapJaxbDataFormat dataFormat) {
        this.dataFormat = dataFormat;
    }

    @Override
    public SoapJaxbDataFormat getDataFormat() {
        return this.dataFormat;
    }

    @Override
    public Object doMarshal(Exchange exchange, Object inputObject, OutputStream stream, String soapAction) throws IOException {
        List<Object> bodyContent;
        Body body = new Body();
        Header header = new Header();
        Throwable exception = (Throwable)exchange.getProperty("CamelExceptionCaught", Throwable.class);
        if (exception == null) {
            exception = (Throwable)exchange.getIn().getHeader("CamelExceptionCaught", Throwable.class);
        }
        ArrayList headerContent = new ArrayList();
        if (exception != null) {
            bodyContent = new ArrayList<JAXBElement<Fault>>();
            bodyContent.add(this.createFaultFromException(exception));
        } else {
            bodyContent = this.getDataFormat().createContentFromObject(inputObject, soapAction, headerContent);
        }
        for (JAXBElement jAXBElement : bodyContent) {
            body.getAny().add(jAXBElement);
        }
        for (JAXBElement jAXBElement : headerContent) {
            header.getAny().add(jAXBElement);
        }
        Envelope envelope = new Envelope();
        if (headerContent.size() > 0) {
            envelope.setHeader(header);
        }
        envelope.setBody(body);
        JAXBElement jAXBElement = new ObjectFactory().createEnvelope(envelope);
        return jAXBElement;
    }

    private JAXBElement<Fault> createFaultFromException(Throwable exception) {
        Object faultObject;
        WebFault webFault = exception.getClass().getAnnotation(WebFault.class);
        if (webFault == null || webFault.targetNamespace() == null) {
            throw new RuntimeException("The exception " + exception.getClass().getName() + " needs to have an WebFault annotation with name and targetNamespace", exception);
        }
        QName name = new QName(webFault.targetNamespace(), webFault.name());
        try {
            Method method = exception.getClass().getMethod("getFaultInfo", new Class[0]);
            faultObject = method.invoke((Object)exception, new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeCamelException("Exception while trying to get fault details", (Throwable)e);
        }
        Fault fault = new Fault();
        Faultcode code = new Faultcode();
        code.setValue(FAULT_CODE_SERVER);
        fault.setCode(code);
        Reasontext text = new Reasontext();
        text.setValue(exception.getMessage());
        text.setLang("en");
        fault.setReason(new Faultreason().withText(new Reasontext[]{text}));
        Detail detailEl = new ObjectFactory().createDetail();
        JAXBElement faultDetailContent = new JAXBElement(name, faultObject.getClass(), faultObject);
        detailEl.getAny().add(faultDetailContent);
        fault.setDetail(detailEl);
        return new ObjectFactory().createFault(fault);
    }

    @Override
    public Object doUnmarshal(Exchange exchange, InputStream stream, Object rootObject) throws IOException {
        List anyElement;
        ArrayList<Object> anyHeaderElements;
        if (rootObject.getClass() != Envelope.class) {
            throw new RuntimeCamelException("Expected Soap Envelope but got " + rootObject.getClass());
        }
        Envelope envelope = (Envelope)rootObject;
        Header header = envelope.getHeader();
        if (header != null && null != (anyHeaderElements = envelope.getHeader().getAny()) && !this.getDataFormat().isIgnoreUnmarshalledHeaders()) {
            ArrayList<Object> returnHeaders;
            if (this.getDataFormat().isIgnoreJAXBElement()) {
                returnHeaders = new ArrayList<Object>();
                for (Object e : anyHeaderElements) {
                    returnHeaders.add(JAXBIntrospector.getValue(e));
                }
            } else {
                returnHeaders = anyHeaderElements;
            }
            exchange.getOut().setHeader("org.apache.camel.dataformat.soap.UNMARSHALLED_HEADER_LIST", returnHeaders);
        }
        if ((anyElement = envelope.getBody().getAny()).size() == 0) {
            return null;
        }
        Object payloadEl = anyElement.get(0);
        Object payload = JAXBIntrospector.getValue(payloadEl);
        if (payload instanceof Fault) {
            Exception exception = this.createExceptionFromFault((Fault)payload);
            exchange.setException((Throwable)exception);
            return null;
        }
        return this.getDataFormat().isIgnoreJAXBElement() ? payload : payloadEl;
    }

    private Exception createExceptionFromFault(Fault fault) {
        List detailList = fault.getDetail().getAny();
        StringBuilder sb = new StringBuilder();
        for (Reasontext text : fault.getReason().getText()) {
            sb.append(text);
        }
        String message = sb.toString();
        if (detailList.size() == 0) {
            return new RuntimeCamelException(message);
        }
        JAXBElement detailEl = (JAXBElement)detailList.get(0);
        Class<? extends Exception> exceptionClass = this.getDataFormat().getElementNameStrategy().findExceptionForFaultName(detailEl.getName());
        try {
            Constructor<? extends Exception> messageConstructor = exceptionClass.getConstructor(String.class);
            Object detail = JAXBIntrospector.getValue((Object)detailEl);
            try {
                Constructor<? extends Exception> constructor = exceptionClass.getConstructor(String.class, detail.getClass());
                return constructor.newInstance(message, detail);
            }
            catch (NoSuchMethodException e) {
                return messageConstructor.newInstance(message);
            }
        }
        catch (Exception e) {
            throw new RuntimeCamelException((Throwable)e);
        }
    }

    @Override
    public String getSoapPackageName() {
        return SOAP_PACKAGE_NAME;
    }
}

