/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.concurrent.config;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.google.inject.AbstractModule;
import com.google.inject.Provides;
import java.io.Closeable;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.annotation.Resource;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jclouds.concurrent.DynamicExecutors;
import org.jclouds.concurrent.MoreExecutors;
import org.jclouds.concurrent.SingleThreaded;
import org.jclouds.concurrent.config.ConfiguresExecutorService;
import org.jclouds.lifecycle.Closer;
import org.jclouds.logging.Logger;

@ConfiguresExecutorService
public class ExecutorServiceModule
extends AbstractModule {
    @VisibleForTesting
    final ExecutorService userExecutorFromConstructor;
    @VisibleForTesting
    final ExecutorService ioExecutorFromConstructor;

    @Inject
    public ExecutorServiceModule(@Named(value="jclouds.user-threads") ExecutorService userThreads, @Named(value="jclouds.io-worker-threads") ExecutorService ioThreads) {
        this.userExecutorFromConstructor = ExecutorServiceModule.addToStringOnSubmit(ExecutorServiceModule.checkNotGuavaSameThreadExecutor(userThreads));
        this.ioExecutorFromConstructor = ExecutorServiceModule.addToStringOnSubmit(ExecutorServiceModule.checkNotGuavaSameThreadExecutor(ioThreads));
    }

    static ExecutorService addToStringOnSubmit(ExecutorService executor) {
        if (executor != null) {
            return new DescribingExecutorService(executor);
        }
        return executor;
    }

    static ExecutorService checkNotGuavaSameThreadExecutor(ExecutorService executor) {
        if (executor != null && !executor.getClass().isAnnotationPresent(SingleThreaded.class) && executor.getClass().getSimpleName().indexOf("SameThread") != -1) {
            Logger.CONSOLE.warn("please switch from %s to %s or annotate your same threaded executor with @SingleThreaded", executor.getClass().getName(), MoreExecutors.SameThreadExecutorService.class.getName());
            return MoreExecutors.sameThreadExecutor();
        }
        return executor;
    }

    public ExecutorServiceModule() {
        this(null, null);
    }

    protected void configure() {
    }

    @Provides
    @Singleton
    @Named(value="jclouds.user-threads")
    ExecutorService provideExecutorService(@Named(value="jclouds.user-threads") int count, Closer closer) {
        if (this.userExecutorFromConstructor != null) {
            return this.userExecutorFromConstructor;
        }
        return ExecutorServiceModule.shutdownOnClose(ExecutorServiceModule.addToStringOnSubmit(ExecutorServiceModule.newThreadPoolNamed("user thread %d", count)), closer);
    }

    @Provides
    @Singleton
    @Named(value="jclouds.io-worker-threads")
    ExecutorService provideIOExecutor(@Named(value="jclouds.io-worker-threads") int count, Closer closer) {
        if (this.ioExecutorFromConstructor != null) {
            return this.ioExecutorFromConstructor;
        }
        return ExecutorServiceModule.shutdownOnClose(ExecutorServiceModule.addToStringOnSubmit(ExecutorServiceModule.newThreadPoolNamed("i/o thread %d", count)), closer);
    }

    @VisibleForTesting
    static ExecutorService shutdownOnClose(ExecutorService service, Closer closer) {
        closer.addToClose(new ShutdownExecutorOnClose(service));
        return service;
    }

    @VisibleForTesting
    static ExecutorService newCachedThreadPoolNamed(String name) {
        return Executors.newCachedThreadPool(new ThreadFactoryBuilder().setNameFormat(name).setThreadFactory(Executors.defaultThreadFactory()).build());
    }

    @VisibleForTesting
    static ExecutorService newThreadPoolNamed(String name, int maxCount) {
        return maxCount == 0 ? ExecutorServiceModule.newCachedThreadPoolNamed(name) : ExecutorServiceModule.newScalingThreadPoolNamed(name, maxCount);
    }

    @VisibleForTesting
    static ExecutorService newScalingThreadPoolNamed(String name, int maxCount) {
        return DynamicExecutors.newScalingThreadPool(1, maxCount, 60000L, new ThreadFactoryBuilder().setNameFormat(name).setThreadFactory(Executors.defaultThreadFactory()).build());
    }

    static StackTraceElement[] getStackTraceHere() {
        StackTraceElement[] fullSubmissionTrace = Thread.currentThread().getStackTrace();
        StackTraceElement[] cleanedSubmissionTrace = new StackTraceElement[fullSubmissionTrace.length - 2];
        System.arraycopy(fullSubmissionTrace, 2, cleanedSubmissionTrace, 0, cleanedSubmissionTrace.length);
        return cleanedSubmissionTrace;
    }

    static class DescribedFuture<T>
    implements Future<T> {
        private final Future<T> delegate;
        private final String description;
        private StackTraceElement[] submissionTrace;

        public DescribedFuture(Future<T> delegate, String description, StackTraceElement[] submissionTrace) {
            this.delegate = delegate;
            this.description = description;
            this.submissionTrace = submissionTrace;
        }

        @Override
        public boolean cancel(boolean arg0) {
            return this.delegate.cancel(arg0);
        }

        @Override
        public T get() throws InterruptedException, ExecutionException {
            try {
                return this.delegate.get();
            }
            catch (ExecutionException e) {
                throw this.ensureCauseHasSubmissionTrace(e);
            }
            catch (InterruptedException e) {
                throw this.ensureCauseHasSubmissionTrace(e);
            }
        }

        @Override
        public T get(long arg0, TimeUnit arg1) throws InterruptedException, ExecutionException, TimeoutException {
            try {
                return this.delegate.get(arg0, arg1);
            }
            catch (ExecutionException e) {
                throw this.ensureCauseHasSubmissionTrace(e);
            }
            catch (InterruptedException e) {
                throw this.ensureCauseHasSubmissionTrace(e);
            }
            catch (TimeoutException e) {
                throw this.ensureCauseHasSubmissionTrace(e);
            }
        }

        private <ET extends Exception> ET ensureCauseHasSubmissionTrace(ET e) {
            if (this.submissionTrace == null) {
                return e;
            }
            if (e.getCause() == null) {
                ExecutionException ee = new ExecutionException("task submitted from the following trace", null);
                e.initCause(ee);
                return e;
            }
            Throwable cause = e.getCause();
            StackTraceElement[] causeTrace = cause.getStackTrace();
            boolean causeIncludesSubmissionTrace = this.submissionTrace.length >= causeTrace.length;
            for (int i = 0; causeIncludesSubmissionTrace && i < this.submissionTrace.length; ++i) {
                if (causeTrace[causeTrace.length - 1 - i].equals(this.submissionTrace[this.submissionTrace.length - 1 - i])) continue;
                causeIncludesSubmissionTrace = false;
            }
            if (!causeIncludesSubmissionTrace) {
                cause.setStackTrace(this.merge(causeTrace, this.submissionTrace));
            }
            return e;
        }

        private StackTraceElement[] merge(StackTraceElement[] t1, StackTraceElement[] t2) {
            StackTraceElement[] t12 = new StackTraceElement[t1.length + t2.length];
            System.arraycopy(t1, 0, t12, 0, t1.length);
            System.arraycopy(t2, 0, t12, t1.length, t2.length);
            return t12;
        }

        @Override
        public boolean isCancelled() {
            return this.delegate.isCancelled();
        }

        @Override
        public boolean isDone() {
            return this.delegate.isDone();
        }

        public boolean equals(Object obj) {
            return this.delegate.equals(obj);
        }

        public int hashCode() {
            return this.delegate.hashCode();
        }

        public String toString() {
            return this.description;
        }
    }

    static class DescribingExecutorService
    implements ExecutorService {
        private final ExecutorService delegate;

        public DescribingExecutorService(ExecutorService delegate) {
            this.delegate = (ExecutorService)Preconditions.checkNotNull((Object)delegate, (Object)"delegate");
        }

        @Override
        public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
            return this.delegate.awaitTermination(timeout, unit);
        }

        @Override
        public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks) throws InterruptedException {
            return this.delegate.invokeAll(tasks);
        }

        @Override
        public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException {
            return this.delegate.invokeAll(tasks, timeout, unit);
        }

        @Override
        public <T> T invokeAny(Collection<? extends Callable<T>> tasks) throws InterruptedException, ExecutionException {
            return this.delegate.invokeAny(tasks);
        }

        @Override
        public <T> T invokeAny(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            return this.delegate.invokeAny(tasks, timeout, unit);
        }

        @Override
        public boolean isShutdown() {
            return this.delegate.isShutdown();
        }

        @Override
        public boolean isTerminated() {
            return this.delegate.isTerminated();
        }

        @Override
        public void shutdown() {
            this.delegate.shutdown();
        }

        @Override
        public List<Runnable> shutdownNow() {
            return this.delegate.shutdownNow();
        }

        @Override
        public <T> Future<T> submit(Callable<T> task) {
            return new DescribedFuture<T>(this.delegate.submit(task), task.toString(), ExecutorServiceModule.getStackTraceHere());
        }

        @Override
        public Future<?> submit(Runnable task) {
            return new DescribedFuture(this.delegate.submit(task), task.toString(), ExecutorServiceModule.getStackTraceHere());
        }

        @Override
        public <T> Future<T> submit(Runnable task, T result) {
            return new DescribedFuture<T>(this.delegate.submit(task, result), task.toString(), ExecutorServiceModule.getStackTraceHere());
        }

        @Override
        public void execute(Runnable arg0) {
            this.delegate.execute(arg0);
        }

        public boolean equals(Object obj) {
            return this.delegate.equals(obj);
        }

        public int hashCode() {
            return this.delegate.hashCode();
        }

        public String toString() {
            return this.delegate.toString();
        }
    }

    @VisibleForTesting
    static final class ShutdownExecutorOnClose
    implements Closeable {
        @Resource
        protected Logger logger = Logger.NULL;
        private final ExecutorService service;

        private ShutdownExecutorOnClose(ExecutorService service) {
            this.service = service;
        }

        @Override
        public void close() throws IOException {
            List<Runnable> runnables = this.service.shutdownNow();
            if (runnables.size() > 0) {
                this.logger.warn("when shutting down executor %s, runnables outstanding: %s", this.service, runnables);
            }
        }
    }
}

