/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.date.internal;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.SimpleTimeZone;
import org.jclouds.date.DateService;
import org.jclouds.date.internal.DateUtils;

public class SimpleDateFormatDateService
implements DateService {
    private static final SimpleDateFormat iso8601SecondsSimpleDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'", Locale.US);
    private static final SimpleDateFormat iso8601SimpleDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'", Locale.US);
    private static final SimpleDateFormat rfc822SimpleDateFormat = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss z", Locale.US);
    private static final SimpleDateFormat cSimpleDateFormat = new SimpleDateFormat("EEE MMM dd HH:mm:ss '+0000' yyyy", Locale.US);

    @Override
    public final Date fromSeconds(long seconds) {
        return new Date(seconds * 1000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final String cDateFormat(Date date) {
        SimpleDateFormat simpleDateFormat = cSimpleDateFormat;
        synchronized (simpleDateFormat) {
            return cSimpleDateFormat.format(date);
        }
    }

    @Override
    public final String cDateFormat() {
        return this.cDateFormat(new Date());
    }

    @Override
    public final Date cDateParse(String toParse) {
        SimpleDateFormat simpleDateFormat = cSimpleDateFormat;
        synchronized (simpleDateFormat) {
            try {
                return cSimpleDateFormat.parse(toParse);
            }
            catch (ParseException e) {
                throw new RuntimeException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final String rfc822DateFormat(Date date) {
        SimpleDateFormat simpleDateFormat = rfc822SimpleDateFormat;
        synchronized (simpleDateFormat) {
            return rfc822SimpleDateFormat.format(date);
        }
    }

    @Override
    public final String rfc822DateFormat() {
        return this.rfc822DateFormat(new Date());
    }

    @Override
    public final Date rfc822DateParse(String toParse) {
        SimpleDateFormat simpleDateFormat = rfc822SimpleDateFormat;
        synchronized (simpleDateFormat) {
            try {
                return rfc822SimpleDateFormat.parse(toParse);
            }
            catch (ParseException e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    public final String iso8601SecondsDateFormat() {
        return this.iso8601SecondsDateFormat(new Date());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final String iso8601DateFormat(Date date) {
        SimpleDateFormat simpleDateFormat = iso8601SimpleDateFormat;
        synchronized (simpleDateFormat) {
            return iso8601SimpleDateFormat.format(date);
        }
    }

    @Override
    public final String iso8601DateFormat() {
        return this.iso8601DateFormat(new Date());
    }

    @Override
    public final Date iso8601DateParse(String toParse) {
        toParse = DateUtils.trimTZ(toParse);
        toParse = DateUtils.trimToMillis(toParse);
        SimpleDateFormat simpleDateFormat = iso8601SimpleDateFormat;
        synchronized (simpleDateFormat) {
            try {
                return iso8601SimpleDateFormat.parse(toParse);
            }
            catch (ParseException e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    public final Date iso8601SecondsDateParse(String toParse) {
        toParse = DateUtils.trimTZ(toParse);
        SimpleDateFormat simpleDateFormat = iso8601SecondsSimpleDateFormat;
        synchronized (simpleDateFormat) {
            try {
                return iso8601SecondsSimpleDateFormat.parse(toParse);
            }
            catch (ParseException e) {
                throw new RuntimeException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String iso8601SecondsDateFormat(Date date) {
        SimpleDateFormat simpleDateFormat = iso8601SecondsSimpleDateFormat;
        synchronized (simpleDateFormat) {
            return iso8601SecondsSimpleDateFormat.format(date);
        }
    }

    static {
        iso8601SimpleDateFormat.setTimeZone(new SimpleTimeZone(0, "GMT"));
        iso8601SecondsSimpleDateFormat.setTimeZone(new SimpleTimeZone(0, "GMT"));
        rfc822SimpleDateFormat.setTimeZone(new SimpleTimeZone(0, "GMT"));
        cSimpleDateFormat.setTimeZone(new SimpleTimeZone(0, "GMT"));
    }
}

