/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.domain.internal;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.io.Serializable;
import java.util.Map;
import java.util.Set;
import org.jclouds.domain.Location;
import org.jclouds.domain.LocationScope;
import org.jclouds.javax.annotation.Nullable;

public class LocationImpl
implements Location,
Serializable {
    private static final long serialVersionUID = -280558162576368264L;
    private final LocationScope scope;
    private final String id;
    private final String description;
    private final Location parent;
    private final Set<String> iso3166Codes;
    private final Map<String, Object> metadata;

    public LocationImpl(LocationScope scope, String id, String description, @Nullable Location parent, Iterable<String> iso3166Codes, Map<String, Object> metadata) {
        this.scope = (LocationScope)((Object)Preconditions.checkNotNull((Object)((Object)scope), (Object)"scope"));
        this.id = (String)Preconditions.checkNotNull((Object)id, (Object)"id");
        this.description = (String)Preconditions.checkNotNull((Object)description, (Object)"description");
        this.metadata = ImmutableMap.copyOf((Map)((Map)Preconditions.checkNotNull(metadata, (Object)"metadata")));
        this.iso3166Codes = ImmutableSet.copyOf((Iterable)((Iterable)Preconditions.checkNotNull(iso3166Codes, (Object)"iso3166Codes")));
        this.parent = parent;
    }

    @Override
    public LocationScope getScope() {
        return this.scope;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public Location getParent() {
        return this.parent;
    }

    @Override
    public Set<String> getIso3166Codes() {
        return this.iso3166Codes;
    }

    @Override
    public Map<String, Object> getMetadata() {
        return this.metadata;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.description == null ? 0 : this.description.hashCode());
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        result = 31 * result + (this.iso3166Codes == null ? 0 : ((Object)this.iso3166Codes).hashCode());
        result = 31 * result + (this.metadata == null ? 0 : ((Object)this.metadata).hashCode());
        result = 31 * result + (this.parent == null ? 0 : this.parent.hashCode());
        result = 31 * result + (this.scope == null ? 0 : this.scope.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        LocationImpl other = (LocationImpl)obj;
        if (this.description == null ? other.description != null : !this.description.equals(other.description)) {
            return false;
        }
        if (this.id == null ? other.id != null : !this.id.equals(other.id)) {
            return false;
        }
        if (this.iso3166Codes == null ? other.iso3166Codes != null : !((Object)this.iso3166Codes).equals(other.iso3166Codes)) {
            return false;
        }
        if (this.metadata == null ? other.metadata != null : !((Object)this.metadata).equals(other.metadata)) {
            return false;
        }
        if (this.parent == null ? other.parent != null : !this.parent.equals(other.parent)) {
            return false;
        }
        return !(this.scope == null ? other.scope != null : !this.scope.equals((Object)other.scope));
    }

    public String toString() {
        return "[id=" + this.id + ", scope=" + (Object)((Object)this.scope) + ", description=" + this.description + ", parent=" + (this.parent == null ? null : this.parent.getId()) + ", iso3166Codes=" + this.iso3166Codes + ", metadata=" + this.metadata + "]";
    }
}

