/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.domain.internal;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.io.Serializable;
import java.net.URI;
import java.util.Map;
import org.jclouds.domain.Location;
import org.jclouds.domain.ResourceMetadata;
import org.jclouds.javax.annotation.Nullable;

public abstract class ResourceMetadataImpl<T extends Enum<T>>
implements ResourceMetadata<T>,
Serializable {
    private static final long serialVersionUID = -280558162576368264L;
    @Nullable
    private final String providerId;
    @Nullable
    private final String name;
    @Nullable
    private final Location location;
    @Nullable
    private final URI uri;
    private final Map<String, String> userMetadata = Maps.newLinkedHashMap();

    public ResourceMetadataImpl(@Nullable String providerId, @Nullable String name, @Nullable Location location, @Nullable URI uri, Map<String, String> userMetadata) {
        this.providerId = providerId;
        this.name = name;
        this.location = location;
        this.uri = uri;
        this.userMetadata.putAll((Map)Preconditions.checkNotNull(userMetadata, (Object)"userMetadata"));
    }

    @Override
    public int compareTo(ResourceMetadata<T> o) {
        if (this.getName() == null) {
            return -1;
        }
        return this == o ? 0 : this.getName().compareTo(o.getName());
    }

    @Override
    public String getProviderId() {
        return this.providerId;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Location getLocation() {
        return this.location;
    }

    @Override
    public URI getUri() {
        return this.uri;
    }

    @Override
    public Map<String, String> getUserMetadata() {
        return this.userMetadata;
    }

    public String toString() {
        return "[type=" + this.getType() + ", providerId=" + this.providerId + ", name=" + this.name + ", location=" + this.location + ", uri=" + this.uri + ", userMetadata=" + this.userMetadata + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.providerId == null ? 0 : this.providerId.hashCode());
        result = 31 * result + (this.location == null ? 0 : this.location.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.uri == null ? 0 : this.uri.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ResourceMetadataImpl other = (ResourceMetadataImpl)obj;
        if (this.providerId == null ? other.providerId != null : !this.providerId.equals(other.providerId)) {
            return false;
        }
        if (this.location == null ? other.location != null : !this.location.equals(other.location)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        return !(this.uri == null ? other.uri != null : !this.uri.equals(other.uri));
    }
}

