/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.io;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Map;
import org.jclouds.crypto.CryptoStreams;
import org.jclouds.io.ContentMetadata;
import org.jclouds.io.payloads.BaseImmutableContentMetadata;
import org.jclouds.javax.annotation.Nullable;

public class ContentMetadataBuilder
implements Serializable {
    private static final long serialVersionUID = -5279643002875371558L;
    protected String contentType = "application/unknown";
    protected Long contentLength;
    protected byte[] contentMD5;
    protected String contentDisposition;
    protected String contentLanguage;
    protected String contentEncoding;

    public static ContentMetadataBuilder create() {
        return new ContentMetadataBuilder();
    }

    public ContentMetadataBuilder fromHttpHeaders(Multimap<String, String> headers) {
        boolean chunked = Iterables.any((Iterable)headers.entries(), (Predicate)new Predicate<Map.Entry<String, String>>(){

            public boolean apply(Map.Entry<String, String> input) {
                return "Transfer-Encoding".equalsIgnoreCase(input.getKey()) && "chunked".equalsIgnoreCase(input.getValue());
            }
        });
        for (Map.Entry header : headers.entries()) {
            if (!chunked && "Content-Length".equalsIgnoreCase((String)header.getKey())) {
                this.contentLength(new Long((String)header.getValue()));
                continue;
            }
            if ("Content-MD5".equalsIgnoreCase((String)header.getKey())) {
                this.contentMD5(CryptoStreams.base64((String)header.getValue()));
                continue;
            }
            if ("Content-Type".equalsIgnoreCase((String)header.getKey())) {
                this.contentType((String)header.getValue());
                continue;
            }
            if ("Content-Disposition".equalsIgnoreCase((String)header.getKey())) {
                this.contentDisposition((String)header.getValue());
                continue;
            }
            if ("Content-Encoding".equalsIgnoreCase((String)header.getKey())) {
                this.contentEncoding((String)header.getValue());
                continue;
            }
            if (!"Content-Language".equalsIgnoreCase((String)header.getKey())) continue;
            this.contentLanguage((String)header.getValue());
        }
        return this;
    }

    public ContentMetadataBuilder contentLength(@Nullable Long contentLength) {
        this.contentLength = contentLength;
        return this;
    }

    public ContentMetadataBuilder contentMD5(byte[] md5) {
        if (md5 != null) {
            byte[] retval = new byte[md5.length];
            System.arraycopy(md5, 0, retval, 0, md5.length);
            this.contentMD5 = md5;
        }
        return this;
    }

    public ContentMetadataBuilder contentType(@Nullable String contentType) {
        this.contentType = contentType;
        return this;
    }

    public ContentMetadataBuilder contentDisposition(@Nullable String contentDisposition) {
        this.contentDisposition = contentDisposition;
        return this;
    }

    public ContentMetadataBuilder contentLanguage(@Nullable String contentLanguage) {
        this.contentLanguage = contentLanguage;
        return this;
    }

    public ContentMetadataBuilder contentEncoding(@Nullable String contentEncoding) {
        this.contentEncoding = contentEncoding;
        return this;
    }

    public ContentMetadata build() {
        return new BaseImmutableContentMetadata(this.contentType, this.contentLength, this.contentMD5, this.contentDisposition, this.contentLanguage, this.contentEncoding);
    }

    public static ContentMetadataBuilder fromContentMetadata(ContentMetadata in) {
        return new ContentMetadataBuilder().contentType(in.getContentType()).contentLength(in.getContentLength()).contentMD5(in.getContentMD5()).contentDisposition(in.getContentDisposition()).contentLanguage(in.getContentLanguage()).contentEncoding(in.getContentEncoding());
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.contentDisposition == null ? 0 : this.contentDisposition.hashCode());
        result = 31 * result + (this.contentEncoding == null ? 0 : this.contentEncoding.hashCode());
        result = 31 * result + (this.contentLanguage == null ? 0 : this.contentLanguage.hashCode());
        result = 31 * result + (this.contentLength == null ? 0 : this.contentLength.hashCode());
        result = 31 * result + Arrays.hashCode(this.contentMD5);
        result = 31 * result + (this.contentType == null ? 0 : this.contentType.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ContentMetadataBuilder other = (ContentMetadataBuilder)obj;
        if (this.contentDisposition == null ? other.contentDisposition != null : !this.contentDisposition.equals(other.contentDisposition)) {
            return false;
        }
        if (this.contentEncoding == null ? other.contentEncoding != null : !this.contentEncoding.equals(other.contentEncoding)) {
            return false;
        }
        if (this.contentLanguage == null ? other.contentLanguage != null : !this.contentLanguage.equals(other.contentLanguage)) {
            return false;
        }
        if (this.contentLength == null ? other.contentLength != null : !this.contentLength.equals(other.contentLength)) {
            return false;
        }
        if (!Arrays.equals(this.contentMD5, other.contentMD5)) {
            return false;
        }
        return !(this.contentType == null ? other.contentType != null : !this.contentType.equals(other.contentType));
    }

    public String toString() {
        return "[contentDisposition=" + this.contentDisposition + ", contentEncoding=" + this.contentEncoding + ", contentLanguage=" + this.contentLanguage + ", contentLength=" + this.contentLength + ", contentMD5=" + Arrays.toString(this.contentMD5) + ", contentType=" + this.contentType + "]";
    }
}

