/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.io;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.Multimap;
import com.google.common.io.ByteStreams;
import com.google.common.io.InputSupplier;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Comparator;
import java.util.Map;
import org.jclouds.crypto.CryptoStreams;
import org.jclouds.io.MutableContentMetadata;
import org.jclouds.io.Payload;
import org.jclouds.io.PayloadEnclosing;
import org.jclouds.io.payloads.ByteArrayPayload;
import org.jclouds.io.payloads.FilePayload;
import org.jclouds.io.payloads.InputStreamPayload;
import org.jclouds.io.payloads.StringPayload;
import org.jclouds.io.payloads.UrlEncodedFormPayload;
import org.jclouds.javax.annotation.Nullable;

public class Payloads {
    private Payloads() {
    }

    public static Payload newPayload(Object data) {
        Preconditions.checkNotNull((Object)data, (Object)"data");
        if (data instanceof Payload) {
            return (Payload)data;
        }
        if (data instanceof InputStream) {
            return Payloads.newInputStreamPayload((InputStream)data);
        }
        if (data instanceof byte[]) {
            return Payloads.newByteArrayPayload((byte[])data);
        }
        if (data instanceof String) {
            return Payloads.newStringPayload((String)data);
        }
        if (data instanceof File) {
            return Payloads.newFilePayload((File)data);
        }
        throw new UnsupportedOperationException("unsupported payload type: " + data.getClass());
    }

    public static InputStreamPayload newInputStreamPayload(InputStream data) {
        return new InputStreamPayload((InputStream)Preconditions.checkNotNull((Object)data, (Object)"data"));
    }

    public static ByteArrayPayload newByteArrayPayload(byte[] data) {
        return new ByteArrayPayload((byte[])Preconditions.checkNotNull((Object)data, (Object)"data"));
    }

    public static StringPayload newStringPayload(String data) {
        return new StringPayload((String)Preconditions.checkNotNull((Object)data, (Object)"data"));
    }

    public static FilePayload newFilePayload(File data) {
        return new FilePayload((File)Preconditions.checkNotNull((Object)data, (Object)"data"));
    }

    public static UrlEncodedFormPayload newUrlEncodedFormPayload(Multimap<String, String> formParams, char ... skips) {
        return new UrlEncodedFormPayload(formParams, skips);
    }

    public static UrlEncodedFormPayload newUrlEncodedFormPayload(Multimap<String, String> formParams, @Nullable Comparator<Map.Entry<String, String>> sorter, char ... skips) {
        return new UrlEncodedFormPayload(formParams, sorter, skips);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Payload calculateMD5(Payload payload, MessageDigest md5) throws IOException {
        Preconditions.checkNotNull((Object)payload, (Object)"payload");
        if (!payload.isRepeatable()) {
            MutableContentMetadata oldContentMetadata = payload.getContentMetadata();
            Payload oldPayload = payload;
            try {
                payload = Payloads.newByteArrayPayload(ByteStreams.toByteArray((InputSupplier)payload));
            }
            finally {
                oldPayload.release();
            }
            oldContentMetadata.setContentLength(payload.getContentMetadata().getContentLength());
            oldContentMetadata.setContentMD5(payload.getContentMetadata().getContentMD5());
            payload.setContentMetadata(oldContentMetadata);
        }
        payload.getContentMetadata().setContentMD5(CryptoStreams.digest(payload, md5));
        return payload;
    }

    public static Payload calculateMD5(Payload payload) throws IOException {
        try {
            return Payloads.calculateMD5(payload, MessageDigest.getInstance("MD5"));
        }
        catch (NoSuchAlgorithmException e) {
            Throwables.propagate((Throwable)e);
            return null;
        }
    }

    public static <T extends PayloadEnclosing> T calculateMD5(T payloadEnclosing, MessageDigest md5) throws IOException {
        Preconditions.checkState((payloadEnclosing != null ? 1 : 0) != 0, (Object)"payloadEnclosing");
        Payload newPayload = Payloads.calculateMD5(payloadEnclosing.getPayload(), md5);
        if (newPayload != payloadEnclosing.getPayload()) {
            payloadEnclosing.setPayload(newPayload);
        }
        return payloadEnclosing;
    }

    public static <T extends PayloadEnclosing> T calculateMD5(T payloadEnclosing) throws IOException {
        try {
            return Payloads.calculateMD5(payloadEnclosing, MessageDigest.getInstance("MD5"));
        }
        catch (NoSuchAlgorithmException e) {
            Throwables.propagate((Throwable)e);
            return null;
        }
    }
}

