/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.io.internal;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.io.ByteStreams;
import com.google.common.io.InputSupplier;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import javax.inject.Singleton;
import org.jclouds.io.InputSuppliers;
import org.jclouds.io.Payload;
import org.jclouds.io.PayloadSlicer;
import org.jclouds.io.payloads.BaseMutableContentMetadata;
import org.jclouds.io.payloads.InputStreamSupplierPayload;

@Singleton
public class BasePayloadSlicer
implements PayloadSlicer {
    @Override
    public Payload slice(Payload input, long offset, long length) {
        Preconditions.checkNotNull((Object)input);
        Preconditions.checkArgument((offset >= 0L ? 1 : 0) != 0, (Object)"offset is negative");
        Preconditions.checkArgument((length >= 0L ? 1 : 0) != 0, (Object)"length is negative");
        Payload returnVal = input.getRawContent() instanceof File ? this.doSlice((File)input.getRawContent(), offset, length) : (input.getRawContent() instanceof String ? this.doSlice((byte[])input.getRawContent(), offset, length) : (input.getRawContent() instanceof byte[] ? this.doSlice((byte[])input.getRawContent(), offset, length) : this.doSlice(input.getInput(), offset, length)));
        return this.copyMetadataAndSetLength(input, returnVal, length);
    }

    protected Payload doSlice(Payload content, long offset, long length) {
        return new InputStreamSupplierPayload((InputSupplier<? extends InputStream>)ByteStreams.slice((InputSupplier)content, (long)offset, (long)length));
    }

    protected Payload doSlice(String content, long offset, long length) {
        return this.doSlice(content.getBytes(), offset, length);
    }

    protected Payload doSlice(File content, long offset, long length) {
        try {
            return this.doSlice(new FileInputStream(content), offset, length);
        }
        catch (FileNotFoundException e) {
            Throwables.propagate((Throwable)e);
            return null;
        }
    }

    protected Payload doSlice(InputStream content, long offset, long length) {
        return new InputStreamSupplierPayload((InputSupplier<? extends InputStream>)ByteStreams.slice(InputSuppliers.of(content), (long)offset, (long)length));
    }

    protected Payload doSlice(byte[] content, long offset, long length) {
        Preconditions.checkArgument((offset <= Integer.MAX_VALUE ? 1 : 0) != 0, (Object)"offset is too big for an array");
        Preconditions.checkArgument((length <= Integer.MAX_VALUE ? 1 : 0) != 0, (Object)"length is too big for an array");
        InputStreamSupplierPayload returnVal = new InputStreamSupplierPayload((InputSupplier<? extends InputStream>)ByteStreams.newInputStreamSupplier((byte[])content, (int)((int)offset), (int)((int)length)));
        return returnVal;
    }

    protected Payload copyMetadataAndSetLength(Payload input, Payload returnVal, long length) {
        returnVal.setContentMetadata(BaseMutableContentMetadata.fromContentMetadata(input.getContentMetadata().toBuilder().contentLength(length).contentMD5(null).build()));
        return returnVal;
    }
}

