/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.io.payloads;

import com.google.common.base.Throwables;
import com.google.common.collect.Lists;
import com.google.common.io.Closeables;
import com.google.common.io.InputSupplier;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.jclouds.io.payloads.BasePayload;

public class InputStreamSupplierPayload
extends BasePayload<InputSupplier<? extends InputStream>> {
    private List<InputStream> toClose = Lists.newArrayList();

    public InputStreamSupplierPayload(InputSupplier<? extends InputStream> content) {
        super(content);
    }

    @Override
    public InputStream getInput() {
        try {
            InputStream returnVal = (InputStream)((InputSupplier)this.content).getInput();
            this.toClose.add(returnVal);
            return returnVal;
        }
        catch (IOException e) {
            Throwables.propagate((Throwable)e);
            return null;
        }
    }

    @Override
    public boolean isRepeatable() {
        return true;
    }

    @Override
    public void release() {
        if (this.toClose.size() > 0) {
            InputStream content = this.toClose.remove(0);
            while (this.toClose.size() > 0) {
                Closeables.closeQuietly((Closeable)content);
                content = this.toClose.remove(0);
            }
        }
    }
}

