/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.location.config;

import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Multimap;
import com.google.inject.ConfigurationException;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.name.Names;
import java.lang.annotation.Annotation;
import java.net.URI;
import java.util.Map;
import javax.annotation.Resource;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.jclouds.location.Region;
import org.jclouds.logging.Logger;

@Singleton
public class ProvideRegionToURIViaProperties
implements Provider<Map<String, URI>> {
    private final Injector injector;
    private final Multimap<String, String> constants;
    @Resource
    protected Logger logger = Logger.NULL;

    @Inject
    protected ProvideRegionToURIViaProperties(Injector injector, @Named(value="CONSTANTS") Multimap<String, String> constants) {
        this.injector = injector;
        this.constants = constants;
    }

    @Singleton
    @Region
    public Map<String, URI> get() {
        try {
            String regionString = (String)this.injector.getInstance(Key.get(String.class, (Annotation)Names.named((String)"jclouds.regions")));
            ImmutableMap.Builder regions = ImmutableMap.builder();
            for (String region : Splitter.on((char)',').split((CharSequence)regionString)) {
                String regionUri = (String)this.injector.getInstance(Key.get(String.class, (Annotation)Names.named((String)("jclouds.region." + region + "." + "endpoint"))));
                for (Map.Entry entry : this.constants.entries()) {
                    regionUri = regionUri.replace('{' + (String)entry.getKey() + '}', (CharSequence)entry.getValue());
                }
                regions.put((Object)region, (Object)URI.create(regionUri));
            }
            return regions.build();
        }
        catch (ConfigurationException e) {
            this.logger.warn("no region name to endpoint mappings configured!", new Object[0]);
            return ImmutableMap.of();
        }
    }
}

