/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.location.config;

import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableMap;
import com.google.inject.ConfigurationException;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.name.Names;
import java.lang.annotation.Annotation;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.jclouds.location.Region;
import org.jclouds.location.Zone;

@Singleton
public class ProvideZonesViaProperties
implements Provider<Map<String, String>> {
    private final Injector injector;
    private final Set<String> regions;

    @Inject
    ProvideZonesViaProperties(Injector injector, @Region Set<String> regions) {
        this.injector = injector;
        this.regions = regions;
    }

    @Singleton
    @Zone
    public Map<String, String> get() {
        try {
            ImmutableMap.Builder zones = ImmutableMap.builder();
            for (String region : this.regions) {
                for (String zone : Splitter.on((char)',').split((CharSequence)this.injector.getInstance(Key.get(String.class, (Annotation)Names.named((String)("jclouds.region." + region + ".zones")))))) {
                    zones.put((Object)zone, (Object)region);
                }
            }
            return zones.build();
        }
        catch (ConfigurationException e) {
            return ImmutableMap.of();
        }
    }
}

