/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.location.functions;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import java.net.URI;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.location.Provider;
import org.jclouds.location.Region;

@Singleton
public class RegionToEndpointOrProviderIfNull
implements Function<Object, URI> {
    private final URI defaultUri;
    private final String defaultProvider;
    private final Map<String, URI> regionToEndpoint;

    @Inject
    public RegionToEndpointOrProviderIfNull(@Provider String defaultProvider, @Provider URI defaultUri, @Region Map<String, URI> regionToEndpoint) {
        this.defaultProvider = (String)Preconditions.checkNotNull((Object)defaultProvider, (Object)"defaultProvider");
        this.defaultUri = (URI)Preconditions.checkNotNull((Object)defaultUri, (Object)"defaultUri");
        this.regionToEndpoint = (Map)Preconditions.checkNotNull(regionToEndpoint, (Object)"regionToEndpoint");
    }

    public URI apply(@Nullable Object from) {
        if (from == null || from.equals(this.defaultProvider)) {
            return this.defaultUri;
        }
        Preconditions.checkArgument((boolean)(from instanceof String), (Object)"region is a String argument");
        Preconditions.checkArgument((boolean)this.regionToEndpoint.containsKey(from), (String)"requested location %s, which is not in the configured locations: %s", (Object[])new Object[]{from, this.regionToEndpoint});
        return this.regionToEndpoint.get(from);
    }
}

