/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.location.functions;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import java.net.URI;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.location.Zone;

@Singleton
public class ZoneToEndpoint
implements Function<Object, URI> {
    private final Map<String, URI> zoneToEndpoint;

    @Inject
    public ZoneToEndpoint(@Zone Map<String, URI> zoneToEndpoint) {
        this.zoneToEndpoint = (Map)Preconditions.checkNotNull(zoneToEndpoint, (Object)"zoneToEndpoint");
        Preconditions.checkArgument((zoneToEndpoint.size() > 0 ? 1 : 0) != 0, (Object)"no zone name to endpoint mappings configured!");
    }

    public URI apply(@Nullable Object from) {
        Preconditions.checkArgument((from != null && from instanceof String ? 1 : 0) != 0, (Object)"you must specify a zone, as a String argument");
        return this.zoneToEndpoint.get(from);
    }
}

