/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.location.suppliers;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.net.URI;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.domain.Location;
import org.jclouds.domain.LocationBuilder;
import org.jclouds.domain.LocationScope;
import org.jclouds.location.Iso3166;
import org.jclouds.location.Provider;
import org.jclouds.location.Region;
import org.jclouds.location.suppliers.JustProvider;

@Singleton
public class RegionToProviderOrJustProvider
extends JustProvider {
    private final Set<String> regions;
    private final Map<String, Set<String>> isoCodesById;

    @Inject
    public RegionToProviderOrJustProvider(@Iso3166 Set<String> isoCodes, @Provider String providerName, @Provider URI endpoint, @Region Set<String> regions, @Iso3166 Map<String, Set<String>> isoCodesById) {
        super(providerName, endpoint, isoCodes);
        this.regions = (Set)Preconditions.checkNotNull(regions, (Object)"regions");
        this.isoCodesById = (Map)Preconditions.checkNotNull(isoCodesById, (Object)"isoCodesById");
    }

    @Override
    public Set<? extends Location> get() {
        return this.buildJustProviderOrRegions().build();
    }

    protected ImmutableSet.Builder<Location> buildJustProviderOrRegions() {
        ImmutableSet.Builder locations = ImmutableSet.builder();
        Location provider = (Location)Iterables.getOnlyElement((Iterable)super.get());
        if (this.regions.size() == 0) {
            return locations.add((Object)provider);
        }
        for (String region : this.regions) {
            LocationBuilder builder = new LocationBuilder().scope(LocationScope.REGION).id(region).description(region).parent(provider);
            if (this.isoCodesById.containsKey(region)) {
                builder.iso3166Codes((Iterable<String>)this.isoCodesById.get(region));
            }
            locations.add((Object)builder.build());
        }
        return locations;
    }
}

