/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.location.suppliers;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import java.net.URI;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.domain.Location;
import org.jclouds.domain.LocationBuilder;
import org.jclouds.domain.LocationScope;
import org.jclouds.location.Iso3166;
import org.jclouds.location.Provider;
import org.jclouds.location.Zone;
import org.jclouds.location.suppliers.RegionToProviderOrJustProvider;

@Singleton
public class ZoneToRegionToProviderOrJustProvider
extends RegionToProviderOrJustProvider {
    private final Map<String, String> zoneToRegion;
    private Map<String, Set<String>> isoCodesById;

    @Inject
    ZoneToRegionToProviderOrJustProvider(@Iso3166 Set<String> isoCodes, @Provider String providerName, @Provider URI endpoint, @Iso3166 Map<String, Set<String>> isoCodesById, @Zone Map<String, String> zoneToRegion) {
        super(isoCodes, providerName, endpoint, (Set<String>)ImmutableSet.copyOf(((Map)Preconditions.checkNotNull(zoneToRegion, (Object)"zoneToRegion")).values()), isoCodesById);
        this.zoneToRegion = zoneToRegion;
        this.isoCodesById = (Map)Preconditions.checkNotNull(isoCodesById, (Object)"isoCodesById");
    }

    @Override
    public Set<? extends Location> get() {
        ImmutableSet.Builder<Location> locations = this.buildJustProviderOrRegions();
        ImmutableMap idToLocation = Maps.uniqueIndex((Iterable)locations.build(), (Function)new Function<Location, String>(){

            public String apply(Location from) {
                return from.getId();
            }
        });
        if (this.zoneToRegion.size() == 1) {
            return locations.build();
        }
        for (String zone : this.zoneToRegion.keySet()) {
            Location parent = (Location)idToLocation.get((Object)this.zoneToRegion.get(zone));
            LocationBuilder builder = new LocationBuilder().scope(LocationScope.ZONE).id(zone).description(zone).parent(parent);
            if (this.isoCodesById.containsKey(zone)) {
                builder.iso3166Codes((Iterable<String>)this.isoCodesById.get(zone));
            } else if (parent.getScope() == LocationScope.REGION) {
                builder.iso3166Codes(parent.getIso3166Codes());
            }
            locations.add((Object)builder.build());
        }
        return locations.build();
    }
}

