/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.rest;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Splitter;
import com.google.common.base.Throwables;
import com.google.common.collect.Iterables;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import java.util.Properties;
import org.jclouds.PropertiesBuilder;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.rest.RestContextBuilder;
import org.jclouds.util.ClassLoadingUtils;
import org.jclouds.util.SaxUtils;

public class Providers {
    public static Iterable<String> getSupportedProviders() {
        return Providers.getSupportedProvidersOfType(RestContextBuilder.class);
    }

    public static Iterable<String> getSupportedProvidersOfType(Class<? extends RestContextBuilder> type) {
        Properties properties = new Properties();
        try {
            properties.load(SaxUtils.class.getResourceAsStream("/rest.properties"));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return Providers.getSupportedProvidersOfTypeInProperties(type, properties);
    }

    public static Iterable<String> getSupportedProvidersOfTypeInProperties(final Class<? extends RestContextBuilder> type, final Properties properties) {
        return Iterables.filter((Iterable)Iterables.transform((Iterable)Iterables.filter(properties.entrySet(), (Predicate)new Predicate<Map.Entry<Object, Object>>(){

            public boolean apply(Map.Entry<Object, Object> input) {
                String keyString = input.getKey().toString();
                return keyString.endsWith(".contextbuilder") || keyString.endsWith(".sync");
            }
        }), (Function)new Function<Map.Entry<Object, Object>, String>(){

            public String apply(Map.Entry<Object, Object> from) {
                String keyString = from.getKey().toString();
                try {
                    String provider = (String)Iterables.get((Iterable)Splitter.on((char)'.').split((CharSequence)keyString), (int)0);
                    Class clazz = Providers.resolveContextBuilderClass(provider, properties);
                    if (clazz != null && type.isAssignableFrom(clazz)) {
                        return provider;
                    }
                }
                catch (ClassNotFoundException e) {
                }
                catch (Exception e) {
                    Throwables.propagate((Throwable)e);
                }
                return null;
            }
        }), (Predicate)Predicates.notNull());
    }

    public static <S, A> Class<RestContextBuilder<S, A>> resolveContextBuilderClass(String provider, Properties properties) throws ClassNotFoundException, IllegalArgumentException, SecurityException, InstantiationException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        String contextBuilderClassName = properties.getProperty(provider + ".contextbuilder");
        String syncClassName = properties.getProperty(provider + ".sync");
        String asyncClassName = properties.getProperty(provider + ".async");
        if (syncClassName != null) {
            Preconditions.checkArgument((asyncClassName != null ? 1 : 0) != 0, (Object)("please configure async class for " + syncClassName));
            if (ClassLoadingUtils.loadClass(Providers.class, syncClassName) == null) {
                throw new ClassNotFoundException();
            }
            if (ClassLoadingUtils.loadClass(Providers.class, asyncClassName) == null) {
                throw new ClassNotFoundException();
            }
            return contextBuilderClassName != null ? ClassLoadingUtils.loadClass(Providers.class, contextBuilderClassName) : RestContextBuilder.class;
        }
        Preconditions.checkArgument((contextBuilderClassName != null ? 1 : 0) != 0, (Object)("please configure contextbuilder class for " + provider));
        return ClassLoadingUtils.loadClass(Providers.class, contextBuilderClassName);
    }

    public static <S, A> RestContextBuilder<S, A> initContextBuilder(Class<RestContextBuilder<S, A>> contextBuilderClass, @Nullable Class<S> sync, @Nullable Class<A> async, Properties properties) throws ClassNotFoundException, IllegalArgumentException, SecurityException, InstantiationException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        Preconditions.checkArgument((properties != null ? 1 : 0) != 0, (Object)("please configure properties for " + contextBuilderClass));
        try {
            return contextBuilderClass.getConstructor(Properties.class).newInstance(properties);
        }
        catch (NoSuchMethodException e) {
            Preconditions.checkArgument((sync != null ? 1 : 0) != 0, (Object)("please configure sync class for " + contextBuilderClass));
            Preconditions.checkArgument((async != null ? 1 : 0) != 0, (Object)("please configure async class for " + contextBuilderClass));
            return contextBuilderClass.getConstructor(sync.getClass(), async.getClass(), Properties.class).newInstance(sync, async, properties);
        }
    }

    public static Class<PropertiesBuilder> resolvePropertiesBuilderClass(String providerName, Properties props) throws ClassNotFoundException, InstantiationException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        String propertiesBuilderClassName = props.getProperty(providerName + ".propertiesbuilder", null);
        if (propertiesBuilderClassName != null) {
            return ClassLoadingUtils.loadClass(Providers.class, propertiesBuilderClassName);
        }
        return PropertiesBuilder.class;
    }
}

