/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.rest;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.inject.Module;
import java.util.Collections;
import org.jclouds.PropertiesBuilder;
import org.jclouds.rest.RestContextBuilder;

public class RestContextSpec<S, A> {
    protected final String provider;
    protected final String endpoint;
    protected final String apiVersion;
    protected final String buildVersion;
    protected final String iso3166Codes;
    protected final String identity;
    protected final String credential;
    protected final Class<S> sync;
    protected final Class<A> async;
    protected final Class<PropertiesBuilder> propertiesBuilderClass;
    protected final Class<RestContextBuilder<S, A>> contextBuilderClass;
    protected final Iterable<Module> modules;

    public RestContextSpec(String provider, String endpoint, String apiVersion, String buildVersion, String iso3166Codes, String identity, String credential, Class<S> sync, Class<A> async, Class<PropertiesBuilder> propertiesBuilderClass, Class<RestContextBuilder<S, A>> contextBuilderClass, Iterable<Module> modules) {
        this.provider = (String)Preconditions.checkNotNull((Object)provider, (Object)"provider");
        this.endpoint = endpoint;
        this.apiVersion = apiVersion;
        this.buildVersion = buildVersion;
        this.identity = identity;
        this.credential = credential;
        this.iso3166Codes = iso3166Codes;
        this.sync = sync;
        this.async = async;
        Preconditions.checkArgument((boolean)RestContextBuilder.class.isAssignableFrom(contextBuilderClass), (Object)(contextBuilderClass.getName() + " is not a subclass of " + RestContextBuilder.class.getName()));
        Preconditions.checkArgument((boolean)PropertiesBuilder.class.isAssignableFrom(propertiesBuilderClass), (Object)(propertiesBuilderClass.getName() + " is not a subclass of " + PropertiesBuilder.class.getName()));
        this.propertiesBuilderClass = propertiesBuilderClass;
        this.contextBuilderClass = contextBuilderClass;
        this.modules = ImmutableList.copyOf(modules);
    }

    public RestContextSpec(String provider, String endpoint, String apiVersion, String buildVersion, String iso3166Codes, String identity, String credential, Class<S> sync, Class<A> async) {
        this(provider, endpoint, apiVersion, buildVersion, iso3166Codes, identity, credential, sync, async, PropertiesBuilder.class, RestContextBuilder.class, Collections.EMPTY_LIST);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.provider, this.endpoint, this.apiVersion, this.buildVersion, this.iso3166Codes, this.identity, this.credential, this.sync, this.async, this.propertiesBuilderClass, this.contextBuilderClass, this.modules});
    }

    public boolean equals(Object that) {
        if (that == null) {
            return false;
        }
        return Objects.equal((Object)this.toString(), (Object)that.toString());
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("provider", (Object)this.provider).add("endpoint", (Object)this.endpoint).add("apiVersion", (Object)this.apiVersion).add("buildVersion", (Object)this.buildVersion).add("iso3166Codes", (Object)this.iso3166Codes).add("identity", (Object)this.identity).add("sync", this.sync).add("async", this.async).add("propertiesBuilderClass", this.propertiesBuilderClass).add("contextBuilderClass", this.contextBuilderClass).add("modules", this.modules).toString();
    }
}

