/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.rest.binders;

import com.google.common.base.Preconditions;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.ws.rs.core.UriBuilder;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.utils.ModifyRequest;
import org.jclouds.rest.Binder;

public class BindMapToMatrixParams
implements Binder {
    private final Provider<UriBuilder> builder;

    @Inject
    BindMapToMatrixParams(Provider<UriBuilder> builder) {
        this.builder = (Provider)Preconditions.checkNotNull(builder, (Object)"builder");
    }

    @Override
    public <R extends HttpRequest> R bindToRequest(R request, Object input) {
        Preconditions.checkArgument((boolean)(Preconditions.checkNotNull((Object)input, (Object)"input") instanceof Map), (Object)"this binder is only valid for Maps!");
        Map map = (Map)input;
        for (Map.Entry entry : map.entrySet()) {
            request = ModifyRequest.replaceMatrixParam(request, (String)entry.getKey(), entry.getValue(), (UriBuilder)this.builder.get());
        }
        return request;
    }
}

