/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.rest.config;

import com.google.common.base.Throwables;
import com.google.common.cache.LoadingCache;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Provider;
import com.google.inject.TypeLiteral;
import com.google.inject.name.Names;
import java.lang.annotation.Annotation;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.concurrent.internal.SyncProxy;
import org.jclouds.internal.ClassMethodArgs;

@Singleton
public class ClientProvider<S, A>
implements Provider<S> {
    @Inject
    Injector injector;
    private final Class<S> syncClientType;
    private final Class<A> asyncClientType;
    private final Map<Class<?>, Class<?>> sync2Async;

    @Inject
    ClientProvider(Class<S> syncClientType, Class<A> asyncClientType, Map<Class<?>, Class<?>> sync2Async) {
        this.asyncClientType = asyncClientType;
        this.syncClientType = syncClientType;
        this.sync2Async = sync2Async;
    }

    @Singleton
    public S get() {
        Object client = this.injector.getInstance(Key.get(this.asyncClientType));
        LoadingCache delegateMap = (LoadingCache)this.injector.getInstance(Key.get((TypeLiteral)new TypeLiteral<LoadingCache<ClassMethodArgs, Object>>(){}, (Annotation)Names.named((String)"sync")));
        try {
            return SyncProxy.proxy(this.syncClientType, client, (LoadingCache<ClassMethodArgs, Object>)delegateMap, this.sync2Async, (Map)this.injector.getInstance(Key.get((TypeLiteral)new TypeLiteral<Map<String, Long>>(){}, (Annotation)Names.named((String)"TIMEOUTS"))));
        }
        catch (Exception e) {
            Throwables.propagate((Throwable)e);
            assert (false) : "should have propagated";
            return null;
        }
    }
}

